/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumns;

import java.util.Date;

public enum ColumnTypes {
    String,
    Double,
    Long,
    Date,
    DateTime,
    Boolean,
    Time;


    public static Class toType(ColumnTypes columnType) {
        switch (columnType) {
            case String: {
                return String.class;
            }
            case Double: {
                return java.lang.Double.TYPE;
            }
            case Long: {
                return java.lang.Long.TYPE;
            }
            case Date: {
                return Date.class;
            }
            case DateTime: {
                return Date.class;
            }
            case Boolean: {
                return java.lang.Boolean.TYPE;
            }
            case Time: {
                return Date.class;
            }
        }
        throw new IllegalArgumentException(java.lang.String.format("Unknown column type %s", columnType.toString()));
    }

    public static ColumnTypes from(String s2) {
        if (s2.contentEquals("String")) {
            return String;
        }
        if (s2.contentEquals("Double")) {
            return Double;
        }
        if (s2.contentEquals("Long")) {
            return Long;
        }
        if (s2.contentEquals("Date")) {
            return Date;
        }
        if (s2.contentEquals("DateTime")) {
            return DateTime;
        }
        if (s2.contentEquals("Boolean")) {
            return Boolean;
        }
        if (s2.contentEquals("Time")) {
            return Time;
        }
        throw new IllegalArgumentException(java.lang.String.format("%s cannot be converted to a ColumnTypes", s2));
    }

    public static ColumnTypes from(com.exponam.core.protobuf.trailer.ColumnTypes protoColumnType) {
        switch (protoColumnType) {
            case String: {
                return String;
            }
            case Double: {
                return Double;
            }
            case Long: {
                return Long;
            }
            case Date: {
                return Date;
            }
            case DateTime: {
                return DateTime;
            }
            case Boolean: {
                return Boolean;
            }
            case Time: {
                return Time;
            }
        }
        throw new IllegalArgumentException(java.lang.String.format("%s cannot be converted to a ColumnTypes", protoColumnType.toString()));
    }
}

