/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.times;

import com.exponam.core.internalColumns.InternalColumn;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class InternalTimeColumnSegmentUtilities {
    public static final Date EMPTY_TIME = new Time(-1L);
    public static final Integer Empty = Integer.MIN_VALUE;
    private static Calendar epochCalendar = new GregorianCalendar(1970, 0, 1, 0, 0);
    public static final Date EPOCH = epochCalendar.getTime();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    public static Function<Date, Integer> toAtRest = InternalTimeColumnSegmentUtilities::sinceBasis;
    public static Function<Integer, Date> toInMemory = InternalTimeColumnSegmentUtilities::fromBasis;
    public static BiFunction<Integer, InternalColumn, String> atRestToString = (value, column) -> {
        if (value.equals(Empty)) {
            return "";
        }
        Date date = InternalTimeColumnSegmentUtilities.fromBasis(value);
        if (StringUtils.isEmpty((CharSequence)column.getJavaCompatibleDisplayMask())) {
            return sdf.format(date);
        }
        SimpleDateFormat displaySdf = new SimpleDateFormat(column.getJavaCompatibleDisplayMask());
        return displaySdf.format(date);
    };

    private static Integer sinceBasis(Date dt) {
        if (dt.equals(EMPTY_TIME)) {
            return Empty;
        }
        return (int)(dt.getTime() - EPOCH.getTime());
    }

    private static Date fromBasis(Integer dt) {
        if (dt.equals(Empty)) {
            return EMPTY_TIME;
        }
        LocalTime lt = LocalTime.ofNanoOfDay((long)dt.intValue() * 1000L * 1000L);
        return InternalTimeColumnSegmentUtilities.fromLocalTime(lt);
    }

    public static Time fromLocalTime(LocalTime localTime) {
        long epochMillis = localTime.atDate(LocalDate.ofEpochDay(0L)).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return new Time(epochMillis);
    }
}

