/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.bool;

import com.exponam.core.internalColumnSegments.IndexedValuesBitFieldPacker;
import com.exponam.core.internalColumnSegments.bool.InternalBooleanColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.BooleanAllValuesColumnSegment;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.Optional;

public class InternalBooleanAllValuesColumnSegment
extends InternalBooleanColumnSegmentBase {
    private static final int canonicalEmpty = 0;
    private static final int canonicalFalse = 1;
    private static final int canonicalTrue = 2;
    private static final int greatestZeroBasedEntryValue = 2;
    private final Integer numValues;
    private final long[] values;
    private IndexedValuesBitFieldPacker bitFieldPacker;

    InternalBooleanAllValuesColumnSegment(List<Optional<Boolean>> values) {
        this.numValues = values.size();
        this.values = IndexedValuesBitFieldPacker.packedEntries(2, this.numValues);
        for (int i = 0; i < this.numValues; ++i) {
            this.put(i, values.get(i));
        }
    }

    InternalBooleanAllValuesColumnSegment(BooleanAllValuesColumnSegment protoSegment) {
        this.numValues = protoSegment.getNumValues();
        List<Long> protoValuesList = protoSegment.getValuesList();
        this.values = new long[protoValuesList.size()];
        for (int i = 0; i < protoValuesList.size(); ++i) {
            this.values[i] = protoValuesList.get(i);
        }
    }

    @Override
    public int count() {
        return this.numValues;
    }

    private void put(int index, Optional<Boolean> value) {
        this.getBitFieldPacker().putValueForEntry(index, InternalBooleanAllValuesColumnSegment.convertBoolToEntryValue(value));
    }

    @Override
    protected Optional<Boolean> get(int index) {
        return InternalBooleanAllValuesColumnSegment.convertEntryValueToBool(this.getBitFieldPacker().getValueForEntry(index));
    }

    private IndexedValuesBitFieldPacker getBitFieldPacker() {
        if (this.bitFieldPacker != null) {
            return this.bitFieldPacker;
        }
        this.bitFieldPacker = new IndexedValuesBitFieldPacker(this.values, 2);
        return this.bitFieldPacker;
    }

    private static int convertBoolToEntryValue(Optional<Boolean> b) {
        if (!b.isPresent()) {
            return 0;
        }
        return b.get().equals(Boolean.TRUE) ? 2 : 1;
    }

    private static Optional<Boolean> convertEntryValueToBool(int entryValue) {
        switch (entryValue) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(Boolean.FALSE);
            }
            case 2: {
                return Optional.of(Boolean.TRUE);
            }
        }
        throw new IllegalArgumentException("Unrecognized entry value");
    }

    public int hashCode() {
        return this.numValues.hashCode() * 31 + this.values.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof InternalBooleanAllValuesColumnSegment)) {
            return false;
        }
        InternalBooleanAllValuesColumnSegment otherSegment = (InternalBooleanAllValuesColumnSegment)other;
        return this.numValues.equals(otherSegment.numValues) && this.values.equals(otherSegment.values);
    }

    @Override
    public ColumnSegmentBase toProto() {
        BooleanAllValuesColumnSegment protoSegment = BooleanAllValuesColumnSegment.newBuilder().setNumValues(this.numValues).addAllValues(Longs.asList(this.values)).build();
        return ColumnSegmentBase.newBuilder().mergeBooleanAllValuesColumnSegment(protoSegment).build();
    }
}

