/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

public class FileCheckSum {
    public static byte[] generateCheckSum(FileInputStream inputStream, List<SectionStartAndStop> sections) throws IOException {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            int bufferSize = 32768;
            byte[] buffer = new byte[32768];
            int lastSectionIndex = sections.size() - 1;
            for (int sectionIndex = 0; sectionIndex <= lastSectionIndex; ++sectionIndex) {
                SectionStartAndStop sectionStartAndStop = sections.get(sectionIndex);
                long totalAmountToHash = sectionStartAndStop.getStop() - sectionStartAndStop.getStart();
                long currentStartPosition = sectionStartAndStop.getStart();
                long amountHashed = 0L;
                long amountRemainingToBeHashed = totalAmountToHash;
                while (amountHashed < totalAmountToHash) {
                    int amountToRead = amountRemainingToBeHashed < 32768L ? (int)amountRemainingToBeHashed : 32768;
                    int amountRead = FileCheckSum.readPortionOfSection(inputStream, currentStartPosition, amountToRead, buffer);
                    if (amountRead != amountToRead) {
                        throw new IllegalArgumentException("Failed to generate checksum");
                    }
                    currentStartPosition += (long)amountToRead;
                    amountHashed += (long)amountToRead;
                    amountRemainingToBeHashed -= (long)amountToRead;
                    sha256.update(buffer, 0, amountToRead);
                }
            }
            return sha256.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int readPortionOfSection(FileInputStream inputStream, long startPosition, int portionLength, byte[] buffer) throws IOException {
        FileInputStream fileInputStream = inputStream;
        synchronized (fileInputStream) {
            inputStream.getChannel().position(startPosition);
            int amountRead = inputStream.read(buffer, 0, portionLength);
            return amountRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SectionStartAndStop> getHashableSections(FileInputStream inputStream) throws IOException {
        FileInputStream fileInputStream = inputStream;
        synchronized (fileInputStream) {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            long fileLength = inputStream.getChannel().size();
            long startOfTrailerUncompressedLengthPosition = fileLength - 4L;
            inputStream.getChannel().position(startOfTrailerUncompressedLengthPosition);
            int trailerUncompressedLength = Integer.reverseBytes(dataInputStream.readInt());
            long startOfTrailerUncompressedPosition = startOfTrailerUncompressedLengthPosition - (long)trailerUncompressedLength;
            long startOfSignaturePlaceholderPosition = startOfTrailerUncompressedPosition + 4L;
            long positionAfterSignaturePlaceholder = startOfTrailerUncompressedLengthPosition - 0L;
            return Arrays.asList(new SectionStartAndStop(0L, startOfSignaturePlaceholderPosition), new SectionStartAndStop(positionAfterSignaturePlaceholder, fileLength));
        }
    }

    public static class SectionStartAndStop {
        private final long start;
        private final long stop;

        public SectionStartAndStop(long start, long stop) {
            this.start = start;
            this.stop = stop;
        }

        public long getStart() {
            return this.start;
        }

        public long getStop() {
            return this.stop;
        }
    }
}

