/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.datetimes;

import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;
import com.exponam.core.internalColumnSegments.datetimes.InternalDateTimeColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentIndex;
import com.exponam.core.protobuf.columnsegments.DateTimeWithLocalDictionaryColumnSegment;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Longs;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

public class InternalDateTimeWithLocalDictionaryColumnSegment
extends ColumnSegmentWithSortedValues<Timestamp, Long> {
    private Long[] sortedValues;
    private long[] packedIndex;
    private int numValues;
    private InternalColumnSegmentIndex index;

    InternalDateTimeWithLocalDictionaryColumnSegment(int numRowsInSegment, Map<Timestamp, List<Integer>> valuesAndRows, ColumnSegmentBuilderHint columnSegmentBuilderHint) {
        super(InternalDateTimeColumnSegmentUtilities.toAtRest, InternalDateTimeColumnSegmentUtilities.toInMemory);
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, list -> {
            this.sortedValues = list.toArray(new Long[0]);
        }, packed -> {
            this.packedIndex = packed;
        }, columnSegmentBuilderHint, index -> {
            this.index = index;
        });
    }

    InternalDateTimeWithLocalDictionaryColumnSegment(DateTimeWithLocalDictionaryColumnSegment protoSegment) {
        super(InternalDateTimeColumnSegmentUtilities.toAtRest, InternalDateTimeColumnSegmentUtilities.toInMemory);
        this.numValues = protoSegment.getNumValues();
        this.sortedValues = protoSegment.getLongsList().toArray(new Long[0]);
        this.packedIndex = InternalDateTimeWithLocalDictionaryColumnSegment.toArray(protoSegment.getPackedIndexList());
        this.index = InternalColumnSegmentIndex.fromProto(protoSegment.getIndex());
    }

    protected Long[] sortedValues() {
        return this.sortedValues;
    }

    @Override
    protected long[] packedIndex() {
        return this.packedIndex;
    }

    @Override
    protected InternalColumnSegmentIndex index() {
        return this.index;
    }

    @Override
    protected boolean isValueEmpty(Long value) {
        return value.equals(InternalDateTimeColumnSegmentUtilities.Empty);
    }

    @Override
    protected String valueToString(Long value) {
        return InternalDateTimeColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public ColumnSegmentBase toProto() {
        DateTimeWithLocalDictionaryColumnSegment.Builder builder = DateTimeWithLocalDictionaryColumnSegment.newBuilder().addAllLongs(() -> Iterators.forArray(this.sortedValues)).addAllPackedIndex(Longs.asList(this.packedIndex)).setNumValues(this.numValues);
        ColumnSegmentIndex protoIndex = InternalColumnSegmentIndex.toProto(this.index);
        if (protoIndex != null) {
            builder.setIndex(protoIndex);
        }
        DateTimeWithLocalDictionaryColumnSegment protoSegment = builder.build();
        return ColumnSegmentBase.newBuilder().mergeDateTimeWithLocalDictionaryColumnSegment(protoSegment).build();
    }
}

