/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.dates;

import com.exponam.core.internalColumns.InternalColumn;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class InternalDateColumnSegmentUtilities {
    public static final LocalDate DateBasis = InternalDateColumnSegmentUtilities.getDateBasis();
    public static final Date EmptyDate = java.sql.Date.valueOf(DateBasis);
    public static final Integer Empty = Integer.MIN_VALUE;
    private static final DateFormat sdf = DateFormat.getDateInstance(3);
    static Function<Date, Integer> toAtRest = InternalDateColumnSegmentUtilities::daysSinceDateBasis;
    static Function<Integer, Date> toInMemory = InternalDateColumnSegmentUtilities::fromDaysSinceDateBasis;
    public static BiFunction<Integer, InternalColumn, String> atRestToString = (value, column) -> {
        if (value.equals(Empty)) {
            return "";
        }
        Date date = InternalDateColumnSegmentUtilities.fromDaysSinceDateBasis(value);
        if (StringUtils.isEmpty((CharSequence)column.getJavaCompatibleDisplayMask())) {
            return sdf.format(date);
        }
        SimpleDateFormat displaySdf = new SimpleDateFormat(column.getJavaCompatibleDisplayMask());
        return displaySdf.format(date);
    };

    private static Integer daysSinceDateBasis(Date date) {
        if (date.equals(EmptyDate)) {
            return Empty;
        }
        LocalDate dateAsLocalDate = new java.sql.Date(date.getTime()).toLocalDate();
        return (int)ChronoUnit.DAYS.between(DateBasis, dateAsLocalDate);
    }

    private static Date fromDaysSinceDateBasis(Integer days) {
        if (days.equals(Empty)) {
            return EmptyDate;
        }
        LocalDate adjusted = DateBasis.plusDays(days.intValue());
        return java.sql.Date.valueOf(adjusted);
    }

    private static LocalDate getDateBasis() {
        LocalDate ld = LocalDate.of(1, 1, 1);
        return ld;
    }
}

