/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring;

import com.expediagroup.graphql.dataloader.KotlinDataLoader;
import com.expediagroup.graphql.dataloader.KotlinDataLoaderRegistryFactory;
import com.expediagroup.graphql.generator.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.execution.SpringKotlinDataFetcherFactoryProvider;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={GraphQLConfigurationProperties.class})
@Import(value={JacksonAutoConfiguration.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\tH\u0017J,\u0010\n\u001a\u00020\u000b2\u001a\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017\u00a8\u0006\u0012"}, d2={"Lcom/expediagroup/graphql/server/spring/GraphQLExecutionConfiguration;", "", "<init>", "()V", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "exceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "dataLoaderRegistryFactory", "Lcom/expediagroup/graphql/dataloader/KotlinDataLoaderRegistryFactory;", "dataLoaders", "Ljava/util/Optional;", "", "Lcom/expediagroup/graphql/dataloader/KotlinDataLoader;", "config", "Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;", "graphql-kotlin-spring-server"})
public class GraphQLExecutionConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return (KotlinDataFetcherFactoryProvider)new SpringKotlinDataFetcherFactoryProvider(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler exceptionHandler() {
        return (DataFetcherExceptionHandler)new SimpleDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public KotlinDataLoaderRegistryFactory dataLoaderRegistryFactory(@NotNull Optional<List<KotlinDataLoader<?, ?>>> dataLoaders, @NotNull GraphQLConfigurationProperties config) {
        Intrinsics.checkNotNullParameter(dataLoaders, (String)"dataLoaders");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List list = dataLoaders.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"orElse(...)");
        return new KotlinDataLoaderRegistryFactory(list);
    }
}

