/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring;

import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.function.server.CoRouterFunctionDsl;
import org.springframework.web.reactive.function.server.CoRouterFunctionDslKt;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.function.server.ServerResponseExtensionsKt;

@ConditionalOnProperty(value={"graphql.playground.enabled"}, havingValue="true", matchIfMissing=true)
@Configuration
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0017R\u000e\u0010\t\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/expediagroup/graphql/server/spring/PlaygroundRouteConfiguration;", "", "config", "Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;", "playgroundHtml", "Lorg/springframework/core/io/Resource;", "contextPath", "", "(Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;Lorg/springframework/core/io/Resource;Ljava/lang/String;)V", "body", "playgroundRoute", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "graphql-kotlin-spring-server"})
public class PlaygroundRouteConfiguration {
    @NotNull
    private final GraphQLConfigurationProperties config;
    @NotNull
    private final Resource playgroundHtml;
    @Nullable
    private final String contextPath;
    @NotNull
    private final String body;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaygroundRouteConfiguration(@NotNull GraphQLConfigurationProperties config, @Value(value="classpath:/graphql-playground.html") @NotNull Resource playgroundHtml, @Value(value="${spring.webflux.base-path:#{null}}") @Nullable String contextPath) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)playgroundHtml, (String)"playgroundHtml");
        this.config = config;
        this.playgroundHtml = playgroundHtml;
        this.contextPath = contextPath;
        InputStream inputStream = this.playgroundHtml.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"playgroundHtml.inputStream");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        PlaygroundRouteConfiguration playgroundRouteConfiguration = this;
        object = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            CharSequence charSequence = this.contextPath;
            String graphQLEndpoint = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.config.getEndpoint() : this.contextPath + '/' + this.config.getEndpoint();
            CharSequence charSequence2 = this.contextPath;
            String subscriptionsEndpoint = charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2) ? this.config.getSubscriptions().getEndpoint() : this.contextPath + '/' + this.config.getSubscriptions().getEndpoint();
            object2 = StringsKt.replace$default((String)StringsKt.replace$default((String)TextStreamsKt.readText((Reader)reader), (String)"${graphQLEndpoint}", (String)graphQLEndpoint, (boolean)false, (int)4, null), (String)"${subscriptionsEndpoint}", (String)subscriptionsEndpoint, (boolean)false, (int)4, null);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        playgroundRouteConfiguration.body = object2;
    }

    @Bean
    @NotNull
    public RouterFunction<ServerResponse> playgroundRoute() {
        return CoRouterFunctionDslKt.coRouter((Function1)((Function1)new Function1<CoRouterFunctionDsl, Unit>(this){
            final /* synthetic */ PlaygroundRouteConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CoRouterFunctionDsl $this$coRouter) {
                Intrinsics.checkNotNullParameter((Object)$this$coRouter, (String)"$this$coRouter");
                $this$coRouter.GET(PlaygroundRouteConfiguration.access$getConfig$p(this.this$0).getPlayground().getEndpoint(), (Function2)new Function2<ServerRequest, Continuation<? super ServerResponse>, Object>($this$coRouter, this.this$0, null){
                    int label;
                    final /* synthetic */ CoRouterFunctionDsl $this_coRouter;
                    final /* synthetic */ PlaygroundRouteConfiguration this$0;
                    {
                        this.$this_coRouter = $this_coRouter;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = ServerResponseExtensionsKt.bodyValueAndAwait((ServerResponse.BodyBuilder)ServerResponseExtensionsKt.html((ServerResponse.BodyBuilder)this.$this_coRouter.ok()), (Object)PlaygroundRouteConfiguration.access$getBody$p(this.this$0), (Continuation)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull ServerRequest p1, @Nullable Continuation<? super ServerResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            }
        }));
    }

    public static final /* synthetic */ GraphQLConfigurationProperties access$getConfig$p(PlaygroundRouteConfiguration $this) {
        return $this.config;
    }

    public static final /* synthetic */ String access$getBody$p(PlaygroundRouteConfiguration $this) {
        return $this.body;
    }
}

