/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring;

import com.expediagroup.graphql.generator.SchemaGeneratorConfig;
import com.expediagroup.graphql.generator.ToSchemaKt;
import com.expediagroup.graphql.generator.TopLevelNames;
import com.expediagroup.graphql.generator.TopLevelObject;
import com.expediagroup.graphql.generator.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.generator.extensions.GraphQLSchemaExtensionsKt;
import com.expediagroup.graphql.generator.hooks.NoopSchemaGeneratorHooks;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.server.operations.Mutation;
import com.expediagroup.graphql.server.operations.Query;
import com.expediagroup.graphql.server.operations.Subscription;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.GraphQLExecutionConfiguration;
import com.expediagroup.graphql.server.spring.extensions.GeneratorExtensionsKt;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@ConditionalOnProperty(value={"graphql.federation.enabled"}, havingValue="false", matchIfMissing=true)
@Configuration
@Import(value={GraphQLExecutionConfiguration.class})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\t2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J4\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/expediagroup/graphql/server/spring/NonFederatedSchemaAutoConfiguration;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "schema", "Lgraphql/schema/GraphQLSchema;", "queries", "Ljava/util/Optional;", "", "Lcom/expediagroup/graphql/server/operations/Query;", "mutations", "Lcom/expediagroup/graphql/server/operations/Mutation;", "subscriptions", "Lcom/expediagroup/graphql/server/operations/Subscription;", "schemaConfig", "Lcom/expediagroup/graphql/generator/SchemaGeneratorConfig;", "config", "Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;", "topLevelNames", "Lcom/expediagroup/graphql/generator/TopLevelNames;", "hooks", "Lcom/expediagroup/graphql/generator/hooks/SchemaGeneratorHooks;", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;", "graphql-kotlin-spring-server"})
public class NonFederatedSchemaAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(NonFederatedSchemaAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SchemaGeneratorConfig schemaConfig(@NotNull GraphQLConfigurationProperties config, @NotNull Optional<TopLevelNames> topLevelNames, @NotNull Optional<SchemaGeneratorHooks> hooks, @NotNull KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(topLevelNames, (String)"topLevelNames");
        Intrinsics.checkNotNullParameter(hooks, (String)"hooks");
        Intrinsics.checkNotNullParameter((Object)dataFetcherFactoryProvider, (String)"dataFetcherFactoryProvider");
        SchemaGeneratorHooks generatorHooks = hooks.orElse((SchemaGeneratorHooks)NoopSchemaGeneratorHooks.INSTANCE);
        List<String> list = config.getPackages();
        TopLevelNames topLevelNames2 = topLevelNames.orElse(new TopLevelNames(null, null, null, 7, null));
        Intrinsics.checkNotNullExpressionValue((Object)topLevelNames2, (String)"topLevelNames.orElse(TopLevelNames())");
        Intrinsics.checkNotNullExpressionValue((Object)generatorHooks, (String)"generatorHooks");
        return new SchemaGeneratorConfig(list, topLevelNames2, generatorHooks, dataFetcherFactoryProvider, config.getIntrospection().getEnabled(), null, 32, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull Optional<List<Query>> queries, @NotNull Optional<List<Mutation>> mutations, @NotNull Optional<List<Subscription>> subscriptions, @NotNull SchemaGeneratorConfig schemaConfig) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        Intrinsics.checkNotNullParameter(mutations, (String)"mutations");
        Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        List<Query> list = queries.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"queries.orElse(emptyList())");
        List<TopLevelObject> list2 = GeneratorExtensionsKt.toTopLevelObjects(list);
        list = mutations.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"mutations.orElse(emptyList())");
        List<TopLevelObject> list3 = GeneratorExtensionsKt.toTopLevelObjects(list);
        list = subscriptions.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"subscriptions.orElse(emptyList())");
        GraphQLSchema schema = ToSchemaKt.toSchema((SchemaGeneratorConfig)schemaConfig, list2, list3, GeneratorExtensionsKt.toTopLevelObjects(list));
        this.logger.info(Intrinsics.stringPlus((String)"\n", (Object)GraphQLSchemaExtensionsKt.print$default((GraphQLSchema)schema, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (int)63, null)));
        return schema;
    }
}

