/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring;

import com.apollographql.federation.graphqljava.tracing.FederatedTracingInstrumentation;
import com.expediagroup.graphql.generator.TopLevelNames;
import com.expediagroup.graphql.generator.TopLevelObject;
import com.expediagroup.graphql.generator.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.generator.extensions.GraphQLSchemaExtensionsKt;
import com.expediagroup.graphql.generator.federation.FederatedSchemaGeneratorConfig;
import com.expediagroup.graphql.generator.federation.FederatedSchemaGeneratorHooks;
import com.expediagroup.graphql.generator.federation.ToFederatedSchemaKt;
import com.expediagroup.graphql.generator.federation.execution.FederatedTypeResolver;
import com.expediagroup.graphql.server.operations.Mutation;
import com.expediagroup.graphql.server.operations.Query;
import com.expediagroup.graphql.server.operations.Subscription;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.GraphQLExecutionConfiguration;
import com.expediagroup.graphql.server.spring.extensions.GeneratorExtensionsKt;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@ConditionalOnProperty(value={"graphql.federation.enabled"}, havingValue="true")
@Configuration
@Import(value={GraphQLExecutionConfiguration.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J \u0010\u0011\u001a\u00020\u000b2\u0016\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00130\rH\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0017JL\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00130\r2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00130\r2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00130\r2\u0006\u0010\u001f\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/expediagroup/graphql/server/spring/FederatedSchemaAutoConfiguration;", "", "config", "Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;", "(Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "federatedSchemaConfig", "Lcom/expediagroup/graphql/generator/federation/FederatedSchemaGeneratorConfig;", "hooks", "Lcom/expediagroup/graphql/generator/federation/FederatedSchemaGeneratorHooks;", "topLevelNames", "Ljava/util/Optional;", "Lcom/expediagroup/graphql/generator/TopLevelNames;", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;", "federatedSchemaGeneratorHooks", "resolvers", "", "Lcom/expediagroup/graphql/generator/federation/execution/FederatedTypeResolver;", "federatedTracing", "Lcom/apollographql/federation/graphqljava/tracing/FederatedTracingInstrumentation;", "schema", "Lgraphql/schema/GraphQLSchema;", "queries", "Lcom/expediagroup/graphql/server/operations/Query;", "mutations", "Lcom/expediagroup/graphql/server/operations/Mutation;", "subscriptions", "Lcom/expediagroup/graphql/server/operations/Subscription;", "schemaConfig", "graphql-kotlin-spring-server"})
public class FederatedSchemaAutoConfiguration {
    @NotNull
    private final GraphQLConfigurationProperties config;
    private final Logger logger;

    public FederatedSchemaAutoConfiguration(@NotNull GraphQLConfigurationProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.logger = LoggerFactory.getLogger(FederatedSchemaAutoConfiguration.class);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FederatedSchemaGeneratorHooks federatedSchemaGeneratorHooks(@NotNull Optional<List<FederatedTypeResolver<?>>> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
        List list = resolvers.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolvers.orElse(emptyList())");
        return new FederatedSchemaGeneratorHooks(list);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FederatedSchemaGeneratorConfig federatedSchemaConfig(@NotNull FederatedSchemaGeneratorHooks hooks, @NotNull Optional<TopLevelNames> topLevelNames, @NotNull KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider) {
        Intrinsics.checkNotNullParameter((Object)hooks, (String)"hooks");
        Intrinsics.checkNotNullParameter(topLevelNames, (String)"topLevelNames");
        Intrinsics.checkNotNullParameter((Object)dataFetcherFactoryProvider, (String)"dataFetcherFactoryProvider");
        List<String> list = this.config.getPackages();
        TopLevelNames topLevelNames2 = topLevelNames.orElse(new TopLevelNames(null, null, null, 7, null));
        Intrinsics.checkNotNullExpressionValue((Object)topLevelNames2, (String)"topLevelNames.orElse(TopLevelNames())");
        return new FederatedSchemaGeneratorConfig(list, topLevelNames2, hooks, dataFetcherFactoryProvider, this.config.getIntrospection().getEnabled());
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull Optional<List<Query>> queries, @NotNull Optional<List<Mutation>> mutations, @NotNull Optional<List<Subscription>> subscriptions, @NotNull FederatedSchemaGeneratorConfig schemaConfig) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        Intrinsics.checkNotNullParameter(mutations, (String)"mutations");
        Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        List<Query> list = queries.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"queries.orElse(emptyList())");
        List<TopLevelObject> list2 = GeneratorExtensionsKt.toTopLevelObjects(list);
        list = mutations.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"mutations.orElse(emptyList())");
        List<TopLevelObject> list3 = GeneratorExtensionsKt.toTopLevelObjects(list);
        list = subscriptions.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"subscriptions.orElse(emptyList())");
        GraphQLSchema schema = ToFederatedSchemaKt.toFederatedSchema((FederatedSchemaGeneratorConfig)schemaConfig, list2, list3, GeneratorExtensionsKt.toTopLevelObjects(list));
        this.logger.info(Intrinsics.stringPlus((String)"\n", (Object)GraphQLSchemaExtensionsKt.print$default((GraphQLSchema)schema, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (int)63, null)));
        return schema;
    }

    @Bean
    @ConditionalOnProperty(value={"graphql.federation.tracing.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public FederatedTracingInstrumentation federatedTracing() {
        return new FederatedTracingInstrumentation(new FederatedTracingInstrumentation.Options(this.config.getFederation().getTracing().getDebug()));
    }
}

