/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring.subscriptions;

import com.expediagroup.graphql.generator.execution.GraphQLContext;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.subscriptions.ApolloSubscriptionHooks;
import com.expediagroup.graphql.server.spring.subscriptions.ApolloSubscriptionSessionState;
import com.expediagroup.graphql.server.spring.subscriptions.SpringGraphQLSubscriptionHandler;
import com.expediagroup.graphql.server.spring.subscriptions.SpringSubscriptionGraphQLContextFactory;
import com.expediagroup.graphql.server.spring.subscriptions.SubscriptionOperationMessage;
import com.expediagroup.graphql.server.spring.subscriptions.SubscriptionUtilsKt;
import com.expediagroup.graphql.server.types.GraphQLRequest;
import com.expediagroup.graphql.server.types.GraphQLResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.reactor.ReactorFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\n\u0010$\u001a\u00060%j\u0002`&H\u0002J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionProtocolHandler;", "", "config", "Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;", "contextFactory", "Lcom/expediagroup/graphql/server/spring/subscriptions/SpringSubscriptionGraphQLContextFactory;", "subscriptionHandler", "Lcom/expediagroup/graphql/server/spring/subscriptions/SpringGraphQLSubscriptionHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "subscriptionHooks", "Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionHooks;", "(Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;Lcom/expediagroup/graphql/server/spring/subscriptions/SpringSubscriptionGraphQLContextFactory;Lcom/expediagroup/graphql/server/spring/subscriptions/SpringGraphQLSubscriptionHandler;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionHooks;)V", "acknowledgeMessage", "Lcom/expediagroup/graphql/server/spring/subscriptions/SubscriptionOperationMessage;", "basicConnectionErrorMessage", "keepAliveMessage", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sessionState", "Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionSessionState;", "convertToMessageOrNull", "payload", "", "getConnectionErrorMessage", "operationMessage", "getKeepAliveFlux", "Lreactor/core/publisher/Flux;", "session", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "handle", "onComplete", "Lreactor/core/publisher/Mono;", "onDisconnect", "onException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onInit", "onStop", "onUnknownOperation", "saveContext", "", "startSubscription", "graphql-kotlin-spring-server"})
public final class ApolloSubscriptionProtocolHandler {
    @NotNull
    private final GraphQLConfigurationProperties config;
    @NotNull
    private final SpringSubscriptionGraphQLContextFactory<?> contextFactory;
    @NotNull
    private final SpringGraphQLSubscriptionHandler subscriptionHandler;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ApolloSubscriptionHooks subscriptionHooks;
    @NotNull
    private final ApolloSubscriptionSessionState sessionState;
    private final Logger logger;
    @NotNull
    private final SubscriptionOperationMessage keepAliveMessage;
    @NotNull
    private final SubscriptionOperationMessage basicConnectionErrorMessage;
    @NotNull
    private final SubscriptionOperationMessage acknowledgeMessage;

    public ApolloSubscriptionProtocolHandler(@NotNull GraphQLConfigurationProperties config, @NotNull SpringSubscriptionGraphQLContextFactory<?> contextFactory, @NotNull SpringGraphQLSubscriptionHandler subscriptionHandler, @NotNull ObjectMapper objectMapper, @NotNull ApolloSubscriptionHooks subscriptionHooks) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(contextFactory, (String)"contextFactory");
        Intrinsics.checkNotNullParameter((Object)subscriptionHandler, (String)"subscriptionHandler");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)subscriptionHooks, (String)"subscriptionHooks");
        this.config = config;
        this.contextFactory = contextFactory;
        this.subscriptionHandler = subscriptionHandler;
        this.objectMapper = objectMapper;
        this.subscriptionHooks = subscriptionHooks;
        this.sessionState = new ApolloSubscriptionSessionState();
        this.logger = LoggerFactory.getLogger(ApolloSubscriptionProtocolHandler.class);
        this.keepAliveMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_KEEP_ALIVE.getType(), null, null, 6, null);
        this.basicConnectionErrorMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), null, null, 6, null);
        this.acknowledgeMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ACK.getType(), null, null, 6, null);
    }

    @ExperimentalCoroutinesApi
    @NotNull
    public final Flux<SubscriptionOperationMessage> handle(@NotNull String payload, @NotNull WebSocketSession session) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Flux<SubscriptionOperationMessage> flux = this.convertToMessageOrNull(payload);
        if (flux == null) {
            Flux flux2 = Flux.just((Object)this.basicConnectionErrorMessage);
            Intrinsics.checkNotNullExpressionValue((Object)flux2, (String)"just(basicConnectionErrorMessage)");
            return flux2;
        }
        SubscriptionOperationMessage operationMessage = flux;
        this.logger.debug("GraphQL subscription client message, sessionId=" + session.getId() + " operationMessage=" + operationMessage);
        try {
            flux = operationMessage.getType();
            flux = Intrinsics.areEqual(flux, (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_INIT.getType()) ? this.onInit(operationMessage, session) : (Intrinsics.areEqual(flux, (Object)SubscriptionOperationMessage.ClientMessages.GQL_START.getType()) ? this.startSubscription(operationMessage, session) : (Intrinsics.areEqual(flux, (Object)SubscriptionOperationMessage.ClientMessages.GQL_STOP.getType()) ? this.onStop(operationMessage, session) : (Intrinsics.areEqual(flux, (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_TERMINATE.getType()) ? this.onDisconnect(session) : this.onUnknownOperation(operationMessage, session))));
        }
        catch (Exception exception) {
            flux = this.onException(exception);
        }
        return flux;
    }

    private final SubscriptionOperationMessage convertToMessageOrNull(String payload) {
        SubscriptionOperationMessage subscriptionOperationMessage;
        try {
            ObjectMapper $this$readValue$iv = this.objectMapper;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            subscriptionOperationMessage = (SubscriptionOperationMessage)$this$readValue$iv.readValue(payload, (TypeReference)new TypeReference<SubscriptionOperationMessage>(){});
        }
        catch (Exception exception) {
            this.logger.error("Error parsing the subscription message", (Throwable)exception);
            subscriptionOperationMessage = null;
        }
        return subscriptionOperationMessage;
    }

    private final Flux<SubscriptionOperationMessage> getKeepAliveFlux(WebSocketSession session) {
        Long keepAliveInterval = this.config.getSubscriptions().getKeepAliveInterval();
        if (keepAliveInterval != null) {
            Flux flux = Flux.interval((Duration)Duration.ofMillis(keepAliveInterval)).map(arg_0 -> ApolloSubscriptionProtocolHandler.getKeepAliveFlux$lambda-0(this, arg_0)).doOnSubscribe(arg_0 -> ApolloSubscriptionProtocolHandler.getKeepAliveFlux$lambda-1(this, session, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"interval(Duration.ofMill\u2026bscription(session, it) }");
            return flux;
        }
        Flux flux = Flux.empty();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"empty()");
        return flux;
    }

    private final Flux<SubscriptionOperationMessage> startSubscription(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        GraphQLContext context = this.sessionState.getContext(session);
        Map<?, Object> graphQLContext = this.sessionState.getGraphQLContext(session);
        this.subscriptionHooks.onOperation(operationMessage, session, context);
        this.subscriptionHooks.onOperationWithContext(operationMessage, session, graphQLContext);
        if (operationMessage.getId() == null) {
            this.logger.error("GraphQL subscription operation id is required");
            Flux flux = Flux.just((Object)this.basicConnectionErrorMessage);
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"just(basicConnectionErrorMessage)");
            return flux;
        }
        if (this.sessionState.doesOperationExist(session, operationMessage)) {
            this.logger.info("Already subscribed to operation " + operationMessage.getId() + " for session " + session.getId());
            Flux flux = Flux.empty();
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"empty()");
            return flux;
        }
        Object payload = operationMessage.getPayload();
        if (payload == null) {
            this.logger.error("GraphQL subscription payload was null instead of a GraphQLRequest object");
            this.sessionState.stopOperation(session, operationMessage);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"just(SubscriptionOperati\u2026d = operationMessage.id))");
            return flux;
        }
        try {
            ObjectMapper $this$convertValue$iv = this.objectMapper;
            boolean $i$f$convertValue = false;
            boolean $i$f$jacksonTypeRef = false;
            GraphQLRequest request = (GraphQLRequest)$this$convertValue$iv.convertValue(payload, (TypeReference)new TypeReference<GraphQLRequest>(){});
            Flux flux = ReactorFlowKt.asFlux$default(this.subscriptionHandler.executeSubscription(request, context, graphQLContext), null, (int)1, null).map(arg_0 -> ApolloSubscriptionProtocolHandler.startSubscription$lambda-2(operationMessage, arg_0)).concatWith((Publisher)FluxExtensionsKt.toFlux((Publisher)((Publisher)this.onComplete(operationMessage, session)))).doOnSubscribe(arg_0 -> ApolloSubscriptionProtocolHandler.startSubscription$lambda-3(this, session, operationMessage, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"subscriptionHandler.exec\u2026, operationMessage, it) }");
            return flux;
        }
        catch (Exception exception) {
            this.logger.error("Error running graphql subscription", (Throwable)exception);
            this.sessionState.stopOperation(session, operationMessage);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"just(SubscriptionOperati\u2026d = operationMessage.id))");
            return flux;
        }
    }

    private final Flux<SubscriptionOperationMessage> onInit(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        this.saveContext(operationMessage, session);
        Mono mono = Mono.just((Object)this.acknowledgeMessage);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(acknowledgeMessage)");
        Mono acknowledgeMessage = mono;
        Flux<SubscriptionOperationMessage> keepAliveFlux = this.getKeepAliveFlux(session);
        Flux flux = acknowledgeMessage.concatWith((Publisher)keepAliveFlux).onErrorReturn((Object)this.getConnectionErrorMessage(operationMessage));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"acknowledgeMessage.conca\u2026essage(operationMessage))");
        return flux;
    }

    private final void saveContext(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(operationMessage, this, session, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ SubscriptionOperationMessage $operationMessage;
            final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
            final /* synthetic */ WebSocketSession $session;
            {
                this.$operationMessage = $operationMessage;
                this.this$0 = $receiver;
                this.$session = $session;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        connectionParams = SubscriptionUtilsKt.castToMapOfStringString(this.$operationMessage.getPayload());
                        this.L$0 = connectionParams;
                        this.label = 1;
                        v0 = ApolloSubscriptionProtocolHandler.access$getContextFactory$p(this.this$0).generateContext(this.$session, (Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        connectionParams = (Map)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        context = (GraphQLContext)v0;
                        this.L$0 = connectionParams;
                        this.L$1 = context;
                        this.label = 2;
                        v1 = ApolloSubscriptionProtocolHandler.access$getContextFactory$p(this.this$0).generateContextMap((Object)this.$session, (Continuation)this);
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        context = (GraphQLContext)this.L$1;
                        connectionParams = (Map)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        graphQLContext = (Map)v1;
                        onConnectContext = ApolloSubscriptionProtocolHandler.access$getSubscriptionHooks$p(this.this$0).onConnect(connectionParams, this.$session, context);
                        onConnectGraphQLContext = ApolloSubscriptionProtocolHandler.access$getSubscriptionHooks$p(this.this$0).onConnectWithContext(connectionParams, this.$session, graphQLContext);
                        ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0).saveContext(this.$session, onConnectContext);
                        ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0).saveContextMap(this.$session, onConnectGraphQLContext);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final Mono<SubscriptionOperationMessage> onComplete(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        this.subscriptionHooks.onOperationComplete(session);
        return this.sessionState.completeOperation(session, operationMessage);
    }

    private final Flux<SubscriptionOperationMessage> onStop(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        this.subscriptionHooks.onOperationComplete(session);
        return FluxExtensionsKt.toFlux((Publisher)((Publisher)this.sessionState.stopOperation(session, operationMessage)));
    }

    private final Flux<SubscriptionOperationMessage> onDisconnect(WebSocketSession session) {
        this.subscriptionHooks.onDisconnect(session);
        this.sessionState.terminateSession(session);
        Flux flux = Flux.empty();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"empty()");
        return flux;
    }

    private final Flux<SubscriptionOperationMessage> onUnknownOperation(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        this.logger.error(Intrinsics.stringPlus((String)"Unknown subscription operation ", (Object)operationMessage));
        this.sessionState.stopOperation(session, operationMessage);
        Flux flux = Flux.just((Object)this.getConnectionErrorMessage(operationMessage));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"just(getConnectionErrorMessage(operationMessage))");
        return flux;
    }

    private final Flux<SubscriptionOperationMessage> onException(Exception exception) {
        this.logger.error("Error parsing the subscription message", (Throwable)exception);
        Flux flux = Flux.just((Object)this.basicConnectionErrorMessage);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"just(basicConnectionErrorMessage)");
        return flux;
    }

    private final SubscriptionOperationMessage getConnectionErrorMessage(SubscriptionOperationMessage operationMessage) {
        return new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null);
    }

    private static final SubscriptionOperationMessage getKeepAliveFlux$lambda-0(ApolloSubscriptionProtocolHandler this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.keepAliveMessage;
    }

    private static final void getKeepAliveFlux$lambda-1(ApolloSubscriptionProtocolHandler this$0, WebSocketSession $session, Subscription it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        ApolloSubscriptionSessionState apolloSubscriptionSessionState = this$0.sessionState;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        apolloSubscriptionSessionState.saveKeepAliveSubscription($session, it);
    }

    private static final SubscriptionOperationMessage startSubscription$lambda-2(SubscriptionOperationMessage $operationMessage, GraphQLResponse it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        List list = it.getErrors();
        if (list == null) {
            bl = false;
        } else {
            Collection collection = list;
            boolean bl2 = false;
            bl = !collection.isEmpty();
        }
        return bl ? new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_ERROR.getType(), $operationMessage.getId(), it) : new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_DATA.getType(), $operationMessage.getId(), it);
    }

    private static final void startSubscription$lambda-3(ApolloSubscriptionProtocolHandler this$0, WebSocketSession $session, SubscriptionOperationMessage $operationMessage, Subscription it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        ApolloSubscriptionSessionState apolloSubscriptionSessionState = this$0.sessionState;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        apolloSubscriptionSessionState.saveOperation($session, $operationMessage, it);
    }

    public static final /* synthetic */ SpringSubscriptionGraphQLContextFactory access$getContextFactory$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.contextFactory;
    }

    public static final /* synthetic */ ApolloSubscriptionHooks access$getSubscriptionHooks$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.subscriptionHooks;
    }

    public static final /* synthetic */ ApolloSubscriptionSessionState access$getSessionState$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.sessionState;
    }
}

