/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring.subscriptions;

import com.expediagroup.graphql.generator.execution.GraphQLContext;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.subscriptions.ApolloSubscriptionHooks;
import com.expediagroup.graphql.server.spring.subscriptions.ApolloSubscriptionSessionState;
import com.expediagroup.graphql.server.spring.subscriptions.SpringGraphQLSubscriptionHandler;
import com.expediagroup.graphql.server.spring.subscriptions.SpringSubscriptionGraphQLContextFactory;
import com.expediagroup.graphql.server.spring.subscriptions.SubscriptionOperationMessage;
import com.expediagroup.graphql.types.GraphQLRequest;
import com.expediagroup.graphql.types.GraphQLResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u001e\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0007J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\n\u0010&\u001a\u00060'j\u0002`(H\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionProtocolHandler;", "", "config", "Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;", "contextFactory", "Lcom/expediagroup/graphql/server/spring/subscriptions/SpringSubscriptionGraphQLContextFactory;", "subscriptionHandler", "Lcom/expediagroup/graphql/server/spring/subscriptions/SpringGraphQLSubscriptionHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "subscriptionHooks", "Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionHooks;", "(Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;Lcom/expediagroup/graphql/server/spring/subscriptions/SpringSubscriptionGraphQLContextFactory;Lcom/expediagroup/graphql/server/spring/subscriptions/SpringGraphQLSubscriptionHandler;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionHooks;)V", "acknowledgeMessage", "Lcom/expediagroup/graphql/server/spring/subscriptions/SubscriptionOperationMessage;", "basicConnectionErrorMessage", "keepAliveMessage", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sessionState", "Lcom/expediagroup/graphql/server/spring/subscriptions/ApolloSubscriptionSessionState;", "convertToMessageOrNull", "payload", "", "getConnectionErrorMessage", "operationMessage", "getConnectionParams", "", "getKeepAliveFlux", "Lreactor/core/publisher/Flux;", "session", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "handle", "onComplete", "Lreactor/core/publisher/Mono;", "onDisconnect", "onException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onInit", "onStop", "onUnknownOperation", "saveContext", "", "startSubscription", "graphql-kotlin-spring-server"})
public final class ApolloSubscriptionProtocolHandler {
    private final ApolloSubscriptionSessionState sessionState;
    private final Logger logger;
    private final SubscriptionOperationMessage keepAliveMessage;
    private final SubscriptionOperationMessage basicConnectionErrorMessage;
    private final SubscriptionOperationMessage acknowledgeMessage;
    private final GraphQLConfigurationProperties config;
    private final SpringSubscriptionGraphQLContextFactory<?> contextFactory;
    private final SpringGraphQLSubscriptionHandler subscriptionHandler;
    private final ObjectMapper objectMapper;
    private final ApolloSubscriptionHooks subscriptionHooks;

    @ExperimentalCoroutinesApi
    @NotNull
    public final Flux<SubscriptionOperationMessage> handle(@NotNull String payload, @NotNull WebSocketSession session) {
        Flux<SubscriptionOperationMessage> flux;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        SubscriptionOperationMessage subscriptionOperationMessage = this.convertToMessageOrNull(payload);
        if (subscriptionOperationMessage == null) {
            Flux flux2 = Flux.just((Object)this.basicConnectionErrorMessage);
            Intrinsics.checkNotNullExpressionValue((Object)flux2, (String)"Flux.just(basicConnectionErrorMessage)");
            return flux2;
        }
        SubscriptionOperationMessage operationMessage = subscriptionOperationMessage;
        this.logger.debug("GraphQL subscription client message, sessionId=" + session.getId() + " operationMessage=" + operationMessage);
        try {
            flux = operationMessage.getType();
            flux = Intrinsics.areEqual(flux, (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_INIT.getType()) ? this.onInit(operationMessage, session) : (Intrinsics.areEqual(flux, (Object)SubscriptionOperationMessage.ClientMessages.GQL_START.getType()) ? this.startSubscription(operationMessage, session) : (Intrinsics.areEqual(flux, (Object)SubscriptionOperationMessage.ClientMessages.GQL_STOP.getType()) ? this.onStop(operationMessage, session) : (Intrinsics.areEqual(flux, (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_TERMINATE.getType()) ? this.onDisconnect(session) : this.onUnknownOperation(operationMessage, session))));
        }
        catch (Exception exception) {
            flux = this.onException(exception);
        }
        return flux;
    }

    private final SubscriptionOperationMessage convertToMessageOrNull(String payload) {
        SubscriptionOperationMessage subscriptionOperationMessage;
        try {
            ObjectMapper $this$readValue$iv = this.objectMapper;
            boolean $i$f$readValue = false;
            String string = payload;
            ObjectMapper objectMapper = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<SubscriptionOperationMessage>(){};
            subscriptionOperationMessage = (SubscriptionOperationMessage)objectMapper.readValue(string, typeReference);
        }
        catch (Exception exception) {
            this.logger.error("Error parsing the subscription message", (Throwable)exception);
            subscriptionOperationMessage = null;
        }
        return subscriptionOperationMessage;
    }

    private final Flux<SubscriptionOperationMessage> getKeepAliveFlux(WebSocketSession session) {
        Long keepAliveInterval = this.config.getSubscriptions().getKeepAliveInterval();
        if (keepAliveInterval != null) {
            Flux flux = Flux.interval((Duration)Duration.ofMillis(keepAliveInterval)).map((Function)new Function<Long, SubscriptionOperationMessage>(this){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;

                public final SubscriptionOperationMessage apply(Long it) {
                    return ApolloSubscriptionProtocolHandler.access$getKeepAliveMessage$p(this.this$0);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                }
            }).doOnSubscribe((Consumer)new Consumer<Subscription>(this, session){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                final /* synthetic */ WebSocketSession $session;

                public final void accept(Subscription it) {
                    ApolloSubscriptionSessionState apolloSubscriptionSessionState = ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0);
                    Subscription subscription = it;
                    Intrinsics.checkNotNullExpressionValue((Object)subscription, (String)"it");
                    apolloSubscriptionSessionState.saveKeepAliveSubscription(this.$session, subscription);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                    this.$session = webSocketSession;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"Flux.interval(Duration.o\u2026bscription(session, it) }");
            return flux;
        }
        Flux flux = Flux.empty();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"Flux.empty()");
        return flux;
    }

    private final Flux<SubscriptionOperationMessage> startSubscription(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        GraphQLContext context = this.sessionState.getContext(session);
        this.subscriptionHooks.onOperation(operationMessage, session, context);
        if (operationMessage.getId() == null) {
            this.logger.error("GraphQL subscription operation id is required");
            Flux flux = Flux.just((Object)this.basicConnectionErrorMessage);
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"Flux.just(basicConnectionErrorMessage)");
            return flux;
        }
        if (this.sessionState.doesOperationExist(session, operationMessage)) {
            this.logger.info("Already subscribed to operation " + operationMessage.getId() + " for session " + session.getId());
            Flux flux = Flux.empty();
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"Flux.empty()");
            return flux;
        }
        Object payload = operationMessage.getPayload();
        if (payload == null) {
            this.logger.error("GraphQL subscription payload was null instead of a GraphQLRequest object");
            this.sessionState.stopOperation(session, operationMessage);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            return flux;
        }
        try {
            ObjectMapper $this$convertValue$iv = this.objectMapper;
            boolean $i$f$convertValue = false;
            Object object = payload;
            ObjectMapper objectMapper = $this$convertValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<GraphQLRequest>(){};
            GraphQLRequest request = (GraphQLRequest)objectMapper.convertValue(object, typeReference);
            Flux flux = FluxExtensionsKt.toFlux((Publisher)((Publisher)this.subscriptionHandler.executeSubscription(request, context))).map(new Function<GraphQLResponse<?>, SubscriptionOperationMessage>(operationMessage){
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final SubscriptionOperationMessage apply(GraphQLResponse<?> it) {
                    SubscriptionOperationMessage subscriptionOperationMessage;
                    List list = it.getErrors();
                    if (list != null) {
                        Collection collection = list;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            subscriptionOperationMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_ERROR.getType(), this.$operationMessage.getId(), it);
                            return subscriptionOperationMessage;
                        }
                    }
                    subscriptionOperationMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_DATA.getType(), this.$operationMessage.getId(), it);
                    return subscriptionOperationMessage;
                }
                {
                    this.$operationMessage = subscriptionOperationMessage;
                }
            }).concatWith((Publisher)FluxExtensionsKt.toFlux((Publisher)((Publisher)this.onComplete(operationMessage, session)))).doOnSubscribe((Consumer)new Consumer<Subscription>(this, session, operationMessage){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                final /* synthetic */ WebSocketSession $session;
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                public final void accept(Subscription it) {
                    ApolloSubscriptionSessionState apolloSubscriptionSessionState = ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0);
                    Subscription subscription = it;
                    Intrinsics.checkNotNullExpressionValue((Object)subscription, (String)"it");
                    apolloSubscriptionSessionState.saveOperation(this.$session, this.$operationMessage, subscription);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                    this.$session = webSocketSession;
                    this.$operationMessage = subscriptionOperationMessage;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"subscriptionHandler.exec\u2026, operationMessage, it) }");
            return flux;
        }
        catch (Exception exception) {
            this.logger.error("Error running graphql subscription", (Throwable)exception);
            this.sessionState.stopOperation(session, operationMessage);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            return flux;
        }
    }

    private final Flux<SubscriptionOperationMessage> onInit(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        this.saveContext(operationMessage, session);
        Mono mono = Mono.just((Object)this.acknowledgeMessage);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"Mono.just(acknowledgeMessage)");
        Mono acknowledgeMessage = mono;
        Flux<SubscriptionOperationMessage> keepAliveFlux = this.getKeepAliveFlux(session);
        Flux flux = acknowledgeMessage.concatWith((Publisher)keepAliveFlux).onErrorReturn((Object)this.getConnectionErrorMessage(operationMessage));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"acknowledgeMessage.conca\u2026essage(operationMessage))");
        return flux;
    }

    private final void saveContext(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, operationMessage, session, null){
            Object L$0;
            int label;
            final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
            final /* synthetic */ SubscriptionOperationMessage $operationMessage;
            final /* synthetic */ WebSocketSession $session;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        connectionParams = ApolloSubscriptionProtocolHandler.access$getConnectionParams(this.this$0, this.$operationMessage.getPayload());
                        this.L$0 = connectionParams;
                        this.label = 1;
                        v0 = ApolloSubscriptionProtocolHandler.access$getContextFactory$p(this.this$0).generateContext(this.$session, (Continuation)this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        connectionParams = (Map)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        context = (GraphQLContext)v0;
                        onConnect = ApolloSubscriptionProtocolHandler.access$getSubscriptionHooks$p(this.this$0).onConnect(connectionParams, this.$session, context);
                        ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0).saveContext(this.$session, onConnect);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = apolloSubscriptionProtocolHandler;
                this.$operationMessage = subscriptionOperationMessage;
                this.$session = webSocketSession;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final Map<String, String> getConnectionParams(Object payload) {
        if (payload != null && payload instanceof Map) {
            Map map = (Map)payload;
            boolean bl = false;
            if (!map.isEmpty() && CollectionsKt.first((Iterable)((Map)payload).keySet()) instanceof String && CollectionsKt.first((Iterable)((Map)payload).values()) instanceof String) {
                return (Map)payload;
            }
        }
        return MapsKt.emptyMap();
    }

    private final Mono<SubscriptionOperationMessage> onComplete(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        this.subscriptionHooks.onOperationComplete(session);
        return this.sessionState.completeOperation(session, operationMessage);
    }

    private final Flux<SubscriptionOperationMessage> onStop(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        this.subscriptionHooks.onOperationComplete(session);
        return FluxExtensionsKt.toFlux((Publisher)((Publisher)this.sessionState.stopOperation(session, operationMessage)));
    }

    private final Flux<SubscriptionOperationMessage> onDisconnect(WebSocketSession session) {
        this.subscriptionHooks.onDisconnect(session);
        this.sessionState.terminateSession(session);
        Flux flux = Flux.empty();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"Flux.empty()");
        return flux;
    }

    private final Flux<SubscriptionOperationMessage> onUnknownOperation(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        this.logger.error("Unknown subscription operation " + operationMessage);
        this.sessionState.stopOperation(session, operationMessage);
        Flux flux = Flux.just((Object)this.getConnectionErrorMessage(operationMessage));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"Flux.just(getConnectionE\u2026essage(operationMessage))");
        return flux;
    }

    private final Flux<SubscriptionOperationMessage> onException(Exception exception) {
        this.logger.error("Error parsing the subscription message", (Throwable)exception);
        Flux flux = Flux.just((Object)this.basicConnectionErrorMessage);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"Flux.just(basicConnectionErrorMessage)");
        return flux;
    }

    private final SubscriptionOperationMessage getConnectionErrorMessage(SubscriptionOperationMessage operationMessage) {
        return new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null);
    }

    public ApolloSubscriptionProtocolHandler(@NotNull GraphQLConfigurationProperties config, @NotNull SpringSubscriptionGraphQLContextFactory<?> contextFactory, @NotNull SpringGraphQLSubscriptionHandler subscriptionHandler, @NotNull ObjectMapper objectMapper, @NotNull ApolloSubscriptionHooks subscriptionHooks) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(contextFactory, (String)"contextFactory");
        Intrinsics.checkNotNullParameter((Object)subscriptionHandler, (String)"subscriptionHandler");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)subscriptionHooks, (String)"subscriptionHooks");
        this.config = config;
        this.contextFactory = contextFactory;
        this.subscriptionHandler = subscriptionHandler;
        this.objectMapper = objectMapper;
        this.subscriptionHooks = subscriptionHooks;
        this.sessionState = new ApolloSubscriptionSessionState();
        this.logger = LoggerFactory.getLogger(ApolloSubscriptionProtocolHandler.class);
        this.keepAliveMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_KEEP_ALIVE.getType(), null, null, 6, null);
        this.basicConnectionErrorMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), null, null, 6, null);
        this.acknowledgeMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ACK.getType(), null, null, 6, null);
    }

    public static final /* synthetic */ SubscriptionOperationMessage access$getKeepAliveMessage$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.keepAliveMessage;
    }

    public static final /* synthetic */ ApolloSubscriptionSessionState access$getSessionState$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.sessionState;
    }

    public static final /* synthetic */ Map access$getConnectionParams(ApolloSubscriptionProtocolHandler $this, Object payload) {
        return $this.getConnectionParams(payload);
    }

    public static final /* synthetic */ SpringSubscriptionGraphQLContextFactory access$getContextFactory$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.contextFactory;
    }

    public static final /* synthetic */ ApolloSubscriptionHooks access$getSubscriptionHooks$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.subscriptionHooks;
    }
}

