/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring;

import com.expediagroup.graphql.server.operations.Subscription;
import com.expediagroup.graphql.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.spring.GraphQLSchemaConfiguration;
import com.expediagroup.graphql.spring.execution.ApolloSubscriptionHooks;
import com.expediagroup.graphql.spring.execution.ApolloSubscriptionProtocolHandler;
import com.expediagroup.graphql.spring.execution.SimpleSubscriptionHandler;
import com.expediagroup.graphql.spring.execution.SimpleSubscriptionHooks;
import com.expediagroup.graphql.spring.execution.SubscriptionHandler;
import com.expediagroup.graphql.spring.execution.SubscriptionWebSocketHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;

@Configuration
@ConditionalOnBean(value={Subscription.class})
@Import(value={GraphQLSchemaConfiguration.class})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017\u00a8\u0006\u0016"}, d2={"Lcom/expediagroup/graphql/spring/SubscriptionAutoConfiguration;", "", "()V", "apolloSubscriptionHooks", "Lcom/expediagroup/graphql/spring/execution/ApolloSubscriptionHooks;", "apolloSubscriptionProtocolHandler", "Lcom/expediagroup/graphql/spring/execution/ApolloSubscriptionProtocolHandler;", "config", "Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;", "handler", "Lcom/expediagroup/graphql/spring/execution/SubscriptionHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "subscriptionHandler", "graphQL", "Lgraphql/GraphQL;", "subscriptionHandlerMapping", "Lorg/springframework/web/reactive/HandlerMapping;", "subscriptionWebSocketHandler", "Lcom/expediagroup/graphql/spring/execution/SubscriptionWebSocketHandler;", "websocketHandlerAdapter", "Lorg/springframework/web/reactive/socket/server/support/WebSocketHandlerAdapter;", "graphql-kotlin-spring-server"})
public class SubscriptionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SubscriptionHandler subscriptionHandler(@NotNull GraphQL graphQL2) {
        Intrinsics.checkParameterIsNotNull((Object)graphQL2, (String)"graphQL");
        return new SimpleSubscriptionHandler(graphQL2);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public WebSocketHandlerAdapter websocketHandlerAdapter() {
        return new WebSocketHandlerAdapter();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ApolloSubscriptionHooks apolloSubscriptionHooks() {
        return new SimpleSubscriptionHooks();
    }

    @Bean
    @NotNull
    public ApolloSubscriptionProtocolHandler apolloSubscriptionProtocolHandler(@NotNull GraphQLConfigurationProperties config, @NotNull SubscriptionHandler handler, @NotNull ObjectMapper objectMapper, @NotNull ApolloSubscriptionHooks apolloSubscriptionHooks) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkParameterIsNotNull((Object)apolloSubscriptionHooks, (String)"apolloSubscriptionHooks");
        return new ApolloSubscriptionProtocolHandler(config, handler, objectMapper, apolloSubscriptionHooks);
    }

    @Bean
    @NotNull
    public SubscriptionWebSocketHandler subscriptionWebSocketHandler(@NotNull ApolloSubscriptionProtocolHandler handler, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        return new SubscriptionWebSocketHandler(handler, objectMapper);
    }

    @Bean
    @NotNull
    public HandlerMapping subscriptionHandlerMapping(@NotNull GraphQLConfigurationProperties config, @NotNull SubscriptionWebSocketHandler subscriptionWebSocketHandler) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)subscriptionWebSocketHandler, (String)"subscriptionWebSocketHandler");
        return (HandlerMapping)new SimpleUrlHandlerMapping(MapsKt.mapOf((Pair)TuplesKt.to((Object)config.getSubscriptions().getEndpoint(), (Object)subscriptionWebSocketHandler)), 0);
    }
}

