/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring.execution;

import com.expediagroup.graphql.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.spring.execution.ApolloSubscriptionSessionState;
import com.expediagroup.graphql.spring.execution.SubscriptionHandler;
import com.expediagroup.graphql.spring.model.GraphQLRequest;
import com.expediagroup.graphql.spring.model.GraphQLResponse;
import com.expediagroup.graphql.spring.model.SubscriptionOperationMessage;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQLError;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/expediagroup/graphql/spring/execution/ApolloSubscriptionProtocolHandler;", "", "config", "Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;", "subscriptionHandler", "Lcom/expediagroup/graphql/spring/execution/SubscriptionHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;Lcom/expediagroup/graphql/spring/execution/SubscriptionHandler;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "acknowledgeMessage", "Lcom/expediagroup/graphql/spring/model/SubscriptionOperationMessage;", "basicConnectionErrorMessage", "keepAliveMessage", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sessionState", "Lcom/expediagroup/graphql/spring/execution/ApolloSubscriptionSessionState;", "getKeepAliveFlux", "Lreactor/core/publisher/Flux;", "session", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "handle", "payload", "", "startSubscription", "operationMessage", "graphql-kotlin-spring-server"})
public final class ApolloSubscriptionProtocolHandler {
    private final ApolloSubscriptionSessionState sessionState;
    private final Logger logger;
    private final SubscriptionOperationMessage keepAliveMessage;
    private final SubscriptionOperationMessage basicConnectionErrorMessage;
    private final SubscriptionOperationMessage acknowledgeMessage;
    private final GraphQLConfigurationProperties config;
    private final SubscriptionHandler subscriptionHandler;
    private final ObjectMapper objectMapper;

    @NotNull
    public final Flux<SubscriptionOperationMessage> handle(@NotNull String payload, @NotNull WebSocketSession session) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        try {
            ObjectMapper $this$readValue$iv = this.objectMapper;
            boolean $i$f$readValue = false;
            String string = payload;
            ObjectMapper objectMapper = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<SubscriptionOperationMessage>(){};
            SubscriptionOperationMessage operationMessage = (SubscriptionOperationMessage)objectMapper.readValue(string, typeReference);
            this.logger.debug("GraphQL subscription client message, sessionId=" + session.getId() + " operationMessage=" + operationMessage);
            String string2 = operationMessage.getType();
            if (Intrinsics.areEqual((Object)string2, (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_INIT.getType())) {
                Flux flux = Flux.just((Object)this.acknowledgeMessage);
                Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(acknowledgeMessage)");
                Flux ackowledgeMessageFlux = flux;
                Flux<SubscriptionOperationMessage> keepAliveFlux = this.getKeepAliveFlux(session);
                Flux flux2 = ackowledgeMessageFlux.concatWith((Publisher)keepAliveFlux);
                Intrinsics.checkExpressionValueIsNotNull((Object)flux2, (String)"ackowledgeMessageFlux.concatWith(keepAliveFlux)");
                return flux2;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)SubscriptionOperationMessage.ClientMessages.GQL_START.getType())) {
                return this.startSubscription(operationMessage, session);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)SubscriptionOperationMessage.ClientMessages.GQL_STOP.getType())) {
                return this.sessionState.stopOperation(session, operationMessage);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_TERMINATE.getType())) {
                this.sessionState.terminateSession(session);
                Flux flux = Flux.empty();
                Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.empty()");
                return flux;
            }
            this.logger.error("Unknown subscription operation " + operationMessage);
            this.sessionState.stopOperation(session, operationMessage);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            return flux;
        }
        catch (Exception exception) {
            this.logger.error("Error parsing the subscription message", (Throwable)exception);
            Flux flux = Flux.just((Object)this.basicConnectionErrorMessage);
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(basicConnectionErrorMessage)");
            return flux;
        }
    }

    private final Flux<SubscriptionOperationMessage> getKeepAliveFlux(WebSocketSession session) {
        Long keepAliveInterval = this.config.getSubscriptions().getKeepAliveInterval();
        if (keepAliveInterval != null) {
            Flux flux = Flux.interval((Duration)Duration.ofMillis(keepAliveInterval)).map(new Function<T, V>(this){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;

                @NotNull
                public final SubscriptionOperationMessage apply(Long it) {
                    return ApolloSubscriptionProtocolHandler.access$getKeepAliveMessage$p(this.this$0);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                }
            }).doOnSubscribe((Consumer)new Consumer<Subscription>(this, session){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                final /* synthetic */ WebSocketSession $session;

                public final void accept(Subscription it) {
                    ApolloSubscriptionSessionState apolloSubscriptionSessionState = ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0);
                    Subscription subscription = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)subscription, (String)"it");
                    apolloSubscriptionSessionState.saveKeepAliveSubscription(this.$session, subscription);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                    this.$session = webSocketSession;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.interval(Duration.o\u2026bscription(session, it) }");
            return flux;
        }
        Flux flux = Flux.empty();
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.empty()");
        return flux;
    }

    private final Flux<SubscriptionOperationMessage> startSubscription(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        if (operationMessage.getId() == null) {
            this.logger.error("GraphQL subscription operation id is required");
            Flux flux = Flux.just((Object)this.basicConnectionErrorMessage);
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(basicConnectionErrorMessage)");
            return flux;
        }
        if (this.sessionState.operationExists(session, operationMessage)) {
            this.logger.info("Already subscribed to operation " + operationMessage.getId() + " for session " + session.getId());
            Flux flux = Flux.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.empty()");
            return flux;
        }
        Object payload = operationMessage.getPayload();
        if (payload == null) {
            this.logger.error("GraphQL subscription payload was null instead of a GraphQLRequest object");
            this.sessionState.stopOperation(session, operationMessage);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            return flux;
        }
        try {
            ObjectMapper $this$convertValue$iv = this.objectMapper;
            boolean $i$f$convertValue = false;
            Object object = payload;
            ObjectMapper objectMapper = $this$convertValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<GraphQLRequest>(){};
            GraphQLRequest request = (GraphQLRequest)objectMapper.convertValue(object, typeReference);
            Flux flux = this.subscriptionHandler.executeSubscription(request).map(new Function<T, V>(operationMessage){
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public final SubscriptionOperationMessage apply(GraphQLResponse it) {
                    SubscriptionOperationMessage subscriptionOperationMessage;
                    List<GraphQLError> list = it.getErrors();
                    if (list != null) {
                        Collection collection = list;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            subscriptionOperationMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_ERROR.getType(), this.$operationMessage.getId(), it);
                            return subscriptionOperationMessage;
                        }
                    }
                    subscriptionOperationMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_DATA.getType(), this.$operationMessage.getId(), it);
                    return subscriptionOperationMessage;
                }
                {
                    this.$operationMessage = subscriptionOperationMessage;
                }
            }).doOnSubscribe((Consumer)new Consumer<Subscription>(this, session, operationMessage){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                final /* synthetic */ WebSocketSession $session;
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                public final void accept(Subscription it) {
                    ApolloSubscriptionSessionState apolloSubscriptionSessionState = ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0);
                    Subscription subscription = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)subscription, (String)"it");
                    apolloSubscriptionSessionState.saveOperation(this.$session, this.$operationMessage, subscription);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                    this.$session = webSocketSession;
                    this.$operationMessage = subscriptionOperationMessage;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"subscriptionHandler.exec\u2026, operationMessage, it) }");
            return flux;
        }
        catch (Exception exception) {
            this.logger.error("Error running graphql subscription", (Throwable)exception);
            this.sessionState.stopOperation(session, operationMessage);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            return flux;
        }
    }

    public ApolloSubscriptionProtocolHandler(@NotNull GraphQLConfigurationProperties config, @NotNull SubscriptionHandler subscriptionHandler, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)subscriptionHandler, (String)"subscriptionHandler");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        this.config = config;
        this.subscriptionHandler = subscriptionHandler;
        this.objectMapper = objectMapper;
        this.sessionState = new ApolloSubscriptionSessionState();
        this.logger = LoggerFactory.getLogger(ApolloSubscriptionProtocolHandler.class);
        this.keepAliveMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_KEEP_ALIVE.getType(), null, null, 6, null);
        this.basicConnectionErrorMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), null, null, 6, null);
        this.acknowledgeMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ACK.getType(), null, null, 6, null);
    }

    public static final /* synthetic */ SubscriptionOperationMessage access$getKeepAliveMessage$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.keepAliveMessage;
    }

    public static final /* synthetic */ ApolloSubscriptionSessionState access$getSessionState$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.sessionState;
    }
}

