/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring.execution;

import com.expediagroup.graphql.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.spring.execution.SubscriptionHandler;
import com.expediagroup.graphql.spring.model.GraphQLRequest;
import com.expediagroup.graphql.spring.model.GraphQLResponse;
import com.expediagroup.graphql.spring.model.SubscriptionOperationMessage;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQLError;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/expediagroup/graphql/spring/execution/ApolloSubscriptionProtocolHandler;", "", "config", "Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;", "subscriptionHandler", "Lcom/expediagroup/graphql/spring/execution/SubscriptionHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;Lcom/expediagroup/graphql/spring/execution/SubscriptionHandler;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "keepAliveMessage", "Lcom/expediagroup/graphql/spring/model/SubscriptionOperationMessage;", "keepAliveSubscriptions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/reactivestreams/Subscription;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "subscriptions", "handle", "Lreactor/core/publisher/Flux;", "payload", "session", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "startSubscription", "operationMessage", "stopSubscription", "", "graphql-kotlin-spring-server"})
public final class ApolloSubscriptionProtocolHandler {
    private final ConcurrentHashMap<String, Subscription> keepAliveSubscriptions;
    private final ConcurrentHashMap<String, Subscription> subscriptions;
    private final Logger logger;
    private final SubscriptionOperationMessage keepAliveMessage;
    private final GraphQLConfigurationProperties config;
    private final SubscriptionHandler subscriptionHandler;
    private final ObjectMapper objectMapper;

    @NotNull
    public final Flux<SubscriptionOperationMessage> handle(@NotNull String payload, @NotNull WebSocketSession session) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        try {
            Flux flux;
            ObjectMapper $this$readValue$iv = this.objectMapper;
            boolean $i$f$readValue = false;
            String string = payload;
            ObjectMapper objectMapper = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<SubscriptionOperationMessage>(){};
            SubscriptionOperationMessage operationMessage = (SubscriptionOperationMessage)objectMapper.readValue(string, typeReference);
            if (Intrinsics.areEqual((Object)operationMessage.getType(), (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_INIT.getType())) {
                Flux flux2 = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ACK.getType(), null, null, 6, null));
                Long keepAliveInterval = this.config.getSubscriptions().getKeepAliveInterval();
                if (keepAliveInterval != null) {
                    Flux keepAliveFlux2 = Flux.interval((Duration)Duration.ofMillis(keepAliveInterval)).map(new Function<T, V>(this){
                        final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;

                        @NotNull
                        public final SubscriptionOperationMessage apply(Long it) {
                            return ApolloSubscriptionProtocolHandler.access$getKeepAliveMessage$p(this.this$0);
                        }
                        {
                            this.this$0 = apolloSubscriptionProtocolHandler;
                        }
                    }).doOnSubscribe((Consumer)new Consumer<Subscription>(this, session){
                        final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                        final /* synthetic */ WebSocketSession $session;

                        public final void accept(Subscription it) {
                            Map map = ApolloSubscriptionProtocolHandler.access$getKeepAliveSubscriptions$p(this.this$0);
                            String string = this.$session.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"session.id");
                            Subscription subscription = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)subscription, (String)"it");
                            map.put(string, subscription);
                        }
                        {
                            this.this$0 = apolloSubscriptionProtocolHandler;
                            this.$session = webSocketSession;
                        }
                    });
                    Flux flux3 = flux2.concatWith((Publisher)keepAliveFlux2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)flux3, (String)"flux.concatWith(keepAliveFlux)");
                    return flux3;
                }
                Flux flux4 = flux2;
                Intrinsics.checkExpressionValueIsNotNull((Object)flux4, (String)"flux");
                return flux4;
            }
            if (Intrinsics.areEqual((Object)operationMessage.getType(), (Object)SubscriptionOperationMessage.ClientMessages.GQL_START.getType())) {
                flux = this.startSubscription(operationMessage, session);
            } else if (Intrinsics.areEqual((Object)operationMessage.getType(), (Object)SubscriptionOperationMessage.ClientMessages.GQL_STOP.getType())) {
                this.stopSubscription(operationMessage, session);
                Flux flux5 = Flux.empty();
                flux = flux5;
                Intrinsics.checkExpressionValueIsNotNull((Object)flux5, (String)"Flux.empty()");
            } else if (Intrinsics.areEqual((Object)operationMessage.getType(), (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_TERMINATE.getType())) {
                this.stopSubscription(operationMessage, session);
                session.close();
                Flux flux6 = Flux.empty();
                flux = flux6;
                Intrinsics.checkExpressionValueIsNotNull((Object)flux6, (String)"Flux.empty()");
            } else {
                this.logger.error("Unknown subscription operation " + operationMessage);
                Flux flux7 = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
                flux = flux7;
                Intrinsics.checkExpressionValueIsNotNull((Object)flux7, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            }
            return flux;
        }
        catch (Exception exception) {
            this.logger.error("Error parsing the subscription message", (Throwable)exception);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), null, null, 6, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(SubscriptionOp\u2026L_CONNECTION_ERROR.type))");
            return flux;
        }
    }

    private final Flux<SubscriptionOperationMessage> startSubscription(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        Flux flux;
        if (operationMessage.getId() == null) {
            this.logger.error("Operation id is required");
            Flux flux2 = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), null, null, 6, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux2, (String)"Flux.just(SubscriptionOp\u2026L_CONNECTION_ERROR.type))");
            return flux2;
        }
        Object payload = operationMessage.getPayload();
        if (payload == null) {
            this.logger.error("Payload was null instead of a GraphQLRequest object");
            Flux flux3 = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux3, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            return flux3;
        }
        try {
            ObjectMapper $this$convertValue$iv = this.objectMapper;
            boolean $i$f$convertValue = false;
            Object object = payload;
            ObjectMapper objectMapper = $this$convertValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<GraphQLRequest>(){};
            GraphQLRequest request = (GraphQLRequest)objectMapper.convertValue(object, typeReference);
            Flux flux4 = this.subscriptionHandler.executeSubscription(request).map(new Function<T, V>(operationMessage){
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public final SubscriptionOperationMessage apply(GraphQLResponse it) {
                    SubscriptionOperationMessage subscriptionOperationMessage;
                    List<GraphQLError> list = it.getErrors();
                    if (list != null) {
                        Collection collection = list;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            subscriptionOperationMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_ERROR.getType(), this.$operationMessage.getId(), it);
                            return subscriptionOperationMessage;
                        }
                    }
                    subscriptionOperationMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_DATA.getType(), this.$operationMessage.getId(), it);
                    return subscriptionOperationMessage;
                }
                {
                    this.$operationMessage = subscriptionOperationMessage;
                }
            }).concatWith((Publisher)Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_COMPLETE.getType(), operationMessage.getId(), null, 4, null))).doOnSubscribe((Consumer)new Consumer<Subscription>(this, session, operationMessage){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                final /* synthetic */ WebSocketSession $session;
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                public final void accept(Subscription it) {
                    ApolloSubscriptionProtocolHandler.access$getLogger$p(this.this$0).trace("WebSocket GraphQL subscription subscribe, WebSocketSessionID=" + this.$session.getId() + " OperationMessageID=" + this.$operationMessage.getId());
                    Map map = ApolloSubscriptionProtocolHandler.access$getSubscriptions$p(this.this$0);
                    String string = this.$operationMessage.getId();
                    Subscription subscription = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)subscription, (String)"it");
                    map.put(string, subscription);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                    this.$session = webSocketSession;
                    this.$operationMessage = subscriptionOperationMessage;
                }
            }).doOnCancel(new Runnable(this, session, operationMessage){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                final /* synthetic */ WebSocketSession $session;
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                public final void run() {
                    ApolloSubscriptionProtocolHandler.access$getLogger$p(this.this$0).trace("WebSocket GraphQL subscription cancel, WebSocketSessionID=" + this.$session.getId() + " OperationMessageID=" + this.$operationMessage.getId());
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                    this.$session = webSocketSession;
                    this.$operationMessage = subscriptionOperationMessage;
                }
            }).doOnComplete(new Runnable(this, session, operationMessage){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                final /* synthetic */ WebSocketSession $session;
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                public final void run() {
                    ApolloSubscriptionProtocolHandler.access$getLogger$p(this.this$0).trace("WebSocket GraphQL subscription complete, WebSocketSessionID=" + this.$session.getId() + " OperationMessageID=" + this.$operationMessage.getId());
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                    this.$session = webSocketSession;
                    this.$operationMessage = subscriptionOperationMessage;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)flux4, (String)"subscriptionHandler.exec\u2026{operationMessage.id}\") }");
            flux = flux4;
        }
        catch (Exception exception) {
            this.logger.error("Error running graphql subscription", (Throwable)exception);
            Flux flux5 = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux5, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            flux = flux5;
        }
        return flux;
    }

    private final void stopSubscription(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        block2: {
            if (operationMessage.getId() == null) break block2;
            Subscription subscription = this.keepAliveSubscriptions.get(session.getId());
            if (subscription != null) {
                subscription.cancel();
            }
            Subscription subscription2 = this.subscriptions.get(operationMessage.getId());
            if (subscription2 != null) {
                subscription2.cancel();
            }
        }
    }

    public ApolloSubscriptionProtocolHandler(@NotNull GraphQLConfigurationProperties config, @NotNull SubscriptionHandler subscriptionHandler, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)subscriptionHandler, (String)"subscriptionHandler");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        this.config = config;
        this.subscriptionHandler = subscriptionHandler;
        this.objectMapper = objectMapper;
        this.keepAliveSubscriptions = new ConcurrentHashMap();
        this.subscriptions = new ConcurrentHashMap();
        this.logger = LoggerFactory.getLogger(ApolloSubscriptionProtocolHandler.class);
        this.keepAliveMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_KEEP_ALIVE.getType(), null, null, 6, null);
    }

    public static final /* synthetic */ SubscriptionOperationMessage access$getKeepAliveMessage$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.keepAliveMessage;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getKeepAliveSubscriptions$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.keepAliveSubscriptions;
    }

    public static final /* synthetic */ Logger access$getLogger$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.logger;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSubscriptions$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.subscriptions;
    }
}

