/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring;

import com.expediagroup.graphql.spring.FederationAutoConfiguration;
import com.expediagroup.graphql.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.spring.PlaygroundAutoConfiguration;
import com.expediagroup.graphql.spring.RoutesConfiguration;
import com.expediagroup.graphql.spring.SchemaAutoConfiguration;
import com.expediagroup.graphql.spring.SubscriptionAutoConfiguration;
import com.expediagroup.graphql.spring.exception.KotlinDataFetcherExceptionHandler;
import com.expediagroup.graphql.spring.execution.ContextWebFilter;
import com.expediagroup.graphql.spring.execution.EmptyContextFactory;
import com.expediagroup.graphql.spring.execution.GraphQLContextFactory;
import com.expediagroup.graphql.spring.execution.QueryHandler;
import com.expediagroup.graphql.spring.execution.SimpleQueryHandler;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import java.util.Optional;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.server.WebFilter;

@Configuration
@Import(value={RoutesConfiguration.class, SchemaAutoConfiguration.class, FederationAutoConfiguration.class, SubscriptionAutoConfiguration.class, PlaygroundAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLConfigurationProperties.class})
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017JB\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011H\u0017J\f\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0017\u00a8\u0006\u001a"}, d2={"Lcom/expediagroup/graphql/spring/GraphQLAutoConfiguration;", "", "()V", "contextWebFilter", "Lorg/springframework/web/server/WebFilter;", "config", "Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;", "graphQLContextFactory", "Lcom/expediagroup/graphql/spring/execution/GraphQLContextFactory;", "exceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "graphQL", "Lgraphql/GraphQL;", "schema", "Lgraphql/schema/GraphQLSchema;", "dataFetcherExceptionHandler", "instrumentation", "Ljava/util/Optional;", "Lgraphql/execution/instrumentation/Instrumentation;", "executionIdProvider", "Lgraphql/execution/ExecutionIdProvider;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "graphQLQueryHandler", "Lcom/expediagroup/graphql/spring/execution/QueryHandler;", "graphql", "graphql-kotlin-spring-server"})
public class GraphQLAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler exceptionHandler() {
        return new KotlinDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQL graphQL(@NotNull GraphQLSchema schema, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull Optional<Instrumentation> instrumentation, @NotNull Optional<ExecutionIdProvider> executionIdProvider, @NotNull Optional<PreparsedDocumentProvider> preparsedDocumentProvider) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkParameterIsNotNull(instrumentation, (String)"instrumentation");
        Intrinsics.checkParameterIsNotNull(executionIdProvider, (String)"executionIdProvider");
        Intrinsics.checkParameterIsNotNull(preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        GraphQL.Builder graphQL2 = GraphQL.newGraphQL((GraphQLSchema)schema).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy(dataFetcherExceptionHandler)).mutationExecutionStrategy((ExecutionStrategy)new AsyncSerialExecutionStrategy(dataFetcherExceptionHandler)).subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy(dataFetcherExceptionHandler));
        instrumentation.ifPresent(new Consumer<Instrumentation>(graphQL2){
            final /* synthetic */ GraphQL.Builder $graphQL;

            public final void accept(@NotNull Instrumentation it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$graphQL.instrumentation(it);
            }
            {
                this.$graphQL = builder;
            }
        });
        executionIdProvider.ifPresent(new Consumer<ExecutionIdProvider>(graphQL2){
            final /* synthetic */ GraphQL.Builder $graphQL;

            public final void accept(@NotNull ExecutionIdProvider it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$graphQL.executionIdProvider(it);
            }
            {
                this.$graphQL = builder;
            }
        });
        preparsedDocumentProvider.ifPresent(new Consumer<PreparsedDocumentProvider>(graphQL2){
            final /* synthetic */ GraphQL.Builder $graphQL;

            public final void accept(@NotNull PreparsedDocumentProvider it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$graphQL.preparsedDocumentProvider(it);
            }
            {
                this.$graphQL = builder;
            }
        });
        GraphQL graphQL3 = graphQL2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphQL3, (String)"graphQL.build()");
        return graphQL3;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public QueryHandler graphQLQueryHandler(@NotNull GraphQL graphql) {
        Intrinsics.checkParameterIsNotNull((Object)graphql, (String)"graphql");
        return new SimpleQueryHandler(graphql);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLContextFactory<?> graphQLContextFactory() {
        return EmptyContextFactory.INSTANCE;
    }

    @Bean
    @NotNull
    public WebFilter contextWebFilter(@NotNull GraphQLConfigurationProperties config, @NotNull GraphQLContextFactory<?> graphQLContextFactory) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(graphQLContextFactory, (String)"graphQLContextFactory");
        return new ContextWebFilter(config, graphQLContextFactory);
    }
}

