/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.schema;

import com.expediagroup.graphql.generator.SchemaGeneratorConfig;
import com.expediagroup.graphql.generator.ToSchemaKt;
import com.expediagroup.graphql.generator.TopLevelObject;
import com.expediagroup.graphql.generator.extensions.GraphQLSchemaExtensionsKt;
import com.expediagroup.graphql.generator.federation.FederatedSchemaGeneratorConfig;
import com.expediagroup.graphql.generator.federation.FederatedSchemaGeneratorHooks;
import com.expediagroup.graphql.generator.federation.ToFederatedSchemaKt;
import com.expediagroup.graphql.generator.hooks.NoopSchemaGeneratorHooks;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.plugin.schema.hooks.SchemaGeneratorHooksProvider;
import com.expediagroup.graphql.server.Schema;
import com.expediagroup.graphql.server.operations.Mutation;
import com.expediagroup.graphql.server.operations.Query;
import com.expediagroup.graphql.server.operations.Subscription;
import graphql.schema.GraphQLSchema;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u001a\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"logger", "Lorg/slf4j/Logger;", "findTopLevelObjects", "", "Lcom/expediagroup/graphql/generator/TopLevelObject;", "scanResult", "Lio/github/classgraph/ScanResult;", "markupClass", "Ljava/lang/Class;", "generateSDL", "", "supportedPackages", "graphql-kotlin-sdl-generator"})
@SourceDebugExtension(value={"SMAP\nGenerateSDL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateSDL.kt\ncom/expediagroup/graphql/plugin/schema/GenerateSDLKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n37#2,2:115\n1549#3:117\n1620#3,3:118\n1549#3:121\n1620#3,3:122\n1549#3:125\n1620#3,3:126\n1549#3:129\n1620#3,3:130\n1549#3:133\n1620#3,3:134\n1549#3:137\n1620#3,3:138\n1549#3:141\n1620#3,3:142\n1549#3:145\n1620#3,3:146\n*S KotlinDebug\n*F\n+ 1 GenerateSDL.kt\ncom/expediagroup/graphql/plugin/schema/GenerateSDLKt\n*L\n63#1:115,2\n74#1:117\n74#1:118,3\n75#1:121\n75#1:122,3\n76#1:125\n76#1:126,3\n90#1:129\n90#1:130,3\n91#1:133\n91#1:134,3\n92#1:137\n92#1:138,3\n112#1:141\n112#1:142,3\n113#1:145\n113#1:146,3\n*E\n"})
public final class GenerateSDLKt {
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final String generateSDL(@NotNull List<String> supportedPackages) {
        GraphQLSchema graphQLSchema;
        SchemaGeneratorHooks schemaGeneratorHooks;
        Intrinsics.checkNotNullParameter(supportedPackages, (String)"supportedPackages");
        ServiceLoader<SchemaGeneratorHooksProvider> serviceLoader = ServiceLoader.load(SchemaGeneratorHooksProvider.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(SchemaGeneratorHooksProvider::class.java)");
        List hooksProviders = CollectionsKt.toList((Iterable)serviceLoader);
        if (hooksProviders.isEmpty()) {
            logger.warn("No SchemaGeneratorHooksProvider were found, defaulting to NoopSchemaGeneratorHooks");
            schemaGeneratorHooks = (SchemaGeneratorHooks)NoopSchemaGeneratorHooks.INSTANCE;
        } else {
            if (hooksProviders.size() > 1) {
                throw new RuntimeException("Cannot generate SDL as multiple SchemaGeneratorHooksProviders were found on the classpath");
            }
            SchemaGeneratorHooksProvider provider = (SchemaGeneratorHooksProvider)CollectionsKt.first((List)hooksProviders);
            logger.debug("SchemaGeneratorHooksProvider found, " + provider.getClass().getSimpleName() + " will be used to generate the hooks");
            schemaGeneratorHooks = provider.hooks();
        }
        SchemaGeneratorHooks hooks = schemaGeneratorHooks;
        Collection $this$toTypedArray$iv = supportedPackages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(Arrays.copyOf(stringArray, stringArray.length)).scan();
        Intrinsics.checkNotNullExpressionValue((Object)scanResult, (String)"scanResult");
        List<TopLevelObject> queries = GenerateSDLKt.findTopLevelObjects(scanResult, Query.class);
        List<TopLevelObject> mutations = GenerateSDLKt.findTopLevelObjects(scanResult, Mutation.class);
        List<TopLevelObject> subscriptions = GenerateSDLKt.findTopLevelObjects(scanResult, Subscription.class);
        TopLevelObject schemaObject = (TopLevelObject)CollectionsKt.firstOrNull(GenerateSDLKt.findTopLevelObjects(scanResult, Schema.class));
        if (hooks instanceof FederatedSchemaGeneratorHooks) {
            logger.debug("Generating federated schema using hooks = " + hooks.getClass().getSimpleName());
            Iterable iterable = queries;
            var18_10 = logger;
            $i$f$map = false;
            void var11_12 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TopLevelObject topLevelObject = (TopLevelObject)item$iv$iv;
                var19_19 = destination$iv$iv;
                boolean bl = false;
                var19_19.add(it.getKClass());
            }
            var18_10.debug("  query classes = " + (List)destination$iv$iv);
            $this$map$iv = mutations;
            var18_10 = logger;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TopLevelObject)item$iv$iv;
                var19_19 = destination$iv$iv;
                boolean bl = false;
                var19_19.add(it.getKClass());
            }
            var18_10.debug("  mutation classes = " + (List)destination$iv$iv);
            $this$map$iv = subscriptions;
            var18_10 = logger;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TopLevelObject)item$iv$iv;
                var19_19 = destination$iv$iv;
                boolean bl = false;
                var19_19.add(it.getKClass());
            }
            var18_10.debug("  subscription classes = " + (List)destination$iv$iv);
            config = new FederatedSchemaGeneratorConfig(supportedPackages, null, (FederatedSchemaGeneratorHooks)hooks, null, false, null, null, 122, null);
            graphQLSchema = ToFederatedSchemaKt.toFederatedSchema((FederatedSchemaGeneratorConfig)config, queries, mutations, subscriptions, (TopLevelObject)schemaObject);
        } else {
            logger.debug("Generating schema using hooks = " + hooks.getClass().getSimpleName());
            config = queries;
            var18_10 = logger;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TopLevelObject)item$iv$iv;
                var19_19 = destination$iv$iv;
                boolean bl = false;
                var19_19.add(it.getKClass());
            }
            var18_10.debug("  query classes = " + (List)destination$iv$iv);
            $this$map$iv = mutations;
            var18_10 = logger;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TopLevelObject)item$iv$iv;
                var19_19 = destination$iv$iv;
                boolean bl = false;
                var19_19.add(it.getKClass());
            }
            var18_10.debug("  mutation classes = " + (List)destination$iv$iv);
            $this$map$iv = subscriptions;
            var18_10 = logger;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TopLevelObject)item$iv$iv;
                var19_19 = destination$iv$iv;
                boolean bl = false;
                var19_19.add(it.getKClass());
            }
            var18_10.debug("  subscription classes = " + (List)destination$iv$iv);
            config = new SchemaGeneratorConfig(supportedPackages, null, hooks, null, false, null, null, 122, null);
            graphQLSchema = ToSchemaKt.toSchema((SchemaGeneratorConfig)config, queries, mutations, subscriptions, (TopLevelObject)schemaObject);
        }
        GraphQLSchema schema = graphQLSchema;
        scanResult.close();
        return GraphQLSchemaExtensionsKt.print$default((GraphQLSchema)schema, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (int)63, null);
    }

    private static final List<TopLevelObject> findTopLevelObjects(ScanResult scanResult, Class<?> markupClass) {
        Class it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        ClassInfoList classInfoList = scanResult.getClassesImplementing(markupClass.getName());
        Intrinsics.checkNotNullExpressionValue((Object)classInfoList, (String)"scanResult.getClassesImp\u2026menting(markupClass.name)");
        Iterable $this$map$iv = (Iterable)classInfoList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ClassInfo classInfo = (ClassInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.loadClass());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Class)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new TopLevelObject(null, JvmClassMappingKt.getKotlinClass((Class)it)));
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"generateSDL");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"generateSDL\")");
        GenerateSDLKt.logger = logger;
    }
}

