/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.internal.types;

import com.expediagroup.graphql.generator.SchemaGenerator;
import com.expediagroup.graphql.generator.TopLevelObject;
import com.expediagroup.graphql.generator.exceptions.ConflictingFieldsException;
import com.expediagroup.graphql.generator.exceptions.InvalidSubscriptionTypeException;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.generator.internal.extensions.KClassExtensionsKt;
import com.expediagroup.graphql.generator.internal.types.GenerateDirectiveKt;
import com.expediagroup.graphql.generator.internal.types.GenerateFunctionKt;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a8\u0006\u0007"}, d2={"generateSubscriptions", "Lgraphql/schema/GraphQLObjectType;", "generator", "Lcom/expediagroup/graphql/generator/SchemaGenerator;", "subscriptions", "", "Lcom/expediagroup/graphql/generator/TopLevelObject;", "graphql-kotlin-schema-generator"})
public final class GenerateSubscriptionKt {
    @Nullable
    public static final GraphQLObjectType generateSubscriptions(@NotNull SchemaGenerator generator, @NotNull List<TopLevelObject> subscriptions) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
        if (subscriptions.isEmpty()) {
            return null;
        }
        GraphQLObjectType.Builder subscriptionBuilder = new GraphQLObjectType.Builder();
        subscriptionBuilder.name(generator.getConfig$graphql_kotlin_schema_generator().getTopLevelNames().getSubscription());
        for (TopLevelObject subscription : subscriptions) {
            GraphQLAppliedDirective it;
            KClass<?> kClass = subscription.getKClass();
            if (KClassExtensionsKt.isNotPublic(kClass)) {
                throw new InvalidSubscriptionTypeException(kClass, null, 2, null);
            }
            Iterable $this$forEach$iv = GenerateDirectiveKt.generateDirectives$default(generator, (KAnnotatedElement)subscription.getKClass(), Introspection.DirectiveLocation.OBJECT, null, 8, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (GraphQLAppliedDirective)element$iv;
                boolean bl = false;
                subscriptionBuilder.withAppliedDirective(it);
            }
            $this$forEach$iv = KClassExtensionsKt.getValidFunctions(kClass, generator.getConfig$graphql_kotlin_schema_generator().getHooks());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KFunction)element$iv;
                boolean bl = false;
                if (!generator.getConfig$graphql_kotlin_schema_generator().getHooks().isValidSubscriptionReturnType(kClass, (KFunction<?>)it)) {
                    throw new InvalidSubscriptionTypeException(kClass, (KFunction<?>)it);
                }
                GraphQLFieldDefinition function = GenerateFunctionKt.generateFunction$default(generator, (KFunction)it, generator.getConfig$graphql_kotlin_schema_generator().getTopLevelNames().getSubscription(), subscription.getObj(), false, 16, null);
                GraphQLFieldDefinition functionFromHook = generator.getConfig$graphql_kotlin_schema_generator().getHooks().didGenerateSubscriptionField(kClass, (KFunction<?>)it, function);
                if (subscriptionBuilder.hasField(functionFromHook.getName())) {
                    throw new ConflictingFieldsException("Subscription(class: " + subscription.getKClass() + ')', it.getName());
                }
                subscriptionBuilder.field(functionFromHook);
            }
        }
        SchemaGeneratorHooks schemaGeneratorHooks = generator.getConfig$graphql_kotlin_schema_generator().getHooks();
        GraphQLObjectType graphQLObjectType = subscriptionBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLObjectType, (String)"subscriptionBuilder.build()");
        return schemaGeneratorHooks.didGenerateSubscriptionObject(graphQLObjectType);
    }
}

