/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.state;

import com.expediagroup.graphql.exceptions.ConflictingTypesException;
import com.expediagroup.graphql.exceptions.TypeNotSupportedException;
import com.expediagroup.graphql.generator.extensions.KClassExtensionsKt;
import com.expediagroup.graphql.generator.extensions.KTypeExtensionsKt;
import com.expediagroup.graphql.generator.state.KGraphQLType;
import com.expediagroup.graphql.generator.state.TypesCacheKey;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KClassifiers;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J*\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0016\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\r0\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/expediagroup/graphql/generator/state/TypesCache;", "", "supportedPackages", "", "", "(Ljava/util/List;)V", "cache", "", "Lcom/expediagroup/graphql/generator/state/KGraphQLType;", "typeUnderConstruction", "", "Lkotlin/reflect/KClass;", "buildIfNotUnderConstruction", "Lgraphql/schema/GraphQLType;", "kClass", "build", "Lkotlin/Function1;", "doesNotContain", "", "doesNotContainGraphQLType", "graphQLType", "get", "cacheKey", "Lcom/expediagroup/graphql/generator/state/TypesCacheKey;", "getCacheKeyString", "isTypeNotSupported", "type", "Lkotlin/reflect/KType;", "put", "key", "kGraphQLType", "graphql-kotlin-schema-generator"})
public final class TypesCache {
    private final Map<String, KGraphQLType> cache;
    private final Set<KClass<?>> typeUnderConstruction;
    private final List<String> supportedPackages;

    @Nullable
    public final GraphQLType get(@NotNull TypesCacheKey cacheKey) throws ConflictingTypesException {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        String string = this.getCacheKeyString(cacheKey);
        if (string == null) {
            return null;
        }
        String cacheKeyString = string;
        KGraphQLType cachedType = this.cache.get(cacheKeyString);
        if (cachedType != null) {
            KClass<?> kClass = KTypeExtensionsKt.getKClass(cacheKey.getType());
            boolean isSameNameButNotSameClass = Intrinsics.areEqual(cachedType.getKClass(), kClass) ^ true;
            if (isSameNameButNotSameClass) {
                throw (Throwable)new ConflictingTypesException(cachedType.getKClass(), kClass);
            }
            return cachedType.getGraphQLType();
        }
        return null;
    }

    @Nullable
    public final KGraphQLType put(@NotNull TypesCacheKey key, @NotNull KGraphQLType kGraphQLType) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)kGraphQLType, (String)"kGraphQLType");
        String cacheKey = this.getCacheKeyString(key);
        if (cacheKey != null) {
            this.cache.put(cacheKey, kGraphQLType);
            return kGraphQLType;
        }
        return null;
    }

    public final boolean doesNotContainGraphQLType(@NotNull GraphQLType graphQLType) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)graphQLType, (String)"graphQLType");
            Map<String, KGraphQLType> $this$none$iv = this.cache;
            boolean $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                bl = true;
            } else {
                Map<String, KGraphQLType> map = $this$none$iv;
                boolean bl2 = false;
                Iterator<Map.Entry<String, KGraphQLType>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, KGraphQLType> element$iv;
                    Map.Entry<String, KGraphQLType> $dstr$_u24__u24$v = element$iv = iterator.next();
                    boolean bl3 = false;
                    Map.Entry<String, KGraphQLType> entry = $dstr$_u24__u24$v;
                    boolean bl4 = false;
                    KGraphQLType v = entry.getValue();
                    if (!Intrinsics.areEqual((Object)v.getGraphQLType().getName(), (Object)graphQLType.getName())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean doesNotContain(@NotNull KClass<?> kClass) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(kClass, (String)"kClass");
            Map<String, KGraphQLType> $this$none$iv = this.cache;
            boolean $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                bl = true;
            } else {
                Map<String, KGraphQLType> map = $this$none$iv;
                boolean bl2 = false;
                Iterator<Map.Entry<String, KGraphQLType>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, KGraphQLType> element$iv;
                    Map.Entry<String, KGraphQLType> $dstr$_u24__u24$ktype = element$iv = iterator.next();
                    boolean bl3 = false;
                    Map.Entry<String, KGraphQLType> entry = $dstr$_u24__u24$ktype;
                    boolean bl4 = false;
                    KGraphQLType ktype = entry.getValue();
                    if (!Intrinsics.areEqual(ktype.getKClass(), kClass)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final String getCacheKeyString(TypesCacheKey cacheKey) {
        String string;
        KType type = cacheKey.getType();
        KClass<?> kClass = KTypeExtensionsKt.getKClass(type);
        if (KClassExtensionsKt.isListType(kClass)) {
            string = null;
        } else if (KClasses.isSubclassOf(kClass, (KClass)Reflection.getOrCreateKotlinClass(Enum.class))) {
            string = KClassExtensionsKt.getSimpleName$default(kClass, false, 1, null);
        } else {
            if (this.isTypeNotSupported(type)) {
                throw (Throwable)new TypeNotSupportedException(type, this.supportedPackages);
            }
            string = KTypeExtensionsKt.getSimpleName(type, cacheKey.getInputType());
        }
        return string;
    }

    private final boolean isTypeNotSupported(KType type) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.supportedPackages;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)KTypeExtensionsKt.getQualifiedName(type), (String)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final GraphQLType buildIfNotUnderConstruction(@NotNull KClass<?> kClass, @NotNull Function1<? super KClass<?>, ? extends GraphQLType> build) {
        GraphQLType graphQLType;
        Intrinsics.checkParameterIsNotNull(kClass, (String)"kClass");
        Intrinsics.checkParameterIsNotNull(build, (String)"build");
        KGraphQLType cachedType = this.cache.get(KClassExtensionsKt.getSimpleName$default(kClass, false, 1, null));
        if (cachedType != null) {
            graphQLType = cachedType.getGraphQLType();
        } else if (this.typeUnderConstruction.contains(kClass)) {
            GraphQLTypeReference graphQLTypeReference = GraphQLTypeReference.typeRef((String)KClassExtensionsKt.getSimpleName$default(kClass, false, 1, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)graphQLTypeReference, (String)"GraphQLTypeReference.typ\u2026f(kClass.getSimpleName())");
            graphQLType = (GraphQLType)graphQLTypeReference;
        } else {
            this.typeUnderConstruction.add(kClass);
            GraphQLType newType = (GraphQLType)build.invoke(kClass);
            TypesCacheKey key = new TypesCacheKey(KClassifiers.createType$default((KClassifier)((KClassifier)kClass), null, (boolean)false, null, (int)7, null), false);
            this.put(key, new KGraphQLType(kClass, newType));
            this.typeUnderConstruction.remove(kClass);
            graphQLType = newType;
        }
        return graphQLType;
    }

    public TypesCache(@NotNull List<String> supportedPackages) {
        Intrinsics.checkParameterIsNotNull(supportedPackages, (String)"supportedPackages");
        this.supportedPackages = supportedPackages;
        TypesCache typesCache = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        typesCache.cache = object;
        typesCache = this;
        bl = false;
        typesCache.typeUnderConstruction = object = (Set)new LinkedHashSet();
    }
}

