/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.maven;

import com.expediagroup.graphql.plugin.client.GenerateClientKt;
import com.expediagroup.graphql.plugin.client.generator.GraphQLScalar;
import com.expediagroup.graphql.plugin.client.generator.GraphQLSerializer;
import com.expediagroup.graphql.plugin.maven.CustomScalar;
import com.expediagroup.graphql.plugin.maven.GenerateClientAbstractMojo;
import com.squareup.kotlinpoet.FileSpec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\tH&J\b\u0010\u001d\u001a\u00020\u001aH\u0016J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00062\u0006\u0010 \u001a\u00020\tH\u0002J\u001e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\rR\u001a\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u00188\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/expediagroup/graphql/plugin/maven/GenerateClientAbstractMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "()V", "allowDeprecatedFields", "", "customScalars", "", "Lcom/expediagroup/graphql/plugin/maven/CustomScalar;", "outputDirectory", "Ljava/io/File;", "getOutputDirectory", "()Ljava/io/File;", "setOutputDirectory", "(Ljava/io/File;)V", "packageName", "", "project", "Lorg/apache/maven/project/MavenProject;", "queryFileDirectory", "getQueryFileDirectory", "setQueryFileDirectory", "queryFiles", "schemaFile", "serializer", "Lcom/expediagroup/graphql/plugin/client/generator/GraphQLSerializer;", "configureProjectWithGeneratedSources", "", "mavenProject", "generatedSourcesDirectory", "execute", "locateQueryFiles", "files", "directory", "logConfiguration", "graphQLSchemaFilePath", "graphql-kotlin-maven-plugin"})
public abstract class GenerateClientAbstractMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${graphql.schemaFile}", name="schemaFile")
    private String schemaFile;
    @Parameter(defaultValue="${graphql.packageName}", name="packageName", required=true)
    private String packageName;
    @Parameter(defaultValue="${graphql.allowDeprecatedFields}", name="allowDeprecatedFields")
    private boolean allowDeprecatedFields;
    @Parameter(name="customScalars")
    private List<CustomScalar> customScalars;
    @Parameter(name="queryFiles")
    private List<? extends File> queryFiles;
    @Parameter(name="serializer")
    private GraphQLSerializer serializer;

    @NotNull
    public abstract File getQueryFileDirectory();

    public abstract void setQueryFileDirectory(@NotNull File var1);

    @NotNull
    public abstract File getOutputDirectory();

    public abstract void setOutputDirectory(@NotNull File var1);

    /*
     * WARNING - void declaration
     */
    public void execute() {
        void $this$mapTo$iv$iv;
        this.getLog().debug((CharSequence)"generating GraphQL client");
        String string = this.schemaFile;
        if (string == null) {
            MavenProject mavenProject = this.project;
            if (mavenProject == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            Build build = mavenProject.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)build, (String)"project.build");
            string = new File(build.getDirectory(), "schema.graphql").getPath();
        }
        String schemaPath = string;
        List<File> targetQueryFiles2 = this.locateQueryFiles(this.queryFiles, this.getQueryFileDirectory());
        if (!this.getOutputDirectory().isDirectory() && !this.getOutputDirectory().mkdirs()) {
            throw (Throwable)new RuntimeException("failed to generate generated source directory");
        }
        String string2 = schemaPath;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"schemaPath");
        this.logConfiguration(string2, targetQueryFiles2);
        Iterable $this$map$iv = this.customScalars;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CustomScalar customScalar = (CustomScalar)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GraphQLScalar graphQLScalar = new GraphQLScalar(it.getScalar(), it.getType(), it.getConverter());
            collection.add(graphQLScalar);
        }
        List customGraphQLScalars = (List)destination$iv$iv;
        String string3 = this.packageName;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        }
        Iterable $this$forEach$iv = GenerateClientKt.generateClient((String)string3, (boolean)this.allowDeprecatedFields, (List)customGraphQLScalars, (GraphQLSerializer)this.serializer, (String)schemaPath, targetQueryFiles2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSpec it = (FileSpec)element$iv;
            boolean bl = false;
            it.writeTo(this.getOutputDirectory());
        }
        MavenProject mavenProject = this.project;
        if (mavenProject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        this.configureProjectWithGeneratedSources(mavenProject, this.getOutputDirectory());
        this.getLog().debug((CharSequence)"successfully generated GraphQL HTTP client");
    }

    private final List<File> locateQueryFiles(List<? extends File> files, File directory) {
        List list = files;
        if (list == null) {
            Object[] objectArray = directory.listFiles(locateQueryFiles.targetQueryFiles.1.INSTANCE);
            list = objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }
        if (list == null) {
            throw (Throwable)new RuntimeException("exception while looking up the query files");
        }
        List targetQueryFiles2 = list;
        if (targetQueryFiles2.isEmpty()) {
            throw (Throwable)new RuntimeException("no query files specified");
        }
        return targetQueryFiles2;
    }

    public abstract void configureProjectWithGeneratedSources(@NotNull MavenProject var1, @NotNull File var2);

    private final void logConfiguration(String graphQLSchemaFilePath, List<? extends File> queryFiles) {
        this.getLog().debug((CharSequence)"GraphQL Client generator configuration:");
        this.getLog().debug((CharSequence)("  schema file = " + graphQLSchemaFilePath));
        this.getLog().debug((CharSequence)"  queries");
        Iterable $this$forEach$iv = queryFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getLog().debug((CharSequence)("    - " + it.getName()));
        }
        Log log = this.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("  packageName = ");
        String string = this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        }
        log.debug((CharSequence)stringBuilder.append(string).toString());
        this.getLog().debug((CharSequence)("  allowDeprecatedFields = " + this.allowDeprecatedFields));
        this.getLog().debug((CharSequence)"  converters");
        $this$forEach$iv = this.customScalars;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CustomScalar converterInfo = (CustomScalar)element$iv;
            boolean bl = false;
            this.getLog().debug((CharSequence)("    - custom scalar = " + converterInfo.getScalar()));
            this.getLog().debug((CharSequence)("      |- kotlin type = " + converterInfo.getType()));
            this.getLog().debug((CharSequence)("      |- converter = " + converterInfo.getConverter()));
        }
        this.getLog().debug((CharSequence)"");
        this.getLog().debug((CharSequence)"-- end GraphQL Client generator configuration --");
    }

    public GenerateClientAbstractMojo() {
        boolean bl = false;
        this.customScalars = new ArrayList();
        this.serializer = GraphQLSerializer.JACKSON;
    }
}

