/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.ktor;

import com.expediagroup.graphql.apq.cache.AutomaticPersistedQueriesCache;
import com.expediagroup.graphql.apq.cache.DefaultAutomaticPersistedQueriesCache;
import com.expediagroup.graphql.dataloader.KotlinDataLoader;
import com.expediagroup.graphql.dataloader.KotlinDataLoaderRegistryFactory;
import com.expediagroup.graphql.generator.TopLevelNames;
import com.expediagroup.graphql.generator.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.generator.execution.SimpleKotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.generator.hooks.FlowSubscriptionSchemaGeneratorHooks;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.generator.scalars.IDValueUnboxer;
import com.expediagroup.graphql.server.Schema;
import com.expediagroup.graphql.server.ktor.DefaultKtorGraphQLContextFactory;
import com.expediagroup.graphql.server.ktor.GraphQLConfiguration;
import com.expediagroup.graphql.server.ktor.GraphQLConfigurationKt;
import com.expediagroup.graphql.server.ktor.KtorGraphQLContextFactory;
import com.expediagroup.graphql.server.ktor.KtorGraphQLRequestParser;
import com.expediagroup.graphql.server.ktor.subscriptions.DefaultKtorGraphQLSubscriptionContextFactory;
import com.expediagroup.graphql.server.ktor.subscriptions.DefaultKtorGraphQLSubscriptionHooks;
import com.expediagroup.graphql.server.ktor.subscriptions.DefaultKtorGraphQLSubscriptionRequestParser;
import com.expediagroup.graphql.server.ktor.subscriptions.KtorGraphQLSubscriptionContextFactory;
import com.expediagroup.graphql.server.ktor.subscriptions.KtorGraphQLSubscriptionHooks;
import com.expediagroup.graphql.server.ktor.subscriptions.KtorGraphQLSubscriptionRequestParser;
import com.expediagroup.graphql.server.operations.Mutation;
import com.expediagroup.graphql.server.operations.Query;
import com.expediagroup.graphql.server.operations.Subscription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\n\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0014J\u001f\u0010\t\u001a\u00020\u00112\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0014J\u001f\u0010\r\u001a\u00020\u00112\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "engine", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$EngineConfiguration;", "getEngine", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$EngineConfiguration;", "schema", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$SchemaConfiguration;", "getSchema", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$SchemaConfiguration;", "server", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$ServerConfiguration;", "getServer", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$ServerConfiguration;", "", "engineConfig", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "schemaConfig", "serverConfig", "AutomaticPersistedQueriesConfiguration", "BatchingConfiguration", "BatchingStrategy", "EngineConfiguration", "FederationConfiguration", "FederationTracingConfiguration", "IntrospectionConfiguration", "KtorSubscriptionConfiguration", "SchemaConfiguration", "ServerConfiguration", "graphql-kotlin-ktor-server"})
public final class GraphQLConfiguration {
    @NotNull
    private final SchemaConfiguration schema;
    @NotNull
    private final EngineConfiguration engine;
    @NotNull
    private final ServerConfiguration server;

    public GraphQLConfiguration(@NotNull ApplicationConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.schema = new SchemaConfiguration(config);
        this.engine = new EngineConfiguration(config);
        this.server = new ServerConfiguration(config);
    }

    @NotNull
    public final SchemaConfiguration getSchema() {
        return this.schema;
    }

    public final void schema(@NotNull Function1<? super SchemaConfiguration, Unit> schemaConfig) {
        Intrinsics.checkNotNullParameter(schemaConfig, (String)"schemaConfig");
        SchemaConfiguration schemaConfiguration = this.schema;
        schemaConfig.invoke((Object)schemaConfiguration);
    }

    @NotNull
    public final EngineConfiguration getEngine() {
        return this.engine;
    }

    public final void engine(@NotNull Function1<? super EngineConfiguration, Unit> engineConfig) {
        Intrinsics.checkNotNullParameter(engineConfig, (String)"engineConfig");
        EngineConfiguration engineConfiguration = this.engine;
        engineConfig.invoke((Object)engineConfiguration);
    }

    @NotNull
    public final ServerConfiguration getServer() {
        return this.server;
    }

    public final void server(@NotNull Function1<? super ServerConfiguration, Unit> serverConfig) {
        Intrinsics.checkNotNullParameter(serverConfig, (String)"serverConfig");
        ServerConfiguration serverConfiguration = this.server;
        serverConfig.invoke((Object)serverConfiguration);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$AutomaticPersistedQueriesConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "cache", "Lcom/expediagroup/graphql/apq/cache/AutomaticPersistedQueriesCache;", "getCache", "()Lcom/expediagroup/graphql/apq/cache/AutomaticPersistedQueriesCache;", "setCache", "(Lcom/expediagroup/graphql/apq/cache/AutomaticPersistedQueriesCache;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "graphql-kotlin-ktor-server"})
    public static final class AutomaticPersistedQueriesConfiguration {
        private boolean enabled;
        @NotNull
        private AutomaticPersistedQueriesCache cache;

        public AutomaticPersistedQueriesConfiguration(@NotNull ApplicationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.enabled = Boolean.parseBoolean(ApplicationConfigKt.tryGetString((ApplicationConfig)config, (String)"graphql.engine.automaticPersistedQueries.enabled"));
            this.cache = (AutomaticPersistedQueriesCache)new DefaultAutomaticPersistedQueriesCache();
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        @NotNull
        public final AutomaticPersistedQueriesCache getCache() {
            return this.cache;
        }

        public final void setCache(@NotNull AutomaticPersistedQueriesCache automaticPersistedQueriesCache) {
            Intrinsics.checkNotNullParameter((Object)automaticPersistedQueriesCache, (String)"<set-?>");
            this.cache = automaticPersistedQueriesCache;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$BatchingConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "strategy", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$BatchingStrategy;", "getStrategy", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$BatchingStrategy;", "setStrategy", "(Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$BatchingStrategy;)V", "graphql-kotlin-ktor-server"})
    public static final class BatchingConfiguration {
        private boolean enabled;
        @NotNull
        private BatchingStrategy strategy;

        public BatchingConfiguration(@NotNull ApplicationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.enabled = Boolean.parseBoolean(ApplicationConfigKt.tryGetString((ApplicationConfig)config, (String)"graphql.engine.batching.enabled"));
            this.strategy = GraphQLConfigurationKt.access$toBatchingStrategy(ApplicationConfigKt.tryGetString((ApplicationConfig)config, (String)"graphql.engine.batching.strategy"));
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        @NotNull
        public final BatchingStrategy getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(@NotNull BatchingStrategy batchingStrategy) {
            Intrinsics.checkNotNullParameter((Object)((Object)batchingStrategy), (String)"<set-?>");
            this.strategy = batchingStrategy;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$BatchingStrategy;", "", "(Ljava/lang/String;I)V", "SYNC_EXHAUSTION", "graphql-kotlin-ktor-server"})
    public static final class BatchingStrategy
    extends Enum<BatchingStrategy> {
        public static final /* enum */ BatchingStrategy SYNC_EXHAUSTION = new BatchingStrategy();
        private static final /* synthetic */ BatchingStrategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BatchingStrategy[] values() {
            return (BatchingStrategy[])$VALUES.clone();
        }

        public static BatchingStrategy valueOf(String value) {
            return Enum.valueOf(BatchingStrategy.class, value);
        }

        @NotNull
        public static EnumEntries<BatchingStrategy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = batchingStrategyArray = new BatchingStrategy[]{BatchingStrategy.SYNC_EXHAUSTION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u00020>2\u0017\u0010?\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020>0@\u00a2\u0006\u0002\bAJ\u001f\u0010\t\u001a\u00020>2\u0017\u0010B\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020>0@\u00a2\u0006\u0002\bAJ\u001f\u00104\u001a\u00020>2\u0017\u0010C\u001a\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020>0@\u00a2\u0006\u0002\bAR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R \u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001c\u00108\u001a\u0004\u0018\u000109X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u00a8\u0006D"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$EngineConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "automaticPersistedQueries", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$AutomaticPersistedQueriesConfiguration;", "getAutomaticPersistedQueries", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$AutomaticPersistedQueriesConfiguration;", "batching", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$BatchingConfiguration;", "getBatching", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$BatchingConfiguration;", "setBatching", "(Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$BatchingConfiguration;)V", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;", "getDataFetcherFactoryProvider", "()Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;", "setDataFetcherFactoryProvider", "(Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;)V", "dataLoaderRegistryFactory", "Lcom/expediagroup/graphql/dataloader/KotlinDataLoaderRegistryFactory;", "getDataLoaderRegistryFactory", "()Lcom/expediagroup/graphql/dataloader/KotlinDataLoaderRegistryFactory;", "setDataLoaderRegistryFactory", "(Lcom/expediagroup/graphql/dataloader/KotlinDataLoaderRegistryFactory;)V", "exceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "getExceptionHandler", "()Lgraphql/execution/DataFetcherExceptionHandler;", "setExceptionHandler", "(Lgraphql/execution/DataFetcherExceptionHandler;)V", "executionIdProvider", "Lgraphql/execution/ExecutionIdProvider;", "getExecutionIdProvider", "()Lgraphql/execution/ExecutionIdProvider;", "setExecutionIdProvider", "(Lgraphql/execution/ExecutionIdProvider;)V", "idValueUnboxer", "Lcom/expediagroup/graphql/generator/scalars/IDValueUnboxer;", "getIdValueUnboxer", "()Lcom/expediagroup/graphql/generator/scalars/IDValueUnboxer;", "setIdValueUnboxer", "(Lcom/expediagroup/graphql/generator/scalars/IDValueUnboxer;)V", "instrumentations", "", "Lgraphql/execution/instrumentation/Instrumentation;", "getInstrumentations", "()Ljava/util/List;", "setInstrumentations", "(Ljava/util/List;)V", "introspection", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$IntrospectionConfiguration;", "getIntrospection", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$IntrospectionConfiguration;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "getPreparsedDocumentProvider", "()Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "setPreparsedDocumentProvider", "(Lgraphql/execution/preparsed/PreparsedDocumentProvider;)V", "", "apqConfig", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "batchingConfig", "introspectionConfig", "graphql-kotlin-ktor-server"})
    public static final class EngineConfiguration {
        @NotNull
        private final AutomaticPersistedQueriesConfiguration automaticPersistedQueries;
        @NotNull
        private BatchingConfiguration batching;
        @NotNull
        private final IntrospectionConfiguration introspection;
        @NotNull
        private KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider;
        @NotNull
        private KotlinDataLoaderRegistryFactory dataLoaderRegistryFactory;
        @NotNull
        private DataFetcherExceptionHandler exceptionHandler;
        @Nullable
        private ExecutionIdProvider executionIdProvider;
        @NotNull
        private IDValueUnboxer idValueUnboxer;
        @NotNull
        private List<? extends Instrumentation> instrumentations;
        @Nullable
        private PreparsedDocumentProvider preparsedDocumentProvider;

        public EngineConfiguration(@NotNull ApplicationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.automaticPersistedQueries = new AutomaticPersistedQueriesConfiguration(config);
            this.batching = new BatchingConfiguration(config);
            this.introspection = new IntrospectionConfiguration(config);
            this.dataFetcherFactoryProvider = (KotlinDataFetcherFactoryProvider)new SimpleKotlinDataFetcherFactoryProvider();
            this.dataLoaderRegistryFactory = new KotlinDataLoaderRegistryFactory(new KotlinDataLoader[0]);
            this.exceptionHandler = (DataFetcherExceptionHandler)new SimpleDataFetcherExceptionHandler();
            this.idValueUnboxer = new IDValueUnboxer();
            this.instrumentations = CollectionsKt.emptyList();
        }

        @NotNull
        public final AutomaticPersistedQueriesConfiguration getAutomaticPersistedQueries() {
            return this.automaticPersistedQueries;
        }

        public final void automaticPersistedQueries(@NotNull Function1<? super AutomaticPersistedQueriesConfiguration, Unit> apqConfig) {
            Intrinsics.checkNotNullParameter(apqConfig, (String)"apqConfig");
            AutomaticPersistedQueriesConfiguration automaticPersistedQueriesConfiguration = this.automaticPersistedQueries;
            apqConfig.invoke((Object)automaticPersistedQueriesConfiguration);
        }

        @NotNull
        public final BatchingConfiguration getBatching() {
            return this.batching;
        }

        public final void setBatching(@NotNull BatchingConfiguration batchingConfiguration) {
            Intrinsics.checkNotNullParameter((Object)batchingConfiguration, (String)"<set-?>");
            this.batching = batchingConfiguration;
        }

        public final void batching(@NotNull Function1<? super BatchingConfiguration, Unit> batchingConfig) {
            Intrinsics.checkNotNullParameter(batchingConfig, (String)"batchingConfig");
            BatchingConfiguration batchingConfiguration = this.batching;
            batchingConfig.invoke((Object)batchingConfiguration);
        }

        @NotNull
        public final IntrospectionConfiguration getIntrospection() {
            return this.introspection;
        }

        public final void introspection(@NotNull Function1<? super IntrospectionConfiguration, Unit> introspectionConfig) {
            Intrinsics.checkNotNullParameter(introspectionConfig, (String)"introspectionConfig");
            IntrospectionConfiguration introspectionConfiguration = this.introspection;
            introspectionConfig.invoke((Object)introspectionConfiguration);
        }

        @NotNull
        public final KotlinDataFetcherFactoryProvider getDataFetcherFactoryProvider() {
            return this.dataFetcherFactoryProvider;
        }

        public final void setDataFetcherFactoryProvider(@NotNull KotlinDataFetcherFactoryProvider kotlinDataFetcherFactoryProvider) {
            Intrinsics.checkNotNullParameter((Object)kotlinDataFetcherFactoryProvider, (String)"<set-?>");
            this.dataFetcherFactoryProvider = kotlinDataFetcherFactoryProvider;
        }

        @NotNull
        public final KotlinDataLoaderRegistryFactory getDataLoaderRegistryFactory() {
            return this.dataLoaderRegistryFactory;
        }

        public final void setDataLoaderRegistryFactory(@NotNull KotlinDataLoaderRegistryFactory kotlinDataLoaderRegistryFactory) {
            Intrinsics.checkNotNullParameter((Object)kotlinDataLoaderRegistryFactory, (String)"<set-?>");
            this.dataLoaderRegistryFactory = kotlinDataLoaderRegistryFactory;
        }

        @NotNull
        public final DataFetcherExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        public final void setExceptionHandler(@NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler) {
            Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"<set-?>");
            this.exceptionHandler = dataFetcherExceptionHandler;
        }

        @Nullable
        public final ExecutionIdProvider getExecutionIdProvider() {
            return this.executionIdProvider;
        }

        public final void setExecutionIdProvider(@Nullable ExecutionIdProvider executionIdProvider) {
            this.executionIdProvider = executionIdProvider;
        }

        @NotNull
        public final IDValueUnboxer getIdValueUnboxer() {
            return this.idValueUnboxer;
        }

        public final void setIdValueUnboxer(@NotNull IDValueUnboxer iDValueUnboxer) {
            Intrinsics.checkNotNullParameter((Object)iDValueUnboxer, (String)"<set-?>");
            this.idValueUnboxer = iDValueUnboxer;
        }

        @NotNull
        public final List<Instrumentation> getInstrumentations() {
            return this.instrumentations;
        }

        public final void setInstrumentations(@NotNull List<? extends Instrumentation> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.instrumentations = list;
        }

        @Nullable
        public final PreparsedDocumentProvider getPreparsedDocumentProvider() {
            return this.preparsedDocumentProvider;
        }

        public final void setPreparsedDocumentProvider(@Nullable PreparsedDocumentProvider preparsedDocumentProvider) {
            this.preparsedDocumentProvider = preparsedDocumentProvider;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0012\u001a\u00020\u00182\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00180\u001a\u00a2\u0006\u0002\b\u001bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$FederationConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "entities", "", "Lkotlin/reflect/KClass;", "getEntities", "()Ljava/util/List;", "setEntities", "(Ljava/util/List;)V", "tracing", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$FederationTracingConfiguration;", "getTracing", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$FederationTracingConfiguration;", "setTracing", "(Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$FederationTracingConfiguration;)V", "", "tracingConfig", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "graphql-kotlin-ktor-server"})
    public static final class FederationConfiguration {
        private boolean enabled;
        @Nullable
        private List<? extends KClass<?>> entities;
        @NotNull
        private FederationTracingConfiguration tracing;

        public FederationConfiguration(@NotNull ApplicationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.enabled = Boolean.parseBoolean(ApplicationConfigKt.tryGetString((ApplicationConfig)config, (String)"graphql.schema.federation.enabled"));
            this.tracing = new FederationTracingConfiguration(config);
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        @Nullable
        public final List<KClass<?>> getEntities() {
            return this.entities;
        }

        public final void setEntities(@Nullable List<? extends KClass<?>> list) {
            this.entities = list;
        }

        @NotNull
        public final FederationTracingConfiguration getTracing() {
            return this.tracing;
        }

        public final void setTracing(@NotNull FederationTracingConfiguration federationTracingConfiguration) {
            Intrinsics.checkNotNullParameter((Object)federationTracingConfiguration, (String)"<set-?>");
            this.tracing = federationTracingConfiguration;
        }

        public final void tracing(@NotNull Function1<? super FederationTracingConfiguration, Unit> tracingConfig) {
            Intrinsics.checkNotNullParameter(tracingConfig, (String)"tracingConfig");
            FederationTracingConfiguration federationTracingConfiguration = this.tracing;
            tracingConfig.invoke((Object)federationTracingConfiguration);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$FederationTracingConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "enabled", "getEnabled", "setEnabled", "graphql-kotlin-ktor-server"})
    public static final class FederationTracingConfiguration {
        private boolean enabled;
        private boolean debug;

        public FederationTracingConfiguration(@NotNull ApplicationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            String string = ApplicationConfigKt.tryGetString((ApplicationConfig)config, (String)"graphql.schema.federation.tracing.enabled");
            this.enabled = string != null ? Boolean.parseBoolean(string) : true;
            this.debug = Boolean.parseBoolean(ApplicationConfigKt.tryGetString((ApplicationConfig)config, (String)"graphql.schema.federation.tracing.enabled"));
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public final boolean getDebug() {
            return this.debug;
        }

        public final void setDebug(boolean bl) {
            this.debug = bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$IntrospectionConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "graphql-kotlin-ktor-server"})
    public static final class IntrospectionConfiguration {
        private boolean enabled;

        public IntrospectionConfiguration(@NotNull ApplicationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            String string = ApplicationConfigKt.tryGetString((ApplicationConfig)config, (String)"graphql.engine.introspection.enabled");
            this.enabled = string != null ? Boolean.parseBoolean(string) : true;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$KtorSubscriptionConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "connectionInitTimeout", "", "getConnectionInitTimeout", "()J", "setConnectionInitTimeout", "(J)V", "contextFactory", "Lcom/expediagroup/graphql/server/ktor/subscriptions/KtorGraphQLSubscriptionContextFactory;", "getContextFactory", "()Lcom/expediagroup/graphql/server/ktor/subscriptions/KtorGraphQLSubscriptionContextFactory;", "setContextFactory", "(Lcom/expediagroup/graphql/server/ktor/subscriptions/KtorGraphQLSubscriptionContextFactory;)V", "hooks", "Lcom/expediagroup/graphql/server/ktor/subscriptions/KtorGraphQLSubscriptionHooks;", "getHooks", "()Lcom/expediagroup/graphql/server/ktor/subscriptions/KtorGraphQLSubscriptionHooks;", "setHooks", "(Lcom/expediagroup/graphql/server/ktor/subscriptions/KtorGraphQLSubscriptionHooks;)V", "requestParser", "Lcom/expediagroup/graphql/server/ktor/subscriptions/KtorGraphQLSubscriptionRequestParser;", "getRequestParser", "()Lcom/expediagroup/graphql/server/ktor/subscriptions/KtorGraphQLSubscriptionRequestParser;", "setRequestParser", "(Lcom/expediagroup/graphql/server/ktor/subscriptions/KtorGraphQLSubscriptionRequestParser;)V", "graphql-kotlin-ktor-server"})
    public static final class KtorSubscriptionConfiguration {
        @NotNull
        private KtorGraphQLSubscriptionRequestParser requestParser;
        @NotNull
        private KtorGraphQLSubscriptionContextFactory contextFactory;
        @NotNull
        private KtorGraphQLSubscriptionHooks hooks;
        private long connectionInitTimeout;

        public KtorSubscriptionConfiguration(@NotNull ApplicationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.requestParser = new DefaultKtorGraphQLSubscriptionRequestParser();
            this.contextFactory = new DefaultKtorGraphQLSubscriptionContextFactory();
            this.hooks = new DefaultKtorGraphQLSubscriptionHooks();
            Object object = ApplicationConfigKt.tryGetString((ApplicationConfig)config, (String)"graphql.server.subscription.connectionInitTimeout");
            this.connectionInitTimeout = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 60000L;
        }

        @NotNull
        public final KtorGraphQLSubscriptionRequestParser getRequestParser() {
            return this.requestParser;
        }

        public final void setRequestParser(@NotNull KtorGraphQLSubscriptionRequestParser ktorGraphQLSubscriptionRequestParser) {
            Intrinsics.checkNotNullParameter((Object)ktorGraphQLSubscriptionRequestParser, (String)"<set-?>");
            this.requestParser = ktorGraphQLSubscriptionRequestParser;
        }

        @NotNull
        public final KtorGraphQLSubscriptionContextFactory getContextFactory() {
            return this.contextFactory;
        }

        public final void setContextFactory(@NotNull KtorGraphQLSubscriptionContextFactory ktorGraphQLSubscriptionContextFactory) {
            Intrinsics.checkNotNullParameter((Object)ktorGraphQLSubscriptionContextFactory, (String)"<set-?>");
            this.contextFactory = ktorGraphQLSubscriptionContextFactory;
        }

        @NotNull
        public final KtorGraphQLSubscriptionHooks getHooks() {
            return this.hooks;
        }

        public final void setHooks(@NotNull KtorGraphQLSubscriptionHooks ktorGraphQLSubscriptionHooks) {
            Intrinsics.checkNotNullParameter((Object)ktorGraphQLSubscriptionHooks, (String)"<set-?>");
            this.hooks = ktorGraphQLSubscriptionHooks;
        }

        public final long getConnectionInitTimeout() {
            return this.connectionInitTimeout;
        }

        public final void setConnectionInitTimeout(long l) {
            this.connectionInitTimeout = l;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0002052\u0017\u00106\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020507\u00a2\u0006\u0002\b8R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R \u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010\u0015R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R6\u0010.\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u000300\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003000\u0010\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u00069"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$SchemaConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "federation", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$FederationConfiguration;", "getFederation", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$FederationConfiguration;", "hooks", "Lcom/expediagroup/graphql/generator/hooks/SchemaGeneratorHooks;", "getHooks", "()Lcom/expediagroup/graphql/generator/hooks/SchemaGeneratorHooks;", "setHooks", "(Lcom/expediagroup/graphql/generator/hooks/SchemaGeneratorHooks;)V", "mutations", "", "Lcom/expediagroup/graphql/server/operations/Mutation;", "getMutations", "()Ljava/util/List;", "setMutations", "(Ljava/util/List;)V", "packages", "", "getPackages", "setPackages", "queries", "Lcom/expediagroup/graphql/server/operations/Query;", "getQueries", "setQueries", "schemaObject", "Lcom/expediagroup/graphql/server/Schema;", "getSchemaObject", "()Lcom/expediagroup/graphql/server/Schema;", "setSchemaObject", "(Lcom/expediagroup/graphql/server/Schema;)V", "subscriptions", "Lcom/expediagroup/graphql/server/operations/Subscription;", "getSubscriptions", "setSubscriptions", "topLevelNames", "Lcom/expediagroup/graphql/generator/TopLevelNames;", "getTopLevelNames", "()Lcom/expediagroup/graphql/generator/TopLevelNames;", "setTopLevelNames", "(Lcom/expediagroup/graphql/generator/TopLevelNames;)V", "typeHierarchy", "", "Lkotlin/reflect/KClass;", "getTypeHierarchy", "()Ljava/util/Map;", "setTypeHierarchy", "(Ljava/util/Map;)V", "", "federationConfig", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "graphql-kotlin-ktor-server"})
    public static final class SchemaConfiguration {
        @Nullable
        private List<String> packages;
        @NotNull
        private List<? extends Query> queries;
        @NotNull
        private List<? extends Mutation> mutations;
        @NotNull
        private List<? extends Subscription> subscriptions;
        @Nullable
        private Schema schemaObject;
        @NotNull
        private TopLevelNames topLevelNames;
        @NotNull
        private SchemaGeneratorHooks hooks;
        @NotNull
        private final FederationConfiguration federation;
        @Nullable
        private Map<KClass<?>, ? extends List<? extends KClass<?>>> typeHierarchy;

        public SchemaConfiguration(@NotNull ApplicationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.packages = ApplicationConfigKt.tryGetStringList((ApplicationConfig)config, (String)"graphql.schema.packages");
            this.queries = CollectionsKt.emptyList();
            this.mutations = CollectionsKt.emptyList();
            this.subscriptions = CollectionsKt.emptyList();
            this.topLevelNames = new TopLevelNames(null, null, null, 7, null);
            this.hooks = (SchemaGeneratorHooks)new FlowSubscriptionSchemaGeneratorHooks();
            this.federation = new FederationConfiguration(config);
        }

        @Nullable
        public final List<String> getPackages() {
            return this.packages;
        }

        public final void setPackages(@Nullable List<String> list) {
            this.packages = list;
        }

        @NotNull
        public final List<Query> getQueries() {
            return this.queries;
        }

        public final void setQueries(@NotNull List<? extends Query> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.queries = list;
        }

        @NotNull
        public final List<Mutation> getMutations() {
            return this.mutations;
        }

        public final void setMutations(@NotNull List<? extends Mutation> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.mutations = list;
        }

        @NotNull
        public final List<Subscription> getSubscriptions() {
            return this.subscriptions;
        }

        public final void setSubscriptions(@NotNull List<? extends Subscription> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.subscriptions = list;
        }

        @Nullable
        public final Schema getSchemaObject() {
            return this.schemaObject;
        }

        public final void setSchemaObject(@Nullable Schema schema) {
            this.schemaObject = schema;
        }

        @NotNull
        public final TopLevelNames getTopLevelNames() {
            return this.topLevelNames;
        }

        public final void setTopLevelNames(@NotNull TopLevelNames topLevelNames) {
            Intrinsics.checkNotNullParameter((Object)topLevelNames, (String)"<set-?>");
            this.topLevelNames = topLevelNames;
        }

        @NotNull
        public final SchemaGeneratorHooks getHooks() {
            return this.hooks;
        }

        public final void setHooks(@NotNull SchemaGeneratorHooks schemaGeneratorHooks) {
            Intrinsics.checkNotNullParameter((Object)schemaGeneratorHooks, (String)"<set-?>");
            this.hooks = schemaGeneratorHooks;
        }

        @NotNull
        public final FederationConfiguration getFederation() {
            return this.federation;
        }

        public final void federation(@NotNull Function1<? super FederationConfiguration, Unit> federationConfig) {
            Intrinsics.checkNotNullParameter(federationConfig, (String)"federationConfig");
            FederationConfiguration federationConfiguration = this.federation;
            federationConfig.invoke((Object)federationConfiguration);
        }

        @Nullable
        public final Map<KClass<?>, List<KClass<?>>> getTypeHierarchy() {
            return this.typeHierarchy;
        }

        public final void setTypeHierarchy(@Nullable Map<KClass<?>, ? extends List<? extends KClass<?>>> map) {
            this.typeHierarchy = map;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u001a\u001a\u00020\u000e2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$ServerConfiguration;", "", "config", "Lio/ktor/server/config/ApplicationConfig;", "(Lio/ktor/server/config/ApplicationConfig;)V", "contextFactory", "Lcom/expediagroup/graphql/server/ktor/KtorGraphQLContextFactory;", "getContextFactory", "()Lcom/expediagroup/graphql/server/ktor/KtorGraphQLContextFactory;", "setContextFactory", "(Lcom/expediagroup/graphql/server/ktor/KtorGraphQLContextFactory;)V", "jacksonConfiguration", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "", "Lkotlin/ExtensionFunctionType;", "getJacksonConfiguration", "()Lkotlin/jvm/functions/Function1;", "setJacksonConfiguration", "(Lkotlin/jvm/functions/Function1;)V", "requestParser", "Lcom/expediagroup/graphql/server/ktor/KtorGraphQLRequestParser;", "getRequestParser", "()Lcom/expediagroup/graphql/server/ktor/KtorGraphQLRequestParser;", "setRequestParser", "(Lcom/expediagroup/graphql/server/ktor/KtorGraphQLRequestParser;)V", "subscriptions", "Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$KtorSubscriptionConfiguration;", "getSubscriptions", "()Lcom/expediagroup/graphql/server/ktor/GraphQLConfiguration$KtorSubscriptionConfiguration;", "subscriptionConfig", "graphql-kotlin-ktor-server"})
    public static final class ServerConfiguration {
        @NotNull
        private KtorGraphQLContextFactory contextFactory;
        @NotNull
        private Function1<? super ObjectMapper, Unit> jacksonConfiguration;
        @NotNull
        private KtorGraphQLRequestParser requestParser;
        @NotNull
        private final KtorSubscriptionConfiguration subscriptions;

        public ServerConfiguration(@NotNull ApplicationConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.contextFactory = new DefaultKtorGraphQLContextFactory();
            this.jacksonConfiguration = jacksonConfiguration.1.INSTANCE;
            ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
            this.jacksonConfiguration.invoke((Object)objectMapper);
            this.requestParser = new KtorGraphQLRequestParser(objectMapper);
            this.subscriptions = new KtorSubscriptionConfiguration(config);
        }

        @NotNull
        public final KtorGraphQLContextFactory getContextFactory() {
            return this.contextFactory;
        }

        public final void setContextFactory(@NotNull KtorGraphQLContextFactory ktorGraphQLContextFactory) {
            Intrinsics.checkNotNullParameter((Object)ktorGraphQLContextFactory, (String)"<set-?>");
            this.contextFactory = ktorGraphQLContextFactory;
        }

        @NotNull
        public final Function1<ObjectMapper, Unit> getJacksonConfiguration() {
            return this.jacksonConfiguration;
        }

        public final void setJacksonConfiguration(@NotNull Function1<? super ObjectMapper, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.jacksonConfiguration = function1;
        }

        @NotNull
        public final KtorGraphQLRequestParser getRequestParser() {
            return this.requestParser;
        }

        public final void setRequestParser(@NotNull KtorGraphQLRequestParser ktorGraphQLRequestParser) {
            Intrinsics.checkNotNullParameter((Object)ktorGraphQLRequestParser, (String)"<set-?>");
            this.requestParser = ktorGraphQLRequestParser;
        }

        @NotNull
        public final KtorSubscriptionConfiguration getSubscriptions() {
            return this.subscriptions;
        }

        public final void subscriptions(@NotNull Function1<? super KtorSubscriptionConfiguration, Unit> subscriptionConfig) {
            Intrinsics.checkNotNullParameter(subscriptionConfig, (String)"subscriptionConfig");
            KtorSubscriptionConfiguration ktorSubscriptionConfiguration = this.subscriptions;
            subscriptionConfig.invoke((Object)ktorSubscriptionConfiguration);
        }
    }
}

