/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle.tasks;

import com.expediagroup.graphql.plugin.gradle.actions.GenerateSDLAction;
import com.expediagroup.graphql.plugin.gradle.parameters.GenerateSDLParameters;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0015H'R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/tasks/GraphQLGenerateSDLTask;", "Lorg/gradle/api/tasks/SourceTask;", "()V", "packages", "Lorg/gradle/api/provider/ListProperty;", "", "getPackages", "()Lorg/gradle/api/provider/ListProperty;", "pluginClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPluginClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "projectClasspath", "getProjectClasspath", "schemaFile", "Lorg/gradle/api/file/RegularFileProperty;", "getSchemaFile", "()Lorg/gradle/api/file/RegularFileProperty;", "generateSDLAction", "", "getWorkerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "graphql-kotlin-gradle-plugin"})
public abstract class GraphQLGenerateSDLTask
extends SourceTask {
    @NotNull
    private final ConfigurableFileCollection pluginClasspath;
    @NotNull
    private final ConfigurableFileCollection projectClasspath;
    @Input
    @Optional
    @Option(option="packages", description="List of supported packages that can be scanned to generate SDL")
    @NotNull
    private final ListProperty<String> packages;
    @OutputFile
    @NotNull
    private final RegularFileProperty schemaFile;

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getProjectClasspath() {
        return this.projectClasspath;
    }

    @NotNull
    public final ListProperty<String> getPackages() {
        return this.packages;
    }

    @NotNull
    public final RegularFileProperty getSchemaFile() {
        return this.schemaFile;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public final void generateSDLAction() {
        File targetDirectory;
        Object object = this.packages.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"packages.get()");
        List packages = (List)object;
        if (packages.isEmpty()) {
            throw (Throwable)new RuntimeException("attempt to generate SDL failed - missing required supportedPackages property");
        }
        Object object2 = this.schemaFile.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"schemaFile.asFile.get()");
        File generatedSchemaFile = (File)object2;
        File file = targetDirectory = generatedSchemaFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"targetDirectory");
        if (!file.isDirectory() && !targetDirectory.mkdirs()) {
            throw (Throwable)new RuntimeException("failed to generate target schema directory = " + targetDirectory);
        }
        WorkQueue workQueue2 = this.getWorkerExecutor().classLoaderIsolation((Action)new Action<ClassLoaderWorkerSpec>(this){
            final /* synthetic */ GraphQLGenerateSDLTask this$0;

            public final void execute(@NotNull ClassLoaderWorkerSpec workerSpec) {
                Intrinsics.checkNotNullParameter((Object)workerSpec, (String)"workerSpec");
                FileCollection fileCollection = this.this$0.getPluginClasspath().plus((FileCollection)this.this$0.getProjectClasspath());
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"pluginClasspath.plus(projectClasspath)");
                Iterable iterable = (Iterable)fileCollection;
                FileTree fileTree = this.this$0.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"source");
                Set set = fileTree.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"source.files");
                List workerClasspath = CollectionsKt.plus((Iterable)iterable, (Iterable)set);
                workerSpec.getClasspath().from(new Object[]{workerClasspath});
                Logger logger = this.this$0.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("worker classpath: \n");
                ConfigurableFileCollection configurableFileCollection = workerSpec.getClasspath();
                Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"workerSpec.classpath");
                Set set2 = configurableFileCollection.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"workerSpec.classpath.files");
                logger.debug(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
            }
            {
                this.this$0 = graphQLGenerateSDLTask;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"getWorkerExecutor().clas\u2026String(\"\\n\")}\")\n        }");
        WorkQueue workQueue3 = workQueue2;
        this.getLogger().debug("submitting work item to generate SDL for the supported packages = " + packages);
        workQueue3.submit(GenerateSDLAction.class, (Action)new Action<GenerateSDLParameters>(packages, generatedSchemaFile){
            final /* synthetic */ List $packages;
            final /* synthetic */ File $generatedSchemaFile;

            public final void execute(@NotNull GenerateSDLParameters parameters) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getSupportedPackages().set((Iterable)this.$packages);
                parameters.getSchemaFile().set((Object)this.$generatedSchemaFile);
            }
            {
                this.$packages = list;
                this.$generatedSchemaFile = file;
            }
        });
        workQueue3.await();
        this.getLogger().debug("successfully generated GraphQL schema");
    }

    public GraphQLGenerateSDLTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ConfigurableFileCollection configurableFileCollection = project.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.pluginClasspath = configurableFileCollection;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        ConfigurableFileCollection configurableFileCollection2 = project2.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"project.objects.fileCollection()");
        this.projectClasspath = configurableFileCollection2;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        ListProperty listProperty = project3.getObjects().listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"project.objects.listProperty(String::class.java)");
        this.packages = listProperty;
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        RegularFileProperty regularFileProperty = project4.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.schemaFile = regularFileProperty;
        this.setGroup("GraphQL");
        this.setDescription("Generate GraphQL schema in SDL format.");
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        ProjectLayout projectLayout = project5.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        this.schemaFile.convention(projectLayout.getBuildDirectory().file("schema.graphql"));
    }
}

