/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle.tasks;

import com.expediagroup.graphql.plugin.gradle.actions.DownloadSDLAction;
import com.expediagroup.graphql.plugin.gradle.config.TimeoutConfiguration;
import com.expediagroup.graphql.plugin.gradle.parameters.RetrieveSchemaParameters;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u001bH'R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u00020\u00128G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/tasks/GraphQLDownloadSDLTask;", "Lorg/gradle/api/DefaultTask;", "()V", "endpoint", "Lorg/gradle/api/provider/Property;", "", "getEndpoint", "()Lorg/gradle/api/provider/Property;", "headers", "Lorg/gradle/api/provider/MapProperty;", "", "getHeaders", "()Lorg/gradle/api/provider/MapProperty;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "pluginClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPluginClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "timeoutConfig", "Lcom/expediagroup/graphql/plugin/gradle/config/TimeoutConfiguration;", "getTimeoutConfig", "downloadSDLAction", "", "getWorkerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "graphql-kotlin-gradle-plugin"})
public abstract class GraphQLDownloadSDLTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection pluginClasspath;
    @Input
    @Option(option="endpoint", description="target SDL endpoint")
    @NotNull
    private final Property<String> endpoint;
    @Input
    @NotNull
    private final MapProperty<String, Object> headers;
    @Input
    @NotNull
    private final Property<TimeoutConfiguration> timeoutConfig;
    @OutputFile
    @NotNull
    private final RegularFileProperty outputFile;

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @NotNull
    public final Property<String> getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public final MapProperty<String, Object> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Property<TimeoutConfiguration> getTimeoutConfig() {
        return this.timeoutConfig;
    }

    @NotNull
    public final RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public final void downloadSDLAction() {
        File targetDirectory;
        Object object = this.outputFile.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputFile.asFile.get()");
        File schemaFile = (File)object;
        File file = targetDirectory = schemaFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"targetDirectory");
        if (!file.isDirectory() && !targetDirectory.mkdirs()) {
            throw (Throwable)new RuntimeException("failed to generate target schema directory = " + targetDirectory);
        }
        WorkQueue workQueue2 = this.getWorkerExecutor().classLoaderIsolation((Action)new Action<ClassLoaderWorkerSpec>(this){
            final /* synthetic */ GraphQLDownloadSDLTask this$0;

            public final void execute(@NotNull ClassLoaderWorkerSpec workerSpec) {
                Intrinsics.checkNotNullParameter((Object)workerSpec, (String)"workerSpec");
                workerSpec.getClasspath().from(new Object[]{this.this$0.getPluginClasspath()});
                Logger logger = this.this$0.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("worker classpath: \n");
                ConfigurableFileCollection configurableFileCollection = workerSpec.getClasspath();
                Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"workerSpec.classpath");
                Set set = configurableFileCollection.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"workerSpec.classpath.files");
                logger.debug(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
            }
            {
                this.this$0 = graphQLDownloadSDLTask;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"getWorkerExecutor().clas\u2026String(\"\\n\")}\")\n        }");
        WorkQueue workQueue3 = workQueue2;
        this.getLogger().debug("submitting work item to download SDL from " + (String)this.endpoint.get() + " endpoint");
        workQueue3.submit(DownloadSDLAction.class, (Action)new Action<RetrieveSchemaParameters>(this, schemaFile){
            final /* synthetic */ GraphQLDownloadSDLTask this$0;
            final /* synthetic */ File $schemaFile;

            public final void execute(@NotNull RetrieveSchemaParameters parameters) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getEndpoint().set((Provider)this.this$0.getEndpoint());
                parameters.getHeaders().set((Provider)this.this$0.getHeaders());
                parameters.getTimeoutConfiguration().set((Provider)this.this$0.getTimeoutConfig());
                parameters.getSchemaFile().set((Object)this.$schemaFile);
            }
            {
                this.this$0 = graphQLDownloadSDLTask;
                this.$schemaFile = file;
            }
        });
        workQueue3.await();
        this.getLogger().debug("successfully downloaded GraphQL schema");
    }

    public GraphQLDownloadSDLTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ConfigurableFileCollection configurableFileCollection = project.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.pluginClasspath = configurableFileCollection;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Property property = project2.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.endpoint = property;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        MapProperty mapProperty = project3.getObjects().mapProperty(String.class, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty, (String)"project.objects.mapPrope\u2026ss.java, Any::class.java)");
        this.headers = mapProperty;
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        Property property2 = project4.getObjects().property(TimeoutConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"project.objects.property\u2026onfiguration::class.java)");
        this.timeoutConfig = property2;
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        RegularFileProperty regularFileProperty = project5.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.outputFile = regularFileProperty;
        this.setGroup("GraphQL");
        this.setDescription("Download schema in SDL format from target endpoint.");
        this.headers.convention(MapsKt.emptyMap());
        this.timeoutConfig.convention((Object)new TimeoutConfiguration(0L, 0L, 3, null));
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
        ProjectLayout projectLayout = project6.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        this.outputFile.convention(projectLayout.getBuildDirectory().file("schema.graphql"));
    }
}

