/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle.tasks;

import com.expediagroup.graphql.plugin.gradle.actions.GenerateClientAction;
import com.expediagroup.graphql.plugin.gradle.config.GraphQLScalar;
import com.expediagroup.graphql.plugin.gradle.config.GraphQLSerializer;
import com.expediagroup.graphql.plugin.gradle.parameters.GenerateClientParameters;
import com.expediagroup.graphql.plugin.gradle.tasks.AbstractGenerateClientTask;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010%\u001a\u00020&H\u0007J\b\u0010'\u001a\u00020(H'J\u001e\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0013\u0010\u0014\u001a\u00020\u00158G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0016\u0010\u001a\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0016\u0010\u001c\u001a\u00020\u001d8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0007\u00a8\u0006-"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/tasks/AbstractGenerateClientTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowDeprecatedFields", "Lorg/gradle/api/provider/Property;", "", "getAllowDeprecatedFields", "()Lorg/gradle/api/provider/Property;", "customScalars", "Lorg/gradle/api/provider/ListProperty;", "Lcom/expediagroup/graphql/plugin/gradle/config/GraphQLScalar;", "getCustomScalars", "()Lorg/gradle/api/provider/ListProperty;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "packageName", "", "getPackageName", "pluginClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPluginClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "queryFileDirectory", "getQueryFileDirectory", "queryFiles", "getQueryFiles", "schemaFile", "Lorg/gradle/api/file/RegularFileProperty;", "getSchemaFile", "()Lorg/gradle/api/file/RegularFileProperty;", "schemaFileName", "getSchemaFileName", "serializer", "Lcom/expediagroup/graphql/plugin/gradle/config/GraphQLSerializer;", "getSerializer", "generateGraphQLClientAction", "", "getWorkerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "logConfiguration", "schemaPath", "", "Ljava/io/File;", "graphql-kotlin-gradle-plugin"})
public abstract class AbstractGenerateClientTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection pluginClasspath;
    @Input
    @Optional
    @Option(option="schemaFileName", description="path to GraphQL schema file that will be used to generate the client code")
    @NotNull
    private final Property<String> schemaFileName;
    @InputFile
    @Optional
    @NotNull
    private final RegularFileProperty schemaFile;
    @Input
    @Option(option="packageName", description="target package name to use for generated classes")
    @NotNull
    private final Property<String> packageName;
    @Input
    @Optional
    @Option(option="allowDeprecatedFields", description="boolean flag indicating whether selection of deprecated fields is allowed or not")
    @NotNull
    private final Property<Boolean> allowDeprecatedFields;
    @Input
    @Optional
    @NotNull
    private final ListProperty<GraphQLScalar> customScalars;
    @Input
    @Optional
    @Option(option="queryFileDirectory", description="directory containing query files")
    @NotNull
    private final Property<String> queryFileDirectory;
    @InputFiles
    @Optional
    @NotNull
    private final ConfigurableFileCollection queryFiles;
    @Input
    @Optional
    @Option(option="serializer", description="JSON serializer that will be used to generate the data classes.")
    @NotNull
    private final Property<GraphQLSerializer> serializer;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDirectory;

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @NotNull
    public final Property<String> getSchemaFileName() {
        return this.schemaFileName;
    }

    @NotNull
    public final RegularFileProperty getSchemaFile() {
        return this.schemaFile;
    }

    @NotNull
    public final Property<String> getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final Property<Boolean> getAllowDeprecatedFields() {
        return this.allowDeprecatedFields;
    }

    @NotNull
    public final ListProperty<GraphQLScalar> getCustomScalars() {
        return this.customScalars;
    }

    @NotNull
    public final Property<String> getQueryFileDirectory() {
        return this.queryFileDirectory;
    }

    @NotNull
    public final ConfigurableFileCollection getQueryFiles() {
        return this.queryFiles;
    }

    @NotNull
    public final Property<GraphQLSerializer> getSerializer() {
        return this.serializer;
    }

    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public final void generateGraphQLClientAction() {
        Object object;
        String string;
        this.getLogger().debug("generating GraphQL client");
        if (this.schemaFile.isPresent()) {
            Object object2 = this.schemaFile.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"schemaFile.get()");
            File file = ((RegularFile)object2).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"schemaFile.get().asFile");
            string = file.getPath();
        } else if (this.schemaFileName.isPresent()) {
            string = (String)this.schemaFileName.get();
        } else {
            throw (Throwable)new RuntimeException("schema not available");
        }
        String graphQLSchemaPath = string;
        String string2 = (String)this.packageName.getOrNull();
        if (string2 == null) {
            throw (Throwable)new RuntimeException("package not specified");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageName.orNull ?: th\u2026(\"package not specified\")");
        String targetPackage = string2;
        Set set = this.queryFiles.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"queryFiles.files");
        Collection collection = set;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Set set2 = this.queryFiles.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"queryFiles.files");
            object = CollectionsKt.toList((Iterable)set2);
        } else if (this.queryFileDirectory.isPresent()) {
            object = new File((String)this.queryFileDirectory.get()).listFiles(generateGraphQLClientAction.targetQueryFiles.1.INSTANCE);
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                throw (Throwable)new RuntimeException("exception while looking up the query files");
            }
        } else {
            throw (Throwable)new RuntimeException("no query files found");
        }
        Object[] targetQueryFiles2 = object;
        if (targetQueryFiles2.isEmpty()) {
            throw (Throwable)new RuntimeException("no query files specified");
        }
        Object object3 = this.outputDirectory.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"outputDirectory.get()");
        File file = ((Directory)object3).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDirectory.get().asFile");
        File targetDirectory = file;
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            throw (Throwable)new RuntimeException("failed to generate generated source directory = " + targetDirectory);
        }
        String string3 = graphQLSchemaPath;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"graphQLSchemaPath");
        this.logConfiguration(string3, (List<? extends File>)targetQueryFiles2);
        WorkQueue workQueue2 = this.getWorkerExecutor().classLoaderIsolation((Action)new Action<ClassLoaderWorkerSpec>(this){
            final /* synthetic */ AbstractGenerateClientTask this$0;

            public final void execute(@NotNull ClassLoaderWorkerSpec workerSpec) {
                Intrinsics.checkNotNullParameter((Object)workerSpec, (String)"workerSpec");
                workerSpec.getClasspath().from(new Object[]{this.this$0.getPluginClasspath()});
                Logger logger = this.this$0.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("worker classpath: \n");
                ConfigurableFileCollection configurableFileCollection = workerSpec.getClasspath();
                Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"workerSpec.classpath");
                Set set = configurableFileCollection.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"workerSpec.classpath.files");
                logger.debug(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
            }
            {
                this.this$0 = abstractGenerateClientTask;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"getWorkerExecutor().clas\u2026String(\"\\n\")}\")\n        }");
        WorkQueue workQueue3 = workQueue2;
        workQueue3.submit(GenerateClientAction.class, (Action)new Action<GenerateClientParameters>(this, targetPackage, graphQLSchemaPath, (List)targetQueryFiles2, targetDirectory){
            final /* synthetic */ AbstractGenerateClientTask this$0;
            final /* synthetic */ String $targetPackage;
            final /* synthetic */ String $graphQLSchemaPath;
            final /* synthetic */ List $targetQueryFiles;
            final /* synthetic */ File $targetDirectory;

            public final void execute(@NotNull GenerateClientParameters parameters) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getPackageName().set((Object)this.$targetPackage);
                parameters.getAllowDeprecated().set((Provider)this.this$0.getAllowDeprecatedFields());
                parameters.getCustomScalars().set((Provider)this.this$0.getCustomScalars());
                parameters.getSerializer().set((Provider)this.this$0.getSerializer());
                parameters.getSchemaPath().set((Object)this.$graphQLSchemaPath);
                parameters.getQueryFiles().set((Iterable)this.$targetQueryFiles);
                parameters.getTargetDirectory().set((Object)this.$targetDirectory);
            }
            {
                this.this$0 = abstractGenerateClientTask;
                this.$targetPackage = string;
                this.$graphQLSchemaPath = string2;
                this.$targetQueryFiles = list;
                this.$targetDirectory = file;
            }
        });
        workQueue3.await();
        this.getLogger().debug("successfully generated GraphQL HTTP client");
    }

    /*
     * WARNING - void declaration
     */
    private final void logConfiguration(String schemaPath, List<? extends File> queryFiles) {
        this.getLogger().debug("GraphQL Client generator configuration:");
        this.getLogger().debug("  schema file = " + schemaPath);
        this.getLogger().debug("  queries");
        Iterable $this$forEach$iv = queryFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getLogger().debug("    - " + it.getName());
        }
        this.getLogger().debug("  packageName = " + this.packageName);
        this.getLogger().debug("  allowDeprecatedFields = " + this.allowDeprecatedFields);
        this.getLogger().debug("  converters");
        Object object = this.customScalars.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"customScalars.get()");
        $this$forEach$iv = (Iterable)object;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void type;
            void customScalar;
            GraphQLScalar $dstr$customScalar$type$converter = (GraphQLScalar)element$iv;
            boolean bl = false;
            String string = $dstr$customScalar$type$converter.component1();
            String string2 = $dstr$customScalar$type$converter.component2();
            String converter = $dstr$customScalar$type$converter.component3();
            this.getLogger().debug("    - custom scalar = " + (String)customScalar);
            this.getLogger().debug("      |- type = " + (String)type);
            this.getLogger().debug("      |- converter = " + converter);
        }
        this.getLogger().debug("");
        this.getLogger().debug("-- end GraphQL Client generator configuration --");
    }

    public AbstractGenerateClientTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ConfigurableFileCollection configurableFileCollection = project.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.pluginClasspath = configurableFileCollection;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Property property = project2.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.schemaFileName = property;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        RegularFileProperty regularFileProperty = project3.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.schemaFile = regularFileProperty;
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        Property property2 = project4.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"project.objects.property(String::class.java)");
        this.packageName = property2;
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        Property property3 = project5.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects.property(Boolean::class.java)");
        this.allowDeprecatedFields = property3;
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
        ListProperty listProperty = project6.getObjects().listProperty(GraphQLScalar.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"project.objects.listProp\u2026raphQLScalar::class.java)");
        this.customScalars = listProperty;
        Project project7 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
        Property property4 = project7.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"project.objects.property(String::class.java)");
        this.queryFileDirectory = property4;
        Project project8 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"project");
        ConfigurableFileCollection configurableFileCollection2 = project8.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"project.objects.fileCollection()");
        this.queryFiles = configurableFileCollection2;
        Project project9 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project9, (String)"project");
        Property property5 = project9.getObjects().property(GraphQLSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"project.objects.property\u2026QLSerializer::class.java)");
        this.serializer = property5;
        Project project10 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project10, (String)"project");
        DirectoryProperty directoryProperty = project10.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.outputDirectory = directoryProperty;
        this.setGroup("GraphQL");
        this.setDescription("Generate HTTP client from the specified GraphQL queries.");
        this.allowDeprecatedFields.convention((Object)false);
        this.customScalars.convention((Iterable)CollectionsKt.emptyList());
        this.serializer.convention((Object)GraphQLSerializer.JACKSON);
        StringBuilder stringBuilder = new StringBuilder();
        Project project11 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project11, (String)"project");
        this.queryFileDirectory.convention((Object)stringBuilder.append(project11.getProjectDir()).append("/src/main/resources").toString());
        Project project12 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project12, (String)"project");
        ProjectLayout projectLayout = project12.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        this.outputDirectory.convention(projectLayout.getBuildDirectory().dir("generated/source/graphql/main"));
    }
}

