/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle;

import com.expediagroup.graphql.plugin.gradle.GraphQLPluginExtension;
import com.expediagroup.graphql.plugin.gradle.config.TimeoutConfiguration;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLDownloadSDLTask;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLGenerateClientTask;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLGenerateSDLTask;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLGenerateTestClientTask;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLIntrospectSchemaTask;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/GraphQLGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "configurePluginDependencies", "configureProjectSourceSet", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "targetSourceSet", "", "configureTaskClasspaths", "processExtensionConfiguration", "extension", "Lcom/expediagroup/graphql/plugin/gradle/GraphQLPluginExtension;", "registerTasks", "graphql-kotlin-gradle-plugin"})
public final class GraphQLGradlePlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.configurePluginDependencies(project);
        this.registerTasks(project);
        Object object = project.getExtensions().create("graphql", GraphQLPluginExtension.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026ginExtension::class.java)");
        GraphQLPluginExtension extension = (GraphQLPluginExtension)object;
        project.afterEvaluate((Action)new Action<Project>(this, project, extension){
            final /* synthetic */ GraphQLGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ GraphQLPluginExtension $extension;

            public final void execute(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GraphQLGradlePlugin.access$processExtensionConfiguration(this.this$0, this.$project, this.$extension);
                GraphQLGradlePlugin.access$configureTaskClasspaths(this.this$0, this.$project);
            }
            {
                this.this$0 = graphQLGradlePlugin;
                this.$project = project;
                this.$extension = graphQLPluginExtension;
            }
        });
    }

    private final void configurePluginDependencies(Project project) {
        project.getConfigurations().create("graphqlClient", (Action)new Action<Configuration>(project){
            final /* synthetic */ Project $project;

            public final void execute(@NotNull Configuration configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                configuration.setVisible(true);
                configuration.setTransitive(true);
                configuration.setDescription("Configuration for generating GraphQL client");
                configuration.getDependencies().add((Object)this.$project.getDependencies().create((Object)"com.expediagroup:graphql-kotlin-client-generator:4.2.0"));
            }
            {
                this.$project = project;
            }
        });
        project.getConfigurations().create("graphqlSDL", (Action)new Action<Configuration>(project){
            final /* synthetic */ Project $project;

            public final void execute(@NotNull Configuration configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                configuration.setVisible(true);
                configuration.setTransitive(true);
                configuration.setDescription("Configuration for generating GraphQL schema in SDL format");
                configuration.getDependencies().add((Object)this.$project.getDependencies().create((Object)"com.expediagroup:graphql-kotlin-sdl-generator:4.2.0"));
            }
            {
                this.$project = project;
            }
        });
    }

    private final void registerTasks(Project project) {
        project.getTasks().register("graphqlDownloadSDL", GraphQLDownloadSDLTask.class);
        project.getTasks().register("graphqlGenerateClient", GraphQLGenerateClientTask.class);
        project.getTasks().register("graphqlGenerateTestClient", GraphQLGenerateTestClientTask.class);
        project.getTasks().register("graphqlGenerateSDL", GraphQLGenerateSDLTask.class);
        project.getTasks().register("graphqlIntrospectSchema", GraphQLIntrospectSchemaTask.class);
    }

    private final void configureProjectSourceSet(Project project, DirectoryProperty outputDirectory, String targetSourceSet) {
        block1: {
            SourceSetContainer sourceSetContainer;
            SourceSetContainer sourceSetContainer2;
            Object object = project.findProperty("sourceSets");
            if (!(object instanceof SourceSetContainer)) {
                object = null;
            }
            if ((sourceSetContainer2 = (sourceSetContainer = (SourceSetContainer)object)) == null || (sourceSetContainer2 = (SourceSet)sourceSetContainer2.findByName(targetSourceSet)) == null || (sourceSetContainer2 = sourceSetContainer2.getJava()) == null) break block1;
            sourceSetContainer2.srcDir((Object)outputDirectory);
        }
    }

    static /* synthetic */ void configureProjectSourceSet$default(GraphQLGradlePlugin graphQLGradlePlugin, Project project, DirectoryProperty directoryProperty, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "main";
        }
        graphQLGradlePlugin.configureProjectSourceSet(project, directoryProperty, string);
    }

    private final void processExtensionConfiguration(Project project, GraphQLPluginExtension extension) {
        if (extension.isClientConfigurationAvailable$graphql_kotlin_gradle_plugin() && extension.getClientExtension$graphql_kotlin_gradle_plugin().getPackageName() != null) {
            Object object = project.getTasks().named("graphqlGenerateClient", GraphQLGenerateClientTask.class).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.tasks.named(GENE\u2026ntTask::class.java).get()");
            GraphQLGenerateClientTask generateClientTask = (GraphQLGenerateClientTask)((Object)object);
            generateClientTask.getPackageName().convention(project.provider((Callable)new Callable<String>(extension){
                final /* synthetic */ GraphQLPluginExtension $extension;

                @Nullable
                public final String call() {
                    return this.$extension.getClientExtension$graphql_kotlin_gradle_plugin().getPackageName();
                }
                {
                    this.$extension = graphQLPluginExtension;
                }
            }));
            generateClientTask.getAllowDeprecatedFields().convention(project.provider((Callable)new Callable<Boolean>(extension){
                final /* synthetic */ GraphQLPluginExtension $extension;

                public final Boolean call() {
                    return this.$extension.getClientExtension$graphql_kotlin_gradle_plugin().getAllowDeprecatedFields();
                }
                {
                    this.$extension = graphQLPluginExtension;
                }
            }));
            generateClientTask.getCustomScalars().convention((Iterable)extension.getClientExtension$graphql_kotlin_gradle_plugin().getCustomScalars());
            String queryFileDirectory = extension.getClientExtension$graphql_kotlin_gradle_plugin().getQueryFileDirectory();
            if (queryFileDirectory != null) {
                generateClientTask.getQueryFileDirectory().convention((Object)queryFileDirectory);
            }
            generateClientTask.getQueryFiles().setFrom((Iterable)extension.getClientExtension$graphql_kotlin_gradle_plugin().getQueryFiles());
            generateClientTask.getSerializer().convention((Object)extension.getClientExtension$graphql_kotlin_gradle_plugin().getSerializer());
            if (extension.getClientExtension$graphql_kotlin_gradle_plugin().getEndpoint() != null) {
                Object object2 = project.getTasks().named("graphqlIntrospectSchema", GraphQLIntrospectSchemaTask.class).get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.tasks.named(INTR\u2026maTask::class.java).get()");
                GraphQLIntrospectSchemaTask introspectSchemaTask = (GraphQLIntrospectSchemaTask)((Object)object2);
                introspectSchemaTask.getEndpoint().convention(project.provider((Callable)new Callable<String>(extension){
                    final /* synthetic */ GraphQLPluginExtension $extension;

                    @Nullable
                    public final String call() {
                        return this.$extension.getClientExtension$graphql_kotlin_gradle_plugin().getEndpoint();
                    }
                    {
                        this.$extension = graphQLPluginExtension;
                    }
                }));
                introspectSchemaTask.getHeaders().convention(project.provider((Callable)new Callable<Map<String, ? extends Object>>(extension){
                    final /* synthetic */ GraphQLPluginExtension $extension;

                    public final Map<String, Object> call() {
                        return this.$extension.getClientExtension$graphql_kotlin_gradle_plugin().getHeaders();
                    }
                    {
                        this.$extension = graphQLPluginExtension;
                    }
                }));
                introspectSchemaTask.getTimeoutConfig().convention(project.provider((Callable)new Callable<TimeoutConfiguration>(extension){
                    final /* synthetic */ GraphQLPluginExtension $extension;

                    public final TimeoutConfiguration call() {
                        return this.$extension.getClientExtension$graphql_kotlin_gradle_plugin().getTimeoutConfig$graphql_kotlin_gradle_plugin();
                    }
                    {
                        this.$extension = graphQLPluginExtension;
                    }
                }));
                generateClientTask.dependsOn(new Object[]{introspectSchemaTask.getPath()});
                generateClientTask.getSchemaFile().convention((Provider)introspectSchemaTask.getOutputFile());
            } else if (extension.getClientExtension$graphql_kotlin_gradle_plugin().getSdlEndpoint() != null) {
                Object object3 = project.getTasks().named("graphqlDownloadSDL", GraphQLDownloadSDLTask.class).get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"project.tasks.named(DOWN\u2026DLTask::class.java).get()");
                GraphQLDownloadSDLTask downloadSDLTask = (GraphQLDownloadSDLTask)((Object)object3);
                downloadSDLTask.getEndpoint().convention(project.provider((Callable)new Callable<String>(extension){
                    final /* synthetic */ GraphQLPluginExtension $extension;

                    @Nullable
                    public final String call() {
                        return this.$extension.getClientExtension$graphql_kotlin_gradle_plugin().getSdlEndpoint();
                    }
                    {
                        this.$extension = graphQLPluginExtension;
                    }
                }));
                downloadSDLTask.getHeaders().convention(project.provider((Callable)new Callable<Map<String, ? extends Object>>(extension){
                    final /* synthetic */ GraphQLPluginExtension $extension;

                    public final Map<String, Object> call() {
                        return this.$extension.getClientExtension$graphql_kotlin_gradle_plugin().getHeaders();
                    }
                    {
                        this.$extension = graphQLPluginExtension;
                    }
                }));
                downloadSDLTask.getTimeoutConfig().convention(project.provider((Callable)new Callable<TimeoutConfiguration>(extension){
                    final /* synthetic */ GraphQLPluginExtension $extension;

                    public final TimeoutConfiguration call() {
                        return this.$extension.getClientExtension$graphql_kotlin_gradle_plugin().getTimeoutConfig$graphql_kotlin_gradle_plugin();
                    }
                    {
                        this.$extension = graphQLPluginExtension;
                    }
                }));
                generateClientTask.dependsOn(new Object[]{downloadSDLTask.getPath()});
                generateClientTask.getSchemaFile().convention((Provider)downloadSDLTask.getOutputFile());
            } else {
                throw (Throwable)new RuntimeException("Invalid GraphQL client extension configuration - missing required endpoint/sdlEndpoint property");
            }
        }
        if (extension.isSchemaConfigurationAvailable$graphql_kotlin_gradle_plugin()) {
            List<String> supportedPackages = extension.getSchemaExtension$graphql_kotlin_gradle_plugin().getPackages();
            if (supportedPackages.isEmpty()) {
                throw (Throwable)new RuntimeException("Invalid GraphQL schema extension configuration - missing required supportedPackages property");
            }
            Object object = project.getTasks().named("graphqlGenerateSDL", GraphQLGenerateSDLTask.class).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.tasks.named(GENE\u2026DLTask::class.java).get()");
            GraphQLGenerateSDLTask generateSchemaTask = (GraphQLGenerateSDLTask)((Object)object);
            generateSchemaTask.getPackages().set((Iterable)supportedPackages);
        }
    }

    private final void configureTaskClasspaths(Project project) {
        project.getTasks().withType(GraphQLDownloadSDLTask.class).configureEach((Action)new Action<GraphQLDownloadSDLTask>(project){
            final /* synthetic */ Project $project;

            public final void execute(@NotNull GraphQLDownloadSDLTask downloadSDLTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)downloadSDLTask), (String)"downloadSDLTask");
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlClient");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ATE_CLIENT_CONFIGURATION)");
                Configuration configuration2 = configuration;
                downloadSDLTask.getPluginClasspath().setFrom((Iterable)configuration2);
            }
            {
                this.$project = project;
            }
        });
        project.getTasks().withType(GraphQLGenerateClientTask.class).configureEach((Action)new Action<GraphQLGenerateClientTask>(this, project){
            final /* synthetic */ GraphQLGradlePlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(@NotNull GraphQLGenerateClientTask generateClientTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)generateClientTask), (String)"generateClientTask");
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlClient");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ATE_CLIENT_CONFIGURATION)");
                Configuration configuration2 = configuration;
                generateClientTask.getPluginClasspath().setFrom((Iterable)configuration2);
                generateClientTask.finalizedBy(new Object[]{this.$project.getTasks().named("compileKotlin")});
                GraphQLGradlePlugin.configureProjectSourceSet$default(this.this$0, this.$project, generateClientTask.getOutputDirectory(), null, 4, null);
            }
            {
                this.this$0 = graphQLGradlePlugin;
                this.$project = project;
            }
        });
        project.getTasks().withType(GraphQLGenerateTestClientTask.class).configureEach((Action)new Action<GraphQLGenerateTestClientTask>(this, project){
            final /* synthetic */ GraphQLGradlePlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(@NotNull GraphQLGenerateTestClientTask generateTestClientTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)generateTestClientTask), (String)"generateTestClientTask");
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlClient");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ATE_CLIENT_CONFIGURATION)");
                Configuration configuration2 = configuration;
                generateTestClientTask.getPluginClasspath().setFrom((Iterable)configuration2);
                generateTestClientTask.finalizedBy(new Object[]{this.$project.getTasks().named("compileTestKotlin")});
                GraphQLGradlePlugin.access$configureProjectSourceSet(this.this$0, this.$project, generateTestClientTask.getOutputDirectory(), "test");
            }
            {
                this.this$0 = graphQLGradlePlugin;
                this.$project = project;
            }
        });
        project.getTasks().withType(GraphQLIntrospectSchemaTask.class).configureEach((Action)new Action<GraphQLIntrospectSchemaTask>(project){
            final /* synthetic */ Project $project;

            public final void execute(@NotNull GraphQLIntrospectSchemaTask introspectionTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)introspectionTask), (String)"introspectionTask");
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlClient");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ATE_CLIENT_CONFIGURATION)");
                Configuration configuration2 = configuration;
                introspectionTask.getPluginClasspath().setFrom((Iterable)configuration2);
            }
            {
                this.$project = project;
            }
        });
        project.getTasks().withType(GraphQLGenerateSDLTask.class).configureEach((Action)new Action<GraphQLGenerateSDLTask>(project){
            final /* synthetic */ Project $project;

            public final void execute(@NotNull GraphQLGenerateSDLTask generateSDLTask) {
                SourceSetContainer sourceSetContainer;
                Intrinsics.checkNotNullParameter((Object)((Object)generateSDLTask), (String)"generateSDLTask");
                Object object = this.$project.findProperty("sourceSets");
                if (!(object instanceof SourceSetContainer)) {
                    object = null;
                }
                SourceSetContainer sourceSetContainer2 = sourceSetContainer = (SourceSetContainer)object;
                SourceSet mainSourceSet = sourceSetContainer2 != null ? (SourceSet)sourceSetContainer2.findByName("main") : null;
                Object[] objectArray = new Object[1];
                SourceSet sourceSet = mainSourceSet;
                objectArray[0] = sourceSet != null ? sourceSet.getOutput() : null;
                generateSDLTask.source(objectArray);
                Object[] objectArray2 = new Object[1];
                SourceSet sourceSet2 = mainSourceSet;
                objectArray2[0] = sourceSet2 != null ? sourceSet2.getRuntimeClasspath() : null;
                generateSDLTask.getProjectClasspath().setFrom(objectArray2);
                Configuration configuration = this.$project.getConfigurations().getAt("graphqlSDL");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026NERATE_SDL_CONFIGURATION)");
                Configuration configuration2 = configuration;
                generateSDLTask.getPluginClasspath().setFrom((Iterable)configuration2);
                generateSDLTask.dependsOn(new Object[]{this.$project.getTasks().named("compileKotlin")});
            }
            {
                this.$project = project;
            }
        });
    }

    public static final /* synthetic */ void access$processExtensionConfiguration(GraphQLGradlePlugin $this, Project project, GraphQLPluginExtension extension) {
        $this.processExtensionConfiguration(project, extension);
    }

    public static final /* synthetic */ void access$configureTaskClasspaths(GraphQLGradlePlugin $this, Project project) {
        $this.configureTaskClasspaths(project);
    }

    public static final /* synthetic */ void access$configureProjectSourceSet(GraphQLGradlePlugin $this, Project project, DirectoryProperty outputDirectory, String targetSourceSet) {
        $this.configureProjectSourceSet(project, outputDirectory, targetSourceSet);
    }
}

