/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.client.jackson;

import com.expediagroup.graphql.client.jackson.types.JacksonGraphQLResponse;
import com.expediagroup.graphql.client.jackson.types.OptionalInput;
import com.expediagroup.graphql.client.jackson.types.UndefinedFilter;
import com.expediagroup.graphql.client.serializer.GraphQLClientSerializer;
import com.expediagroup.graphql.client.types.GraphQLClientRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u000fH\u0016J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\bH\u0016J,\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000f2\u0006\u0010\u0016\u001a\u00020\u000b2\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u000fH\u0016J \u0010\u0018\u001a\u00020\t\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00120\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/expediagroup/graphql/client/jackson/GraphQLClientJacksonSerializer;", "Lcom/expediagroup/graphql/client/serializer/GraphQLClientSerializer;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "typeCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/reflect/KClass;", "Lcom/fasterxml/jackson/databind/JavaType;", "serialize", "", "request", "Lcom/expediagroup/graphql/client/types/GraphQLClientRequest;", "requests", "", "deserialize", "Lcom/expediagroup/graphql/client/jackson/types/JacksonGraphQLResponse;", "T", "", "rawResponse", "responseType", "rawResponses", "responseTypes", "parameterizedType", "resultType", "graphql-kotlin-client-jackson"})
@SourceDebugExtension(value={"SMAP\nGraphQLClientJacksonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLClientJacksonSerializer.kt\ncom/expediagroup/graphql/client/jackson/GraphQLClientJacksonSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1557#2:71\n1628#2,3:72\n*S KotlinDebug\n*F\n+ 1 GraphQLClientJacksonSerializer.kt\ncom/expediagroup/graphql/client/jackson/GraphQLClientJacksonSerializer\n*L\n55#1:71\n55#1:72,3\n*E\n"})
public final class GraphQLClientJacksonSerializer
implements GraphQLClientSerializer {
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final ConcurrentHashMap<KClass<?>, JavaType> typeCache;

    public GraphQLClientJacksonSerializer(@NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
        this.typeCache = new ConcurrentHashMap();
        this.mapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configOverride(OptionalInput.class).setInclude(JsonInclude.Value.empty().withValueInclusion(JsonInclude.Include.CUSTOM).withValueFilter(UndefinedFilter.class));
    }

    public /* synthetic */ GraphQLClientJacksonSerializer(ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            objectMapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
        }
        this(objectMapper);
    }

    @NotNull
    public String serialize(@NotNull GraphQLClientRequest<?> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        String string = this.mapper.writeValueAsString(request);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @NotNull
    public String serialize(@NotNull List<? extends GraphQLClientRequest<?>> requests) {
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        String string = this.mapper.writeValueAsString(requests);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @NotNull
    public <T> JacksonGraphQLResponse<T> deserialize(@NotNull String rawResponse, @NotNull KClass<T> responseType) {
        Intrinsics.checkNotNullParameter((Object)rawResponse, (String)"rawResponse");
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        Object object = this.mapper.readValue(rawResponse, this.parameterizedType(responseType));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (JacksonGraphQLResponse)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<JacksonGraphQLResponse<?>> deserialize(@NotNull String rawResponses, @NotNull List<? extends KClass<?>> responseTypes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)rawResponses, (String)"rawResponses");
        Intrinsics.checkNotNullParameter(responseTypes, (String)"responseTypes");
        JsonNode jsonResponse = this.mapper.readTree(rawResponses);
        if (jsonResponse.isArray()) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNull((Object)jsonResponse);
            Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)((Iterable)jsonResponse));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int index = indexedValue.component1();
                JsonNode element = (JsonNode)indexedValue.component2();
                Object object = this.mapper.convertValue((Object)element, this.parameterizedType(responseTypes.get(index)));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"convertValue(...)");
                JacksonGraphQLResponse singleResponse = (JacksonGraphQLResponse)object;
                collection.add(singleResponse);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)this.mapper.convertValue((Object)jsonResponse, this.parameterizedType((KClass)CollectionsKt.first(responseTypes))));
        }
        return list;
    }

    private final <T> JavaType parameterizedType(KClass<T> resultType) {
        JavaType javaType = this.typeCache.computeIfAbsent(resultType, arg_0 -> GraphQLClientJacksonSerializer.parameterizedType$lambda$2(arg_0 -> GraphQLClientJacksonSerializer.parameterizedType$lambda$1(this, resultType, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"computeIfAbsent(...)");
        return javaType;
    }

    private static final JavaType parameterizedType$lambda$1(GraphQLClientJacksonSerializer this$0, KClass $resultType, KClass it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resultType, (String)"$resultType");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Class[] classArray = new Class[]{JvmClassMappingKt.getJavaClass((KClass)$resultType)};
        return this$0.mapper.getTypeFactory().constructParametricType(JacksonGraphQLResponse.class, classArray);
    }

    private static final JavaType parameterizedType$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JavaType)$tmp0.invoke(p0);
    }

    public GraphQLClientJacksonSerializer() {
        this(null, 1, null);
    }
}

