/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.client.generator;

import com.expediagroup.graphql.client.Generated;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorConfig;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorContext;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorKt;
import com.expediagroup.graphql.plugin.client.generator.GraphQLSerializer;
import com.expediagroup.graphql.plugin.client.generator.ScalarConverterInfo;
import com.expediagroup.graphql.plugin.client.generator.exceptions.MultipleOperationsInFileException;
import com.expediagroup.graphql.plugin.client.generator.exceptions.SchemaUnavailableException;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLObjectTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateVariableTypeSpecKt;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeAliasSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import graphql.language.Document;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.parser.Parser;
import graphql.parser.ParserOptions;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.Required;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGenerator;", "", "schemaPath", "", "config", "Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorConfig;", "(Ljava/lang/String;Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorConfig;)V", "documentParser", "Lgraphql/parser/Parser;", "generateOptionalSerializer", "", "graphQLSchema", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "parserOptions", "Lgraphql/parser/ParserOptions;", "sharedTypes", "", "Lcom/squareup/kotlinpoet/ClassName;", "", "Lcom/squareup/kotlinpoet/TypeSpec;", "typeAliases", "Lcom/squareup/kotlinpoet/TypeAliasSpec;", "findRootType", "Lgraphql/language/ObjectTypeDefinition;", "operationDefinition", "Lgraphql/language/OperationDefinition;", "generate", "Lcom/squareup/kotlinpoet/FileSpec;", "queryFile", "Ljava/io/File;", "generate$graphql_kotlin_client_generator", "queries", "parseSchema", "path", "graphql-kotlin-client-generator"})
@SourceDebugExtension(value={"SMAP\nGraphQLClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLClientGenerator.kt\ncom/expediagroup/graphql/plugin/client/generator/GraphQLClientGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,273:1\n1#2:274\n215#3,2:275\n215#3,2:278\n1855#4:277\n1238#4,4:282\n1238#4,4:288\n1855#4,2:292\n1238#4,4:296\n1856#4:300\n1208#4,2:301\n1238#4,4:303\n442#5:280\n392#5:281\n442#5:286\n392#5:287\n442#5:294\n392#5:295\n*S KotlinDebug\n*F\n+ 1 GraphQLClientGenerator.kt\ncom/expediagroup/graphql/plugin/client/generator/GraphQLClientGenerator\n*L\n84#1:275,2\n193#1:278,2\n106#1:277\n203#1:282,4\n204#1:288,4\n207#1:292,2\n223#1:296,4\n106#1:300\n231#1:301,2\n231#1:303,4\n203#1:280\n203#1:281\n204#1:286\n204#1:287\n223#1:294\n223#1:295\n*E\n"})
public final class GraphQLClientGenerator {
    @NotNull
    private final GraphQLClientGeneratorConfig config;
    @NotNull
    private final Parser documentParser;
    @NotNull
    private final Map<String, TypeAliasSpec> typeAliases;
    @NotNull
    private final Map<ClassName, List<TypeSpec>> sharedTypes;
    private boolean generateOptionalSerializer;
    @NotNull
    private final TypeDefinitionRegistry graphQLSchema;
    @NotNull
    private final ParserOptions parserOptions;

    /*
     * WARNING - void declaration
     */
    public GraphQLClientGenerator(@NotNull String schemaPath, @NotNull GraphQLClientGeneratorConfig config) {
        void it;
        ParserOptions.Builder builder;
        Intrinsics.checkNotNullParameter((Object)schemaPath, (String)"schemaPath");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.documentParser = new Parser();
        this.typeAliases = new LinkedHashMap();
        this.sharedTypes = new LinkedHashMap();
        ParserOptions.Builder builder2 = builder = ParserOptions.newParserOptions();
        GraphQLClientGenerator graphQLClientGenerator = this;
        boolean bl = false;
        Function1<ParserOptions.Builder, Unit> function1 = this.config.getParserOptions();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        function1.invoke((Object)it);
        ParserOptions parserOptions = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)parserOptions, (String)"newParserOptions().also \u2026rserOptions(it) }.build()");
        graphQLClientGenerator.parserOptions = parserOptions;
        this.graphQLSchema = this.parseSchema(schemaPath);
    }

    @NotNull
    public final List<FileSpec> generate(@NotNull List<? extends File> queries) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        List result = new ArrayList();
        for (File file : queries) {
            result.addAll((Collection)this.generate$graphql_kotlin_client_generator(file));
        }
        for (Map.Entry entry : this.sharedTypes.entrySet()) {
            ClassName className2 = (ClassName)entry.getKey();
            List typeSpecs = (List)entry.getValue();
            FileSpec.Builder fileSpec = FileSpec.Companion.builder(className2.getPackageName(), className2.getSimpleName());
            for (TypeSpec type : typeSpecs) {
                fileSpec.addType(type);
            }
            result.add(fileSpec.build());
        }
        if (!this.typeAliases.isEmpty()) {
            FileSpec.Builder typeAliasSpec = FileSpec.Companion.builder(this.config.getPackageName(), "GraphQLTypeAliases");
            Map<String, TypeAliasSpec> map = this.typeAliases;
            boolean $i$f$forEach = false;
            for (Map.Entry<String, TypeAliasSpec> element$iv : map.entrySet()) {
                Map.Entry<String, TypeAliasSpec> entry = element$iv;
                boolean bl = false;
                TypeAliasSpec alias = (TypeAliasSpec)entry.getValue();
                typeAliasSpec.addTypeAlias(alias);
            }
            result.add(typeAliasSpec.build());
        }
        return result;
    }

    @NotNull
    public final List<FileSpec> generate$graphql_kotlin_client_generator(@NotNull File queryFile) {
        Intrinsics.checkNotNullParameter((Object)queryFile, (String)"queryFile");
        String queryConst = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)queryFile, null, (int)1, null))).toString();
        Document queryDocument = this.documentParser.parseDocument(queryConst, this.parserOptions);
        List list = queryDocument.getDefinitions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryDocument.definitions");
        List operationDefinitions = CollectionsKt.filterIsInstance((Iterable)list, OperationDefinition.class);
        if (operationDefinitions.size() > 1) {
            throw new MultipleOperationsInFileException(queryFile);
        }
        List fileSpecs = new ArrayList();
        FileSpec.Builder operationFileSpec = FileSpec.Companion.builder(this.config.getPackageName(), GraphQLClientGeneratorKt.capitalizeFirstChar(FilesKt.getNameWithoutExtension((File)queryFile)));
        Iterable $this$forEach$iv = operationDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list2;
            Map.Entry it;
            Map map;
            Object k;
            Map.Entry it$iv$iv;
            boolean bl;
            Object $this$mapValuesTo$iv$iv;
            Object $this$mapValues$iv;
            Map.Entry element$iv2;
            Object typeSpec;
            Map.Entry polymorphicTypeSpec;
            Object superClassName;
            Object[] variablesProperty;
            String[] it2;
            String[] operationNameProperty;
            String string;
            OperationDefinition operationDefinition;
            block20: {
                block19: {
                    operationDefinition = (OperationDefinition)element$iv;
                    boolean bl2 = false;
                    String string2 = operationDefinition.getName();
                    string = string2;
                    if (string == null) break block19;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    string = GraphQLClientGeneratorKt.capitalizeFirstChar(string2);
                    if (string != null) break block20;
                }
                string = GraphQLClientGeneratorKt.capitalizeFirstChar(FilesKt.getNameWithoutExtension((File)queryFile));
            }
            String capitalizedOperationName = string;
            String string3 = this.config.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)queryDocument, (String)"queryDocument");
            GraphQLClientGeneratorContext context = new GraphQLClientGeneratorContext(string3, this.graphQLSchema, capitalizedOperationName, queryDocument, this.config.getAllowDeprecated(), this.config.getCustomScalarMap(), this.config.getSerializer(), this.config.getUseOptionalInputWrapper());
            String queryConstName = GraphQLClientGeneratorKt.toUpperUnderscore(capitalizedOperationName);
            Object[] objectArray = new KModifier[]{KModifier.CONST};
            PropertySpec.Builder builder = PropertySpec.Companion.builder(queryConstName, (TypeName)TypeNames.STRING, new KModifier[0]).addModifiers((KModifier[])objectArray);
            objectArray = new Object[]{queryConst};
            PropertySpec queryConstProp = builder.initializer("%S", objectArray).build();
            operationFileSpec.addProperty(queryConstProp);
            ObjectTypeDefinition rootType = this.findRootType(operationDefinition);
            TypeSpec graphQLResponseTypeSpec = GenerateGraphQLObjectTypeSpecKt.generateGraphQLObjectTypeSpec(context, rootType, operationDefinition.getSelectionSet(), "Result");
            String[] stringArray = new String[]{context.getOperationName() + "." + graphQLResponseTypeSpec.getName()};
            ClassName kotlinResultTypeName = new ClassName(context.getPackageName(), stringArray);
            String[] stringArray2 = new String[]{"GraphQLClientRequest"};
            ClassName className2 = new ClassName("com.expediagroup.graphql.client.types", stringArray2);
            stringArray2 = new TypeName[]{kotlinResultTypeName};
            TypeSpec.Builder operationTypeSpec = TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Companion.classBuilder(capitalizedOperationName).addAnnotation(Reflection.getOrCreateKotlinClass(Generated.class)), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray2)), null, (int)2, null);
            Object[] objectArray2 = new KModifier[]{KModifier.OVERRIDE};
            PropertySpec.Builder builder2 = PropertySpec.Companion.builder("query", (TypeName)TypeNames.STRING, (KModifier[])objectArray2);
            objectArray2 = new Object[]{queryConstProp};
            PropertySpec queryProperty = builder2.initializer("%N", objectArray2).build();
            if (operationDefinition.getName() != null) {
                Object[] objectArray3 = new KModifier[]{KModifier.OVERRIDE};
                PropertySpec.Builder builder3 = PropertySpec.Companion.builder("operationName", (TypeName)TypeNames.STRING, (KModifier[])objectArray3);
                objectArray3 = new Object[]{operationDefinition.getName()};
                v7 = builder3.initializer("%S", objectArray3).build();
            } else {
                v7 = operationNameProperty = null;
            }
            if (this.config.getSerializer() == GraphQLSerializer.KOTLINX) {
                operationTypeSpec.addAnnotation(Reflection.getOrCreateKotlinClass(Serializable.class));
                queryProperty = PropertySpec.toBuilder$default((PropertySpec)queryProperty, null, null, (int)3, null).addAnnotation(Reflection.getOrCreateKotlinClass(Required.class)).build();
                String[] stringArray3 = operationNameProperty;
                operationNameProperty = operationNameProperty != null && (stringArray3 = PropertySpec.toBuilder$default((PropertySpec)stringArray3, null, null, (int)3, null)) != null && (stringArray3 = stringArray3.addAnnotation(Reflection.getOrCreateKotlinClass(Required.class))) != null ? stringArray3.build() : null;
            }
            operationTypeSpec.addProperty(queryProperty);
            if (operationNameProperty != null) {
                it2 = operationNameProperty;
                boolean bl3 = false;
                operationTypeSpec.addProperty(it2);
            }
            List list3 = operationDefinition.getVariableDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"operationDefinition.variableDefinitions");
            TypeSpec variableType = GenerateVariableTypeSpecKt.generateVariableTypeSpec(context, list3);
            if (variableType != null) {
                operationTypeSpec.addType(variableType);
                it2 = new String[]{capitalizedOperationName + ".Variables"};
                ClassName variablesClassName = new ClassName(this.config.getPackageName(), it2);
                KModifier[] bl3 = new KModifier[]{KModifier.OVERRIDE};
                variablesProperty = PropertySpec.Companion.builder("variables", (TypeName)variablesClassName, bl3).initializer("variables", new Object[0]).build();
                operationTypeSpec.addProperty((PropertySpec)variablesProperty);
                FunSpec constructor = FunSpec.Companion.constructorBuilder().addParameter("variables", (TypeName)variablesClassName, new KModifier[0]).build();
                operationTypeSpec.primaryConstructor(constructor);
            }
            variablesProperty = new String[]{"KClass"};
            ClassName className3 = new ClassName("kotlin.reflect", (String[])variablesProperty);
            variablesProperty = new TypeName[]{kotlinResultTypeName};
            ParameterizedTypeName parameterizedReturnType = ParameterizedTypeName.Companion.get(className3, (TypeName[])variablesProperty);
            variablesProperty = new KModifier[]{KModifier.OVERRIDE};
            FunSpec.Builder builder4 = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("responseType").addModifiers((KModifier[])variablesProperty), (TypeName)((TypeName)parameterizedReturnType), null, (int)2, null);
            variablesProperty = new Object[]{kotlinResultTypeName};
            operationTypeSpec.addFunction(builder4.addStatement("return %T::class", variablesProperty).build());
            operationTypeSpec.addType(graphQLResponseTypeSpec);
            List polymorphicTypes = new ArrayList();
            for (Map.Entry<ClassName, List<ClassName>> entry : context.getPolymorphicTypes().entrySet()) {
                superClassName = entry.getKey();
                List<ClassName> implementations = entry.getValue();
                polymorphicTypes.add(superClassName);
                polymorphicTypeSpec = FileSpec.Companion.builder(superClassName.getPackageName(), superClassName.getSimpleName());
                for (ClassName implementation : implementations) {
                    polymorphicTypes.add(implementation);
                    if (context.getTypeSpecs().get(implementation) == null) continue;
                    boolean bl4 = false;
                    polymorphicTypeSpec.addType((TypeSpec)typeSpec);
                }
                fileSpecs.add(polymorphicTypeSpec.build());
            }
            Map<ClassName, TypeSpec> $this$forEach$iv2 = MapsKt.minus(context.getTypeSpecs(), (Iterable)polymorphicTypes);
            boolean $i$f$forEach2 = false;
            superClassName = $this$forEach$iv2.entrySet().iterator();
            while (superClassName.hasNext()) {
                polymorphicTypeSpec = element$iv2 = (Map.Entry)superClassName.next();
                boolean bl5 = false;
                ClassName className4 = (ClassName)polymorphicTypeSpec.getKey();
                TypeSpec typeSpec2 = (TypeSpec)polymorphicTypeSpec.getValue();
                FileSpec outputTypeFileSpec = FileSpec.Companion.builder(className4.getPackageName(), className4.getSimpleName()).addType(typeSpec2).build();
                fileSpecs.add(outputTypeFileSpec);
            }
            operationFileSpec.addType(operationTypeSpec.build());
            fileSpecs.add(operationFileSpec.build());
            $this$forEach$iv2 = context.getEnumClassToTypeSpecs();
            Map<ClassName, List<TypeSpec>> map2 = this.sharedTypes;
            boolean $i$f$mapValues = false;
            superClassName = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                typeSpec = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map3;
                boolean bl6 = false;
                list2 = CollectionsKt.listOf(it.getValue());
                map.put(k, list2);
            }
            map2.putAll(destination$iv$iv);
            $this$mapValues$iv = context.getInputClassToTypeSpecs();
            map2 = this.sharedTypes;
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                bl = false;
                it = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map4;
                boolean bl7 = false;
                list2 = CollectionsKt.listOf(it.getValue());
                map.put(k, list2);
            }
            map2.putAll(destination$iv$iv);
            $this$mapValues$iv = context.getScalarClassToConverterTypeSpecs().values();
            $i$f$forEach2 = false;
            $this$mapValuesTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$mapValuesTo$iv$iv.hasNext()) {
                element$iv2 = $this$mapValuesTo$iv$iv.next();
                ScalarConverterInfo it3 = (ScalarConverterInfo)((Object)element$iv2);
                boolean bl8 = false;
                ScalarConverterInfo $i$f$associateByTo2 = it3;
                if ($i$f$associateByTo2 instanceof ScalarConverterInfo.JacksonConvertersInfo) {
                    this.sharedTypes.put(((ScalarConverterInfo.JacksonConvertersInfo)it3).getSerializerClassName(), CollectionsKt.listOf((Object)((ScalarConverterInfo.JacksonConvertersInfo)it3).getSerializerTypeSpec()));
                    this.sharedTypes.put(((ScalarConverterInfo.JacksonConvertersInfo)it3).getDeserializerClassName(), CollectionsKt.listOf((Object)((ScalarConverterInfo.JacksonConvertersInfo)it3).getDeserializerTypeSpec()));
                    continue;
                }
                if (!($i$f$associateByTo2 instanceof ScalarConverterInfo.KotlinxSerializerInfo)) continue;
                this.sharedTypes.put(((ScalarConverterInfo.KotlinxSerializerInfo)it3).getSerializerClassName(), CollectionsKt.listOf((Object)((ScalarConverterInfo.KotlinxSerializerInfo)it3).getSerializerTypeSpec()));
            }
            this.typeAliases.putAll(context.getTypeAliases());
            if (!context.getRequireOptionalSerializer()) continue;
            this.generateOptionalSerializer = true;
            $this$forEach$iv2 = context.getOptionalSerializers();
            map2 = this.sharedTypes;
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo3 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map5 = destination$iv$iv;
                bl = false;
                it = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map5;
                boolean bl9 = false;
                list2 = CollectionsKt.listOf(it.getValue());
                map.put(k, list2);
            }
            map2.putAll(destination$iv$iv);
        }
        return fileSpecs;
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectTypeDefinition findRootType(OperationDefinition operationDefinition) {
        Map map;
        if (this.graphQLSchema.schemaDefinition().isPresent()) {
            void $this$associateByTo$iv$iv;
            List list = ((SchemaDefinition)this.graphQLSchema.schemaDefinition().get()).getOperationTypeDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"graphQLSchema.schemaDefi\u2026.operationTypeDefinitions");
            $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Object object = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                String string;
                OperationTypeDefinition it;
                OperationTypeDefinition operationTypeDefinition = (OperationTypeDefinition)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                Intrinsics.checkNotNullExpressionValue((Object)string2.toUpperCase(Locale.ROOT), (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                it = (OperationTypeDefinition)element$iv$iv;
                boolean bl2 = false;
                String string3 = it.getTypeName().getName();
                map2.put(string, string3);
            }
            map = destination$iv$iv;
        } else {
            $this$associateBy$iv = new Pair[]{TuplesKt.to((Object)OperationDefinition.Operation.QUERY.name(), (Object)"Query"), TuplesKt.to((Object)OperationDefinition.Operation.MUTATION.name(), (Object)"Mutation"), TuplesKt.to((Object)OperationDefinition.Operation.SUBSCRIPTION.name(), (Object)"Subscription")};
            map = MapsKt.mapOf((Pair[])$this$associateBy$iv);
        }
        Map operationNames = map;
        String rootType = (String)operationNames.get(operationDefinition.getOperation().name());
        Object t = this.graphQLSchema.getType(rootType).get();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type graphql.language.ObjectTypeDefinition");
        return (ObjectTypeDefinition)t;
    }

    private final TypeDefinitionRegistry parseSchema(String path) {
        TypeDefinitionRegistry typeDefinitionRegistry;
        File schemaFile = new File(path);
        if (schemaFile.isFile()) {
            TypeDefinitionRegistry typeDefinitionRegistry2 = new SchemaParser().parse(schemaFile);
            typeDefinitionRegistry = typeDefinitionRegistry2;
            Intrinsics.checkNotNullExpressionValue((Object)typeDefinitionRegistry2, (String)"{\n            SchemaPars\u2026rse(schemaFile)\n        }");
        } else {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
            if (inputStream == null) {
                throw new SchemaUnavailableException(path);
            }
            InputStream schemaInputStream = inputStream;
            TypeDefinitionRegistry typeDefinitionRegistry3 = new SchemaParser().parse(schemaInputStream);
            Intrinsics.checkNotNullExpressionValue((Object)typeDefinitionRegistry3, (String)"{\n            val schema\u2026emaInputStream)\n        }");
            typeDefinitionRegistry = typeDefinitionRegistry3;
        }
        return typeDefinitionRegistry;
    }
}

