/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.client.generator.types;

import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorContext;
import com.expediagroup.graphql.plugin.client.generator.GraphQLScalar;
import com.expediagroup.graphql.plugin.client.generator.GraphQLSerializer;
import com.expediagroup.graphql.plugin.client.generator.ScalarConverterInfo;
import com.expediagroup.graphql.plugin.client.generator.exceptions.UnknownGraphQLTypeException;
import com.expediagroup.graphql.plugin.client.generator.extensions.DocumentExtensionsKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLCustomScalarConvertersKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLCustomScalarTypeAliasKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLEnumTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLInputObjectTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLInterfaceTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLObjectTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLUnionTypeSpecKt;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeAliasSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import graphql.Scalars;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.UnionTypeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0002H\u0002\u001a>\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u0002H\u0000\u001a(\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00122\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0000\u001a,\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00022\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0002*\u00020\nH\u0002\u00a8\u0006\u001b"}, d2={"calculateSelectedFields", "", "", "context", "Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorContext;", "targetType", "selectionSet", "Lgraphql/language/SelectionSet;", "path", "generateClassName", "Lcom/squareup/kotlinpoet/ClassName;", "graphQLType", "Lgraphql/language/NamedNode;", "nameOverride", "packageName", "generateCustomClassName", "generateTypeName", "Lcom/squareup/kotlinpoet/TypeName;", "Lgraphql/language/Type;", "optional", "", "isCachedTypeApplicable", "graphQLTypeName", "graphQLTypeDefinition", "Lgraphql/language/TypeDefinition;", "verifySelectionSet", "simpleNameWithoutWrapper", "graphql-kotlin-client-generator"})
public final class GenerateTypeNameKt {
    @NotNull
    public static final TypeName generateTypeName(@NotNull GraphQLClientGeneratorContext context, @NotNull Type<?> graphQLType, @Nullable SelectionSet selectionSet, boolean optional) {
        TypeName typeName;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(graphQLType, (String)"graphQLType");
        boolean nullable = optional || !(graphQLType instanceof NonNullType);
        Type<?> type = graphQLType;
        if (type instanceof NonNullType) {
            Type type2 = ((NonNullType)graphQLType).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"graphQLType.type");
            typeName = GenerateTypeNameKt.generateTypeName$default(context, type2, selectionSet, false, 8, null);
        } else if (type instanceof NamedNode) {
            String string = ((NamedNode)graphQLType).getName();
            typeName = (TypeName)(Intrinsics.areEqual((Object)string, (Object)Scalars.GraphQLString.getName()) ? TypeNames.STRING : (Intrinsics.areEqual((Object)string, (Object)Scalars.GraphQLInt.getName()) ? TypeNames.INT : (Intrinsics.areEqual((Object)string, (Object)Scalars.GraphQLFloat.getName()) ? TypeNames.DOUBLE : (Intrinsics.areEqual((Object)string, (Object)Scalars.GraphQLBoolean.getName()) ? TypeNames.BOOLEAN : GenerateTypeNameKt.generateCustomClassName(context, (NamedNode)graphQLType, selectionSet)))));
        } else if (type instanceof ListType) {
            TypeName typeName2;
            Type type3 = ((ListType)graphQLType).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"graphQLType.type");
            TypeName type4 = GenerateTypeNameKt.generateTypeName$default(context, type3, selectionSet, false, 8, null);
            if (context.getSerializer() == GraphQLSerializer.KOTLINX && context.isCustomScalar$graphql_kotlin_client_generator(type4)) {
                ScalarConverterInfo scalarConverterInfo = context.getScalarClassToConverterTypeSpecs().get(type4);
                Intrinsics.checkNotNull((Object)scalarConverterInfo, (String)"null cannot be cast to non-null type com.expediagroup.graphql.plugin.client.generator.ScalarConverterInfo.KotlinxSerializerInfo");
                ClassName serializerClassName = ((ScalarConverterInfo.KotlinxSerializerInfo)scalarConverterInfo).component1();
                Object[] objectArray = new Object[]{serializerClassName};
                typeName2 = TypeName.copy$default((TypeName)type4, (boolean)false, (List)CollectionsKt.listOf((Object)AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Serializable.class)).addMember("with = %T::class", objectArray).build()), (int)1, null);
            } else {
                typeName2 = type4;
            }
            TypeName parameterizedType = typeName2;
            TypeName[] typeNameArray = new TypeName[]{parameterizedType};
            typeName = (TypeName)ParameterizedTypeName.Companion.get(TypeNames.LIST, typeNameArray);
        } else {
            throw new UnknownGraphQLTypeException((Node)graphQLType);
        }
        return TypeName.copy$default((TypeName)typeName, (boolean)nullable, null, (int)2, null);
    }

    public static /* synthetic */ TypeName generateTypeName$default(GraphQLClientGeneratorContext graphQLClientGeneratorContext, Type type, SelectionSet selectionSet, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            selectionSet = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return GenerateTypeNameKt.generateTypeName(graphQLClientGeneratorContext, type, selectionSet, bl);
    }

    @NotNull
    public static final ClassName generateCustomClassName(@NotNull GraphQLClientGeneratorContext context, @NotNull NamedNode<?> graphQLType, @Nullable SelectionSet selectionSet) {
        ClassName className2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(graphQLType, (String)"graphQLType");
        Object t = context.getGraphQLSchema().getType(graphQLType.getName()).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"context.graphQLSchema.ge\u2026e(graphQLType.name).get()");
        TypeDefinition graphQLTypeDefinition = (TypeDefinition)t;
        String graphQLTypeName = graphQLTypeDefinition.getName();
        List<ClassName> cachedTypeNames = context.getClassNameCache().get(graphQLTypeName);
        if (cachedTypeNames == null || cachedTypeNames.isEmpty()) {
            if (graphQLTypeDefinition instanceof ScalarTypeDefinition && context.getCustomScalarMap().get(graphQLTypeName) == null) {
                TypeAliasSpec typeAlias = GenerateGraphQLCustomScalarTypeAliasKt.generateGraphQLCustomScalarTypeAlias(context, (ScalarTypeDefinition)graphQLTypeDefinition);
                Object object = new String[]{typeAlias.getName()};
                ClassName className3 = new ClassName(context.getPackageName(), (String[])object);
                object = context.getClassNameCache();
                Intrinsics.checkNotNullExpressionValue((Object)graphQLTypeName, (String)"graphQLTypeName");
                String string = graphQLTypeName;
                Object object2 = new ClassName[]{className3};
                object2 = CollectionsKt.mutableListOf((Object[])object2);
                object.put(string, object2);
                className2 = className3;
            } else {
                ClassName className4 = null;
                TypeDefinition className3 = graphQLTypeDefinition;
                if (className3 instanceof ObjectTypeDefinition) {
                    className4 = GenerateTypeNameKt.generateClassName$default(context, (NamedNode)graphQLTypeDefinition, selectionSet, null, null, 24, null);
                    Map<ClassName, TypeSpec> map = context.getTypeSpecs();
                    ClassName className5 = className4;
                    if (className5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
                        className5 = null;
                    }
                    map.put(className5, GenerateGraphQLObjectTypeSpecKt.generateGraphQLObjectTypeSpec$default(context, (ObjectTypeDefinition)graphQLTypeDefinition, selectionSet, null, 8, null));
                } else if (className3 instanceof InputObjectTypeDefinition) {
                    className4 = GenerateTypeNameKt.generateClassName$default(context, (NamedNode)graphQLTypeDefinition, selectionSet, null, context.getPackageName() + ".inputs", 8, null);
                    Map<ClassName, TypeSpec> map = context.getInputClassToTypeSpecs();
                    ClassName className6 = className4;
                    if (className6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
                        className6 = null;
                    }
                    map.put(className6, GenerateGraphQLInputObjectTypeSpecKt.generateGraphQLInputObjectTypeSpec(context, (InputObjectTypeDefinition)graphQLTypeDefinition));
                } else if (className3 instanceof EnumTypeDefinition) {
                    className4 = GenerateTypeNameKt.generateClassName$default(context, (NamedNode)graphQLTypeDefinition, selectionSet, null, context.getPackageName() + ".enums", 8, null);
                    Map<ClassName, TypeSpec> map = context.getEnumClassToTypeSpecs();
                    ClassName className7 = className4;
                    if (className7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
                        className7 = null;
                    }
                    map.put(className7, GenerateGraphQLEnumTypeSpecKt.generateGraphQLEnumTypeSpec(context, (EnumTypeDefinition)graphQLTypeDefinition));
                } else if (className3 instanceof InterfaceTypeDefinition) {
                    className4 = GenerateTypeNameKt.generateClassName$default(context, (NamedNode)graphQLTypeDefinition, selectionSet, null, null, 24, null);
                    Map<ClassName, List<ClassName>> map = context.getPolymorphicTypes();
                    ClassName className8 = className4;
                    if (className8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
                        className8 = null;
                    }
                    ClassName className9 = className8;
                    Object object = new ClassName[]{className4};
                    object = CollectionsKt.mutableListOf((Object[])object);
                    map.put(className9, (List<ClassName>)object);
                    context.getTypeSpecs().put(className4, GenerateGraphQLInterfaceTypeSpecKt.generateGraphQLInterfaceTypeSpec$default(context, (InterfaceTypeDefinition)graphQLTypeDefinition, selectionSet, null, 8, null));
                } else if (className3 instanceof UnionTypeDefinition) {
                    className4 = GenerateTypeNameKt.generateClassName$default(context, (NamedNode)graphQLTypeDefinition, selectionSet, null, null, 24, null);
                    Map<ClassName, List<ClassName>> map = context.getPolymorphicTypes();
                    ClassName className10 = className4;
                    if (className10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
                        className10 = null;
                    }
                    ClassName className11 = className10;
                    Object object = new ClassName[]{className4};
                    object = CollectionsKt.mutableListOf((Object[])object);
                    map.put(className11, (List<ClassName>)object);
                    context.getTypeSpecs().put(className4, GenerateGraphQLUnionTypeSpecKt.generateGraphQLUnionTypeSpec$default(context, (UnionTypeDefinition)graphQLTypeDefinition, selectionSet, null, 8, null));
                } else if (className3 instanceof ScalarTypeDefinition) {
                    GraphQLScalar graphQLScalar = context.getCustomScalarMap().get(graphQLTypeName);
                    Intrinsics.checkNotNull((Object)graphQLScalar);
                    GraphQLScalar graphQLScalarMapping = graphQLScalar;
                    className4 = graphQLScalarMapping.getClassName();
                    Map<String, List<ClassName>> map = context.getClassNameCache();
                    Intrinsics.checkNotNullExpressionValue((Object)graphQLTypeName, (String)"graphQLTypeName");
                    String string = graphQLTypeName;
                    Object object = new ClassName[1];
                    ClassName className12 = className4;
                    if (className12 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
                        className12 = null;
                    }
                    object[0] = className12;
                    object = CollectionsKt.mutableListOf((Object[])object);
                    map.put(string, (List<ClassName>)object);
                    ScalarConverterInfo converterInfo = GenerateGraphQLCustomScalarConvertersKt.generateGraphQLCustomScalarConverters(context, className4, graphQLScalarMapping.getConverterClassName());
                    context.getScalarClassToConverterTypeSpecs().put(className4, converterInfo);
                } else {
                    throw new UnknownGraphQLTypeException((Node)graphQLType);
                }
                className2 = className4;
            }
        } else if (selectionSet == null) {
            className2 = (ClassName)CollectionsKt.first(cachedTypeNames);
        } else {
            TypeSpec typeSpec;
            for (ClassName cachedType : cachedTypeNames) {
                if (!GenerateTypeNameKt.isCachedTypeApplicable(context, GenerateTypeNameKt.simpleNameWithoutWrapper(cachedType), graphQLTypeDefinition, selectionSet)) continue;
                return cachedType;
            }
            String overriddenName = graphQLTypeName + (cachedTypeNames.size() + 1);
            ClassName className13 = GenerateTypeNameKt.generateClassName$default(context, (NamedNode)graphQLTypeDefinition, selectionSet, overriddenName, null, 16, null);
            TypeDefinition typeDefinition = graphQLTypeDefinition;
            if (typeDefinition instanceof ObjectTypeDefinition) {
                typeSpec = GenerateGraphQLObjectTypeSpecKt.generateGraphQLObjectTypeSpec(context, (ObjectTypeDefinition)graphQLTypeDefinition, selectionSet, overriddenName);
            } else if (typeDefinition instanceof InterfaceTypeDefinition) {
                var10_26 = context.getPolymorphicTypes();
                var11_28 = new ClassName[]{className13};
                var11_28 = CollectionsKt.mutableListOf((Object[])var11_28);
                var10_26.put(className13, (List<ClassName>)var11_28);
                typeSpec = GenerateGraphQLInterfaceTypeSpecKt.generateGraphQLInterfaceTypeSpec(context, (InterfaceTypeDefinition)graphQLTypeDefinition, selectionSet, overriddenName);
            } else if (typeDefinition instanceof UnionTypeDefinition) {
                var10_26 = context.getPolymorphicTypes();
                var11_28 = new ClassName[]{className13};
                var11_28 = CollectionsKt.mutableListOf((Object[])var11_28);
                var10_26.put(className13, (List<ClassName>)var11_28);
                typeSpec = GenerateGraphQLUnionTypeSpecKt.generateGraphQLUnionTypeSpec(context, (UnionTypeDefinition)graphQLTypeDefinition, selectionSet, overriddenName);
            } else {
                throw new UnknownGraphQLTypeException((Node)graphQLType);
            }
            TypeSpec typeSpec2 = typeSpec;
            context.getTypeSpecs().put(className13, typeSpec2);
            className2 = className13;
        }
        return className2;
    }

    public static /* synthetic */ ClassName generateCustomClassName$default(GraphQLClientGeneratorContext graphQLClientGeneratorContext, NamedNode namedNode, SelectionSet selectionSet, int n, Object object) {
        if ((n & 4) != 0) {
            selectionSet = null;
        }
        return GenerateTypeNameKt.generateCustomClassName(graphQLClientGeneratorContext, namedNode, selectionSet);
    }

    @NotNull
    public static final ClassName generateClassName(@NotNull GraphQLClientGeneratorContext context, @NotNull NamedNode<?> graphQLType, @Nullable SelectionSet selectionSet, @Nullable String nameOverride, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(graphQLType, (String)"graphQLType");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String string = nameOverride;
        if (string == null) {
            string = graphQLType.getName();
        }
        String typeName = string;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"typeName");
        stringArray[0] = typeName;
        ClassName className2 = new ClassName(packageName, stringArray);
        Map<String, List<ClassName>> map = context.getClassNameCache();
        String string2 = graphQLType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"graphQLType.name");
        List<ClassName> classNames = map.getOrDefault(string2, new ArrayList());
        classNames.add(className2);
        Map<String, List<ClassName>> map2 = context.getClassNameCache();
        String string3 = graphQLType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"graphQLType.name");
        map2.put(string3, classNames);
        if (selectionSet != null) {
            Set selectedFields = GenerateTypeNameKt.calculateSelectedFields$default(context, typeName, selectionSet, null, 8, null);
            context.getTypeToSelectionSetMap().put(typeName, selectedFields);
        }
        return className2;
    }

    public static /* synthetic */ ClassName generateClassName$default(GraphQLClientGeneratorContext graphQLClientGeneratorContext, NamedNode namedNode, SelectionSet selectionSet, String string, String object, int n, Object object2) {
        if ((n & 4) != 0) {
            selectionSet = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            String string2 = graphQLClientGeneratorContext.getPackageName();
            String string3 = graphQLClientGeneratorContext.getOperationName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            object = string2 + "." + string3;
        }
        return GenerateTypeNameKt.generateClassName(graphQLClientGeneratorContext, namedNode, selectionSet, string, (String)object);
    }

    private static final String simpleNameWithoutWrapper(ClassName $this$simpleNameWithoutWrapper) {
        return StringsKt.substringAfter$default((String)$this$simpleNameWithoutWrapper.getSimpleName(), (String)".", null, (int)2, null);
    }

    private static final boolean isCachedTypeApplicable(GraphQLClientGeneratorContext context, String graphQLTypeName, TypeDefinition<?> graphQLTypeDefinition, SelectionSet selectionSet) {
        TypeDefinition<?> typeDefinition = graphQLTypeDefinition;
        return typeDefinition instanceof UnionTypeDefinition ? GenerateTypeNameKt.verifySelectionSet(context, graphQLTypeName, selectionSet) : (typeDefinition instanceof InterfaceTypeDefinition ? GenerateTypeNameKt.verifySelectionSet(context, graphQLTypeName, selectionSet) : (typeDefinition instanceof ObjectTypeDefinition ? GenerateTypeNameKt.verifySelectionSet(context, graphQLTypeName, selectionSet) : true));
    }

    private static final boolean verifySelectionSet(GraphQLClientGeneratorContext context, String graphQLTypeName, SelectionSet selectionSet) {
        Set selectedFields = GenerateTypeNameKt.calculateSelectedFields$default(context, graphQLTypeName, selectionSet, null, 8, null);
        Set<String> cachedTypeFields = context.getTypeToSelectionSetMap().get(graphQLTypeName);
        return Intrinsics.areEqual((Object)selectedFields, cachedTypeFields);
    }

    private static final Set<String> calculateSelectedFields(GraphQLClientGeneratorContext context, String targetType, SelectionSet selectionSet, String path) {
        Set result = new LinkedHashSet();
        List list = selectionSet.getSelections();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"selectionSet.selections");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Selection selection = (Selection)element$iv;
            boolean bl = false;
            Selection selection2 = selection;
            if (selection2 instanceof Field) {
                result.add(path + ((Field)selection).getName());
                if (((Field)selection).getSelectionSet() == null) continue;
                SelectionSet selectionSet2 = ((Field)selection).getSelectionSet();
                Intrinsics.checkNotNullExpressionValue((Object)selectionSet2, (String)"selection.selectionSet");
                result.addAll((Collection)GenerateTypeNameKt.calculateSelectedFields(context, targetType, selectionSet2, path + ((Field)selection).getName() + "."));
                continue;
            }
            if (selection2 instanceof InlineFragment) {
                String targetFragmentType = ((InlineFragment)selection).getTypeCondition().getName();
                String fragmentPathPrefix = Intrinsics.areEqual((Object)targetFragmentType, (Object)targetType) ? path : path + targetFragmentType + ".";
                SelectionSet selectionSet3 = ((InlineFragment)selection).getSelectionSet();
                Intrinsics.checkNotNullExpressionValue((Object)selectionSet3, (String)"selection.selectionSet");
                result.addAll((Collection)GenerateTypeNameKt.calculateSelectedFields(context, targetType, selectionSet3, fragmentPathPrefix));
                continue;
            }
            if (!(selection2 instanceof FragmentSpread)) continue;
            Document document = context.getQueryDocument();
            String string = ((FragmentSpread)selection).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.name");
            FragmentDefinition fragmentDefinition = DocumentExtensionsKt.findFragmentDefinition(document, context, string, targetType);
            String targetFragmentType = fragmentDefinition.getTypeCondition().getName();
            String fragmentPathPrefix = Intrinsics.areEqual((Object)targetFragmentType, (Object)targetType) ? path : path + targetFragmentType + ".";
            SelectionSet selectionSet4 = fragmentDefinition.getSelectionSet();
            Intrinsics.checkNotNullExpressionValue((Object)selectionSet4, (String)"fragmentDefinition.selectionSet");
            result.addAll((Collection)GenerateTypeNameKt.calculateSelectedFields(context, targetType, selectionSet4, fragmentPathPrefix));
        }
        return result;
    }

    static /* synthetic */ Set calculateSelectedFields$default(GraphQLClientGeneratorContext graphQLClientGeneratorContext, String string, SelectionSet selectionSet, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        return GenerateTypeNameKt.calculateSelectedFields(graphQLClientGeneratorContext, string, selectionSet, string2);
    }
}

