/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.client.generator.types;

import com.expediagroup.graphql.client.Generated;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorContext;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorKt;
import com.expediagroup.graphql.plugin.client.generator.GraphQLSerializer;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLInputObjectTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GeneratePropertySpecsKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateTypeNameKt;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import graphql.language.Type;
import graphql.language.VariableDefinition;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a8\u0006\u0007"}, d2={"generateVariableTypeSpec", "Lcom/squareup/kotlinpoet/TypeSpec;", "context", "Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorContext;", "variableDefinitions", "", "Lgraphql/language/VariableDefinition;", "graphql-kotlin-client-generator"})
public final class GenerateVariableTypeSpecKt {
    @Nullable
    public static final TypeSpec generateVariableTypeSpec(@NotNull GraphQLClientGeneratorContext context, @NotNull List<? extends VariableDefinition> variableDefinitions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(variableDefinitions, (String)"variableDefinitions");
        String variablesTypeName = "Variables";
        KModifier[] kModifierArray = new KModifier[]{KModifier.DATA};
        TypeSpec.Builder variableTypeSpec = TypeSpec.Companion.classBuilder(variablesTypeName).addModifiers(kModifierArray).addAnnotation(Reflection.getOrCreateKotlinClass(Generated.class));
        if (context.getSerializer() == GraphQLSerializer.KOTLINX) {
            variableTypeSpec.addAnnotation(Reflection.getOrCreateKotlinClass(Serializable.class));
        }
        FunSpec.Builder constructorSpec = FunSpec.Companion.constructorBuilder();
        Iterable $this$forEach$iv = variableDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariableDefinition variableDef = (VariableDefinition)element$iv;
            boolean bl = false;
            Pair<TypeName, Boolean> pair = variableDef.getType();
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"variableDef.type");
            TypeName kotlinTypeName = GenerateTypeNameKt.generateTypeName$default(context, (Type)pair, null, 4, null);
            pair = GeneratePropertySpecsKt.unwrapRawType(kotlinTypeName);
            TypeName rawType = (TypeName)pair.component1();
            boolean isList = (Boolean)pair.component2();
            boolean isCustomScalar = context.isCustomScalar$graphql_kotlin_client_generator(rawType);
            boolean shouldWrapInOptional = GenerateGraphQLInputObjectTypeSpecKt.shouldWrapInOptional(kotlinTypeName, context);
            TypeName variableTypeName = !isCustomScalar && shouldWrapInOptional ? GenerateGraphQLInputObjectTypeSpecKt.wrapOptionalInputType(kotlinTypeName, context) : kotlinTypeName;
            String string = variableDef.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variableDef.name");
            PropertySpec.Builder builder = PropertySpec.Companion.builder(string, variableTypeName, new KModifier[0]);
            string = variableDef.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variableDef.name");
            string = builder.initializer(string, new Object[0]);
            boolean bl2 = false;
            boolean bl3 = false;
            String builder2 = string;
            boolean bl4 = false;
            if (isCustomScalar) {
                builder2.addAnnotations((Iterable)GeneratePropertySpecsKt.generateCustomScalarPropertyAnnotations(context, rawType, isList));
                if (shouldWrapInOptional) {
                    GraphQLClientGeneratorKt.getLOGGER().warn("Operation " + context.getOperationName() + " specifies optional custom scalar as input - " + variableDef.getName() + " in Variables. Currently custom scalars do not work with optional wrappers.");
                    builder2.addKdoc("NOTE: This field was not wrapped in optional as currently custom scalars do not work with optional wrappers.", new Object[0]);
                }
            }
            PropertySpec variable = string.build();
            variableTypeSpec.addProperty(variable);
            string = ParameterSpec.Companion.builder(variable.getName(), variable.getType(), new KModifier[0]);
            bl2 = false;
            bl3 = false;
            builder2 = string;
            FunSpec.Builder builder3 = constructorSpec;
            boolean bl5 = false;
            if (kotlinTypeName.isNullable()) {
                builder2.defaultValue(GenerateGraphQLInputObjectTypeSpecKt.nullableDefaultValueCodeBlock(context, isCustomScalar));
            }
            Unit unit = Unit.INSTANCE;
            builder3.addParameter(string.build());
        }
        variableTypeSpec.primaryConstructor(constructorSpec.build());
        return variableTypeSpec.getPropertySpecs().isEmpty() ? (TypeSpec)null : variableTypeSpec.build();
    }
}

