/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.client.generator.types;

import com.expediagroup.graphql.client.Generated;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorContext;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorKt;
import com.expediagroup.graphql.plugin.client.generator.GraphQLSerializer;
import com.expediagroup.graphql.plugin.client.generator.types.GeneratePropertySpecsKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateTypeNameKt;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import graphql.language.Description;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.Type;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\r\u001a\u00020\f*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u000e"}, d2={"generateGraphQLInputObjectTypeSpec", "Lcom/squareup/kotlinpoet/TypeSpec;", "context", "Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorContext;", "inputObjectDefinition", "Lgraphql/language/InputObjectTypeDefinition;", "nullableDefaultValueCodeBlock", "Lcom/squareup/kotlinpoet/CodeBlock;", "isCustomScalar", "", "shouldWrapInOptional", "type", "Lcom/squareup/kotlinpoet/TypeName;", "wrapOptionalInputType", "graphql-kotlin-client-generator"})
public final class GenerateGraphQLInputObjectTypeSpecKt {
    @NotNull
    public static final TypeSpec generateGraphQLInputObjectTypeSpec(@NotNull GraphQLClientGeneratorContext context, @NotNull InputObjectTypeDefinition inputObjectDefinition) {
        Object[] objectArray;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inputObjectDefinition, (String)"inputObjectDefinition");
        String inputTypeName = inputObjectDefinition.getName();
        Intrinsics.checkNotNullExpressionValue((Object)inputTypeName, (String)"inputTypeName");
        Description description = new Description[]{KModifier.DATA};
        TypeSpec.Builder inputObjectTypeSpecBuilder = TypeSpec.Companion.classBuilder(inputTypeName).addModifiers((KModifier[])description).addAnnotation(Reflection.getOrCreateKotlinClass(Generated.class));
        description = inputObjectDefinition.getDescription();
        if (description != null && (object = description.content) != null) {
            String string = object;
            boolean bl = false;
            boolean bl2 = false;
            String kdoc = string;
            boolean bl3 = false;
            objectArray = new Object[]{kdoc};
            inputObjectTypeSpecBuilder.addKdoc("%L", objectArray);
        }
        if (context.getSerializer() == GraphQLSerializer.KOTLINX) {
            inputObjectTypeSpecBuilder.addAnnotation(Reflection.getOrCreateKotlinClass(Serializable.class));
        }
        FunSpec.Builder constructorBuilder = FunSpec.Companion.constructorBuilder();
        object = inputObjectDefinition.getInputValueDefinitions();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputObjectDefinition.inputValueDefinitions");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            InputValueDefinition fieldDefinition = (InputValueDefinition)element$iv;
            boolean bl = false;
            objectArray = fieldDefinition.getType();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"fieldDefinition.type");
            TypeName kotlinFieldTypeName = GenerateTypeNameKt.generateTypeName$default(context, (Type)objectArray, null, 4, null);
            objectArray = GeneratePropertySpecsKt.unwrapRawType(kotlinFieldTypeName);
            TypeName rawType = (TypeName)objectArray.component1();
            boolean isList = (Boolean)objectArray.component2();
            boolean isCustomScalar = context.isCustomScalar$graphql_kotlin_client_generator(rawType);
            boolean shouldWrapInOptional = GenerateGraphQLInputObjectTypeSpecKt.shouldWrapInOptional(kotlinFieldTypeName, context);
            TypeName inputFieldType = !isCustomScalar && shouldWrapInOptional ? GenerateGraphQLInputObjectTypeSpecKt.wrapOptionalInputType(kotlinFieldTypeName, context) : kotlinFieldTypeName;
            String string2 = fieldDefinition.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fieldDefinition.name");
            PropertySpec.Builder builder = PropertySpec.Companion.builder(string2, inputFieldType, new KModifier[0]);
            string2 = fieldDefinition.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fieldDefinition.name");
            string2 = builder.initializer(string2, new Object[0]);
            boolean bl4 = false;
            boolean bl5 = false;
            String builder2 = string2;
            boolean bl6 = false;
            Description description2 = fieldDefinition.getDescription();
            if (description2 != null && (string = description2.content) != null) {
                String string3 = string;
                boolean bl7 = false;
                boolean bl8 = false;
                String kdoc = string3;
                boolean bl9 = false;
                Object[] objectArray2 = new Object[]{kdoc};
                builder2.addKdoc("%L", objectArray2);
            }
            if (isCustomScalar) {
                builder2.addAnnotations((Iterable)GeneratePropertySpecsKt.generateCustomScalarPropertyAnnotations(context, rawType, isList));
                if (shouldWrapInOptional) {
                    GraphQLClientGeneratorKt.getLOGGER().warn("Operation " + context.getOperationName() + " specifies optional custom scalar as input - " + fieldDefinition.getName() + " in Variables. Currently custom scalars do not work with optional wrappers.");
                    builder2.addKdoc("\nNOTE: This field was not wrapped in optional as currently custom scalars do not work with optional wrappers.", new Object[0]);
                }
            }
            PropertySpec inputPropertySpec = string2.build();
            inputObjectTypeSpecBuilder.addProperty(inputPropertySpec);
            string2 = ParameterSpec.Companion.builder(inputPropertySpec.getName(), inputPropertySpec.getType(), new KModifier[0]);
            bl4 = false;
            bl5 = false;
            builder2 = string2;
            FunSpec.Builder builder3 = constructorBuilder;
            boolean bl10 = false;
            if (kotlinFieldTypeName.isNullable()) {
                builder2.defaultValue(GenerateGraphQLInputObjectTypeSpecKt.nullableDefaultValueCodeBlock(context, isCustomScalar));
            }
            Unit unit = Unit.INSTANCE;
            builder3.addParameter(string2.build());
        }
        inputObjectTypeSpecBuilder.primaryConstructor(constructorBuilder.build());
        return inputObjectTypeSpecBuilder.build();
    }

    public static final boolean shouldWrapInOptional(@NotNull TypeName type, @NotNull GraphQLClientGeneratorContext context) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return type.isNullable() && context.getUseOptionalInputWrapper();
    }

    @NotNull
    public static final TypeName wrapOptionalInputType(@NotNull TypeName $this$wrapOptionalInputType, @NotNull GraphQLClientGeneratorContext context) {
        TypeName typeName;
        Intrinsics.checkNotNullParameter((Object)$this$wrapOptionalInputType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getSerializer() == GraphQLSerializer.JACKSON) {
            String[] stringArray = new String[]{"OptionalInput"};
            ClassName className2 = new ClassName("com.expediagroup.graphql.client.jackson.types", stringArray);
            stringArray = new TypeName[]{TypeName.copy$default((TypeName)$this$wrapOptionalInputType, (boolean)false, null, (int)2, null)};
            typeName = (TypeName)ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray);
        } else {
            String[] stringArray = new String[]{"OptionalInput"};
            ClassName className3 = new ClassName("com.expediagroup.graphql.client.serialization.types", stringArray);
            stringArray = new TypeName[]{TypeName.copy$default((TypeName)$this$wrapOptionalInputType, (boolean)false, null, (int)2, null)};
            typeName = (TypeName)ParameterizedTypeName.Companion.get(className3, (TypeName[])stringArray);
        }
        return typeName;
    }

    @NotNull
    public static final CodeBlock nullableDefaultValueCodeBlock(@NotNull GraphQLClientGeneratorContext context, boolean isCustomScalar) {
        CodeBlock codeBlock;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getUseOptionalInputWrapper() && !isCustomScalar) {
            if (context.getSerializer() == GraphQLSerializer.JACKSON) {
                Object[] objectArray = new Object[]{new MemberName("com.expediagroup.graphql.client.jackson.types", "OptionalInput.Undefined")};
                codeBlock = CodeBlock.Companion.of("%M", objectArray);
            } else {
                Object[] objectArray = new Object[]{new MemberName("com.expediagroup.graphql.client.serialization.types", "OptionalInput.Undefined")};
                codeBlock = CodeBlock.Companion.of("%M", objectArray);
            }
        } else {
            codeBlock = CodeBlock.Companion.of("null", new Object[0]);
        }
        return codeBlock;
    }
}

