/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.client.generator;

import com.expediagroup.graphql.client.Generated;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorConfig;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorContext;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorKt;
import com.expediagroup.graphql.plugin.client.generator.GraphQLSerializer;
import com.expediagroup.graphql.plugin.client.generator.ScalarConverterInfo;
import com.expediagroup.graphql.plugin.client.generator.exceptions.MultipleOperationsInFileException;
import com.expediagroup.graphql.plugin.client.generator.exceptions.SchemaUnavailableException;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLObjectTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateVariableTypeSpecKt;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeAliasSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import graphql.language.Document;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.VariableDefinition;
import graphql.parser.Parser;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.Required;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eJ\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGenerator;", "", "schemaPath", "", "config", "Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorConfig;", "(Ljava/lang/String;Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorConfig;)V", "documentParser", "Lgraphql/parser/Parser;", "graphQLSchema", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "sharedTypes", "", "Lcom/squareup/kotlinpoet/ClassName;", "", "Lcom/squareup/kotlinpoet/TypeSpec;", "typeAliases", "Lcom/squareup/kotlinpoet/TypeAliasSpec;", "findRootType", "Lgraphql/language/ObjectTypeDefinition;", "operationDefinition", "Lgraphql/language/OperationDefinition;", "generate", "Lcom/squareup/kotlinpoet/FileSpec;", "queryFile", "Ljava/io/File;", "generate$graphql_kotlin_client_generator", "queries", "parseSchema", "path", "graphql-kotlin-client-generator"})
public final class GraphQLClientGenerator {
    @NotNull
    private final GraphQLClientGeneratorConfig config;
    @NotNull
    private final Parser documentParser;
    @NotNull
    private final Map<String, TypeAliasSpec> typeAliases;
    @NotNull
    private final Map<ClassName, List<TypeSpec>> sharedTypes;
    @NotNull
    private final TypeDefinitionRegistry graphQLSchema;

    public GraphQLClientGenerator(@NotNull String schemaPath, @NotNull GraphQLClientGeneratorConfig config) {
        Intrinsics.checkNotNullParameter((Object)schemaPath, (String)"schemaPath");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.documentParser = new Parser();
        boolean bl = false;
        this.typeAliases = new LinkedHashMap();
        bl = false;
        this.sharedTypes = new LinkedHashMap();
        this.graphQLSchema = this.parseSchema(schemaPath);
    }

    @NotNull
    public final List<FileSpec> generate(@NotNull List<? extends File> queries) {
        Object object;
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        boolean bl = false;
        List result = new ArrayList();
        for (File file : queries) {
            result.addAll((Collection)this.generate$graphql_kotlin_client_generator(file));
        }
        Map<ClassName, List<TypeSpec>> map = this.sharedTypes;
        boolean bl2 = false;
        for (Map.Entry entry : map.entrySet()) {
            object = entry;
            boolean bl3 = false;
            ClassName className2 = (ClassName)object.getKey();
            Map.Entry entry2 = entry;
            boolean bl4 = false;
            List typeSpecs = (List)entry2.getValue();
            FileSpec.Builder fileSpec = FileSpec.Companion.builder(className2.getPackageName(), className2.getSimpleName());
            for (TypeSpec type : typeSpecs) {
                fileSpec.addType(type);
            }
            result.add(fileSpec.build());
        }
        Map<String, TypeAliasSpec> object2 = this.typeAliases;
        boolean bl5 = false;
        if (!object2.isEmpty()) {
            FileSpec.Builder typeAliasSpec = FileSpec.Companion.builder(this.config.getPackageName(), "GraphQLTypeAliases");
            Map<String, TypeAliasSpec> map2 = this.typeAliases;
            boolean $i$f$forEach = false;
            object = map2;
            boolean bl6 = false;
            Iterator<Object> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$_u24__u24$alias = element$iv = (Map.Entry)iterator.next();
                boolean bl62 = false;
                Map.Entry entry = $dstr$_u24__u24$alias;
                boolean bl7 = false;
                TypeAliasSpec alias = (TypeAliasSpec)entry.getValue();
                typeAliasSpec.addTypeAlias(alias);
            }
            result.add(typeAliasSpec.build());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FileSpec> generate$graphql_kotlin_client_generator(@NotNull File queryFile) {
        Intrinsics.checkNotNullParameter((Object)queryFile, (String)"queryFile");
        String string = FilesKt.readText$default((File)queryFile, null, (int)1, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String queryConst = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Document queryDocument = this.documentParser.parseDocument(queryConst);
        List list = queryDocument.getDefinitions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryDocument.definitions");
        List operationDefinitions = CollectionsKt.filterIsInstance((Iterable)list, OperationDefinition.class);
        if (operationDefinitions.size() > 1) {
            throw new MultipleOperationsInFileException(queryFile);
        }
        boolean bl2 = false;
        List fileSpecs = new ArrayList();
        FileSpec.Builder operationFileSpec = FileSpec.Companion.builder(this.config.getPackageName(), GraphQLClientGeneratorKt.capitalizeFirstChar(FilesKt.getNameWithoutExtension((File)queryFile)));
        Iterable $this$forEach$iv = operationDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list2;
            Map.Entry it;
            Map map;
            Object k;
            Map<ClassName, TypeSpec> $this$mapValuesTo$iv$iv;
            Object $this$mapValues$iv;
            TypeSpec typeSpec;
            Object object;
            Object[] variablesProperty;
            boolean bl3;
            Object it2;
            TypeSpec.Builder builder;
            String[] stringArray;
            Object object2;
            Object[] operationNameProperty;
            Object[] objectArray;
            Object[] objectArray2;
            OperationDefinition operationDefinition = (OperationDefinition)element$iv;
            boolean bl4 = false;
            String string3 = operationDefinition.getName();
            String capitalizedOperationName = string3 == null ? GraphQLClientGeneratorKt.capitalizeFirstChar(FilesKt.getNameWithoutExtension((File)queryFile)) : GraphQLClientGeneratorKt.capitalizeFirstChar(string3);
            String string4 = this.config.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)queryDocument, (String)"queryDocument");
            GraphQLClientGeneratorContext context = new GraphQLClientGeneratorContext(string4, this.graphQLSchema, capitalizedOperationName, queryDocument, this.config.getAllowDeprecated(), this.config.getCustomScalarMap(), this.config.getSerializer(), this.config.getUseOptionalInputWrapper());
            String queryConstName = GraphQLClientGeneratorKt.toUpperUnderscore(capitalizedOperationName);
            Object[] objectArray3 = new KModifier[]{KModifier.CONST};
            PropertySpec.Builder builder2 = PropertySpec.Companion.builder(queryConstName, (TypeName)TypeNames.STRING, new KModifier[0]).addModifiers((KModifier[])objectArray3);
            objectArray3 = new Object[]{queryConst};
            PropertySpec queryConstProp = builder2.initializer("%S", objectArray3).build();
            operationFileSpec.addProperty(queryConstProp);
            ObjectTypeDefinition rootType = this.findRootType(operationDefinition);
            TypeSpec graphQLResponseTypeSpec = GenerateGraphQLObjectTypeSpecKt.generateGraphQLObjectTypeSpec(context, rootType, operationDefinition.getSelectionSet(), "Result");
            String[] stringArray2 = new String[]{context.getOperationName() + '.' + graphQLResponseTypeSpec.getName()};
            ClassName kotlinResultTypeName = new ClassName(context.getPackageName(), stringArray2);
            String[] stringArray3 = new String[]{"GraphQLClientRequest"};
            ClassName className2 = new ClassName("com.expediagroup.graphql.client.types", stringArray3);
            stringArray3 = new TypeName[]{(TypeName)kotlinResultTypeName};
            TypeSpec.Builder operationTypeSpec = TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Companion.classBuilder(capitalizedOperationName).addAnnotation(Reflection.getOrCreateKotlinClass(Generated.class)), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray3)), null, (int)2, null);
            Object[] objectArray4 = new KModifier[]{KModifier.OVERRIDE};
            PropertySpec.Builder builder3 = PropertySpec.Companion.builder("query", (TypeName)TypeNames.STRING, (KModifier[])objectArray4);
            objectArray4 = new Object[]{queryConstProp};
            PropertySpec queryProperty = builder3.initializer("%N", objectArray4).build();
            if (operationDefinition.getName() != null) {
                objectArray2 = new PropertySpec[]{KModifier.OVERRIDE};
                PropertySpec.Builder builder4 = PropertySpec.Companion.builder("operationName", (TypeName)TypeNames.STRING, (KModifier[])objectArray2);
                objectArray2 = new Object[]{operationDefinition.getName()};
                objectArray = builder4.initializer("%S", objectArray2).build();
            } else {
                objectArray = operationNameProperty = (Object[])null;
            }
            if (this.config.getSerializer() == GraphQLSerializer.KOTLINX) {
                operationTypeSpec.addAnnotation(Reflection.getOrCreateKotlinClass(Serializable.class));
                queryProperty = PropertySpec.toBuilder$default((PropertySpec)queryProperty, null, null, (int)3, null).addAnnotation(Reflection.getOrCreateKotlinClass(Required.class)).build();
                objectArray2 = operationNameProperty;
                operationNameProperty = objectArray2 == null ? null : ((object2 = PropertySpec.toBuilder$default((PropertySpec)objectArray2, null, null, (int)3, null)) == null ? null : ((stringArray = object2.addAnnotation(Reflection.getOrCreateKotlinClass(Required.class))) == null ? null : stringArray.build()));
            }
            operationTypeSpec.addProperty(queryProperty);
            objectArray2 = operationNameProperty;
            if (objectArray2 == null) {
                builder = null;
            } else {
                object2 = objectArray2;
                boolean bl5 = false;
                boolean bl6 = false;
                it2 = object2;
                bl3 = false;
                builder = operationTypeSpec.addProperty((PropertySpec)it2);
            }
            object2 = operationDefinition.getVariableDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"operationDefinition.variableDefinitions");
            TypeSpec variableType = GenerateVariableTypeSpecKt.generateVariableTypeSpec(context, (List<? extends VariableDefinition>)object2);
            if (variableType != null) {
                operationTypeSpec.addType(variableType);
                stringArray = new String[]{Intrinsics.stringPlus((String)capitalizedOperationName, (Object)".Variables")};
                ClassName variablesClassName = new ClassName(this.config.getPackageName(), stringArray);
                KModifier[] kModifierArray = new KModifier[]{KModifier.OVERRIDE};
                variablesProperty = PropertySpec.Companion.builder("variables", (TypeName)variablesClassName, kModifierArray).initializer("variables", new Object[0]).build();
                operationTypeSpec.addProperty((PropertySpec)variablesProperty);
                it2 = new KModifier[]{KModifier.OVERRIDE};
                FunSpec constructor22 = FunSpec.Companion.constructorBuilder().addParameter("variables", (TypeName)variablesClassName, (KModifier[])it2).build();
                operationTypeSpec.primaryConstructor(constructor22);
            }
            variablesProperty = new String[]{"KClass"};
            ClassName className3 = new ClassName("kotlin.reflect", (String[])variablesProperty);
            variablesProperty = new TypeName[]{(TypeName)kotlinResultTypeName};
            ParameterizedTypeName parameterizedReturnType = ParameterizedTypeName.Companion.get(className3, (TypeName[])variablesProperty);
            variablesProperty = new KModifier[]{KModifier.OVERRIDE};
            FunSpec.Builder builder5 = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("responseType").addModifiers((KModifier[])variablesProperty), (TypeName)((TypeName)parameterizedReturnType), null, (int)2, null);
            variablesProperty = new Object[]{kotlinResultTypeName};
            operationTypeSpec.addFunction(builder5.addStatement("return %T::class", variablesProperty).build());
            operationTypeSpec.addType(graphQLResponseTypeSpec);
            boolean constructor22 = false;
            List polymorphicTypes = new ArrayList();
            it2 = context.getPolymorphicTypes();
            bl3 = false;
            Iterator constructor22 = it2.entrySet().iterator();
            while (constructor22.hasNext()) {
                Object object3 = it2 = constructor22.next();
                boolean bl7 = false;
                ClassName superClassName = (ClassName)object3.getKey();
                Object object4 = it2;
                boolean bl8 = false;
                List implementations = (List)object4.getValue();
                polymorphicTypes.add(superClassName);
                FileSpec.Builder polymorphicTypeSpec = FileSpec.Companion.builder(superClassName.getPackageName(), superClassName.getSimpleName());
                for (ClassName implementation : implementations) {
                    FileSpec.Builder builder6;
                    polymorphicTypes.add(implementation);
                    object = context.getTypeSpecs().get(implementation);
                    if (object == null) {
                        builder6 = null;
                        continue;
                    }
                    typeSpec = object;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    TypeSpec typeSpec2 = typeSpec;
                    boolean bl11 = false;
                    builder6 = polymorphicTypeSpec.addType(typeSpec2);
                }
                fileSpecs.add(polymorphicTypeSpec.build());
            }
            Map<ClassName, TypeSpec> $this$forEach$iv2 = MapsKt.minus(context.getTypeSpecs(), (Iterable)polymorphicTypes);
            boolean $i$f$forEach2 = false;
            Map<ClassName, TypeSpec> superClassName = $this$forEach$iv2;
            boolean implementations = false;
            Iterator polymorphicTypeSpec = superClassName.entrySet().iterator();
            while (polymorphicTypeSpec.hasNext()) {
                TypeSpec element$iv2;
                TypeSpec $dstr$className$typeSpec = element$iv2 = polymorphicTypeSpec.next();
                boolean bl12 = false;
                typeSpec = $dstr$className$typeSpec;
                boolean bl13 = false;
                ClassName className4 = (ClassName)typeSpec.getKey();
                TypeSpec typeSpec3 = $dstr$className$typeSpec;
                boolean typeSpec2 = false;
                TypeSpec typeSpec4 = (TypeSpec)typeSpec3.getValue();
                FileSpec outputTypeFileSpec = FileSpec.Companion.builder(className4.getPackageName(), className4.getSimpleName()).addType(typeSpec4).build();
                fileSpecs.add(outputTypeFileSpec);
            }
            operationFileSpec.addType(operationTypeSpec.build());
            fileSpecs.add(operationFileSpec.build());
            $this$forEach$iv2 = context.getEnumClassToTypeSpecs();
            Map<ClassName, List<TypeSpec>> map2 = this.sharedTypes;
            boolean $i$f$mapValues = false;
            superClassName = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry outputTypeFileSpec = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl14 = false;
                Object k2 = it$iv$iv.getKey();
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map = map3;
                boolean bl15 = false;
                list2 = CollectionsKt.listOf(it.getValue());
                map.put(k, list2);
            }
            map = destination$iv$iv;
            map2.putAll(map);
            $this$mapValues$iv = context.getInputClassToTypeSpecs();
            map2 = this.sharedTypes;
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry it$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl16 = false;
                Object k3 = it$iv$iv.getKey();
                it = (Map.Entry)element$iv$iv$iv;
                k = k3;
                map = map4;
                boolean bl17 = false;
                list2 = CollectionsKt.listOf(it.getValue());
                map.put(k, list2);
            }
            map = destination$iv$iv;
            map2.putAll(map);
            $this$mapValues$iv = context.getScalarClassToConverterTypeSpecs().values();
            $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                boolean bl18;
                List list3;
                Object element$iv3 = iterator.next();
                ScalarConverterInfo it3 = (ScalarConverterInfo)element$iv3;
                boolean bl19 = false;
                ScalarConverterInfo scalarConverterInfo = it3;
                if (scalarConverterInfo instanceof ScalarConverterInfo.JacksonConvertersInfo) {
                    object = this.sharedTypes;
                    typeSpec = ((ScalarConverterInfo.JacksonConvertersInfo)it3).getSerializerClassName();
                    list3 = CollectionsKt.listOf((Object)((ScalarConverterInfo.JacksonConvertersInfo)it3).getSerializerTypeSpec());
                    bl18 = false;
                    object.put(typeSpec, list3);
                    object = this.sharedTypes;
                    typeSpec = ((ScalarConverterInfo.JacksonConvertersInfo)it3).getDeserializerClassName();
                    list3 = CollectionsKt.listOf((Object)((ScalarConverterInfo.JacksonConvertersInfo)it3).getDeserializerTypeSpec());
                    bl18 = false;
                    object.put(typeSpec, list3);
                    continue;
                }
                if (!(scalarConverterInfo instanceof ScalarConverterInfo.KotlinxSerializerInfo)) continue;
                object = this.sharedTypes;
                typeSpec = ((ScalarConverterInfo.KotlinxSerializerInfo)it3).getSerializerClassName();
                list3 = CollectionsKt.listOf((Object)((ScalarConverterInfo.KotlinxSerializerInfo)it3).getSerializerTypeSpec());
                bl18 = false;
                object.put(typeSpec, list3);
            }
            this.typeAliases.putAll(context.getTypeAliases());
        }
        return fileSpecs;
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectTypeDefinition findRootType(OperationDefinition operationDefinition) {
        Map map;
        Object $this$associateBy$iv;
        if (this.graphQLSchema.schemaDefinition().isPresent()) {
            void $this$associateByTo$iv$iv;
            List list = ((SchemaDefinition)this.graphQLSchema.schemaDefinition().get()).getOperationTypeDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"graphQLSchema.schemaDefi\u2026.operationTypeDefinitions");
            $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Object object = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                OperationTypeDefinition it;
                OperationTypeDefinition operationTypeDefinition = (OperationTypeDefinition)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                boolean bl2 = false;
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
                String string3 = string2;
                it = (OperationTypeDefinition)element$iv$iv;
                boolean bl3 = false;
                String string4 = it.getTypeName().getName();
                map2.put(string3, string4);
            }
            map = destination$iv$iv;
        } else {
            $this$associateBy$iv = new Pair[]{TuplesKt.to((Object)OperationDefinition.Operation.QUERY.name(), (Object)"Query"), TuplesKt.to((Object)OperationDefinition.Operation.MUTATION.name(), (Object)"Mutation"), TuplesKt.to((Object)OperationDefinition.Operation.SUBSCRIPTION.name(), (Object)"Subscription")};
            map = MapsKt.mapOf((Pair[])$this$associateBy$iv);
        }
        Map operationNames = map;
        String rootType = (String)operationNames.get(operationDefinition.getOperation().name());
        return (ObjectTypeDefinition)this.graphQLSchema.getType(rootType).get();
    }

    private final TypeDefinitionRegistry parseSchema(String path) {
        TypeDefinitionRegistry typeDefinitionRegistry;
        File schemaFile = new File(path);
        if (schemaFile.isFile()) {
            TypeDefinitionRegistry typeDefinitionRegistry2 = new SchemaParser().parse(schemaFile);
            Intrinsics.checkNotNullExpressionValue((Object)typeDefinitionRegistry2, (String)"{\n            SchemaPars\u2026rse(schemaFile)\n        }");
            typeDefinitionRegistry = typeDefinitionRegistry2;
        } else {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
            if (inputStream == null) {
                throw new SchemaUnavailableException(path);
            }
            InputStream schemaInputStream = inputStream;
            TypeDefinitionRegistry typeDefinitionRegistry3 = new SchemaParser().parse(schemaInputStream);
            Intrinsics.checkNotNullExpressionValue((Object)typeDefinitionRegistry3, (String)"{\n            val schema\u2026emaInputStream)\n        }");
            typeDefinitionRegistry = typeDefinitionRegistry3;
        }
        return typeDefinitionRegistry;
    }
}

