/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.client.generator;

import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorConfig;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorContext;
import com.expediagroup.graphql.plugin.client.generator.GraphQLClientGeneratorKt;
import com.expediagroup.graphql.plugin.client.generator.GraphQLSerializer;
import com.expediagroup.graphql.plugin.client.generator.exceptions.MultipleOperationsInFileException;
import com.expediagroup.graphql.plugin.client.generator.exceptions.SchemaUnavailableException;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateGraphQLObjectTypeSpecKt;
import com.expediagroup.graphql.plugin.client.generator.types.GenerateVariableTypeSpecKt;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeAliasSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import graphql.language.Document;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.parser.Parser;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eJ\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGenerator;", "", "schemaPath", "", "config", "Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorConfig;", "(Ljava/lang/String;Lcom/expediagroup/graphql/plugin/client/generator/GraphQLClientGeneratorConfig;)V", "documentParser", "Lgraphql/parser/Parser;", "graphQLSchema", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "sharedTypes", "", "Lcom/squareup/kotlinpoet/ClassName;", "", "Lcom/squareup/kotlinpoet/TypeSpec;", "typeAliases", "Lcom/squareup/kotlinpoet/TypeAliasSpec;", "findRootType", "Lgraphql/language/ObjectTypeDefinition;", "operationDefinition", "Lgraphql/language/OperationDefinition;", "generate", "Lcom/squareup/kotlinpoet/FileSpec;", "queryFile", "Ljava/io/File;", "generate$graphql_kotlin_client_generator", "queries", "parseSchema", "path", "graphql-kotlin-client-generator"})
public final class GraphQLClientGenerator {
    private final Parser documentParser;
    private final Map<String, TypeAliasSpec> typeAliases;
    private final Map<ClassName, List<TypeSpec>> sharedTypes;
    private final TypeDefinitionRegistry graphQLSchema;
    private final GraphQLClientGeneratorConfig config;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FileSpec> generate(@NotNull List<? extends File> queries) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        boolean bl = false;
        List result = new ArrayList();
        for (File file : queries) {
            result.addAll((Collection)this.generate$graphql_kotlin_client_generator(file));
        }
        ClassName className = this.sharedTypes;
        boolean bl2 = false;
        Iterator<Object> bl4 = className.entrySet().iterator();
        while (bl4.hasNext()) {
            void className2;
            Map.Entry entry;
            Map.Entry bl5 = entry = (Map.Entry)bl4.next();
            boolean bl3 = false;
            className = (ClassName)bl5.getKey();
            bl5 = entry;
            bl3 = false;
            List typeSpecs = (List)bl5.getValue();
            FileSpec.Builder fileSpec = FileSpec.Companion.builder(className2.getPackageName(), className2.getSimpleName());
            for (TypeSpec type : typeSpecs) {
                fileSpec.addType(type);
            }
            result.add(fileSpec.build());
        }
        Map<String, TypeAliasSpec> map = this.typeAliases;
        boolean bl5 = false;
        if (!map.isEmpty()) {
            FileSpec.Builder builder = FileSpec.Companion.builder(this.config.getPackageName(), "GraphQLTypeAliases");
            Map<String, TypeAliasSpec> $this$forEach$iv = this.typeAliases;
            boolean $i$f$forEach = false;
            Map<String, TypeAliasSpec> map2 = $this$forEach$iv;
            boolean bl6 = false;
            Iterator<Map.Entry<String, TypeAliasSpec>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, TypeAliasSpec> element$iv;
                Map.Entry<String, TypeAliasSpec> $dstr$_u24__u24$alias = element$iv = iterator.next();
                boolean bl62 = false;
                Map.Entry<String, TypeAliasSpec> entry = $dstr$_u24__u24$alias;
                boolean bl7 = false;
                TypeAliasSpec alias = entry.getValue();
                builder.addTypeAlias(alias);
            }
            result.add(builder.build());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FileSpec> generate$graphql_kotlin_client_generator(@NotNull File queryFile) {
        Document queryDocument;
        Intrinsics.checkNotNullParameter((Object)queryFile, (String)"queryFile");
        String string = FilesKt.readText$default((File)queryFile, null, (int)1, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String queryConst = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Document document = queryDocument = this.documentParser.parseDocument(queryConst);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"queryDocument");
        List list = document.getDefinitions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryDocument.definitions");
        List operationDefinitions = CollectionsKt.filterIsInstance((Iterable)list, OperationDefinition.class);
        if (operationDefinitions.size() > 1) {
            throw (Throwable)MultipleOperationsInFileException.INSTANCE;
        }
        boolean bl2 = false;
        List fileSpecs = new ArrayList();
        FileSpec.Builder operationFileSpec = FileSpec.Companion.builder(this.config.getPackageName(), StringsKt.capitalize((String)FilesKt.getNameWithoutExtension((File)queryFile)));
        Iterable $this$forEach$iv = operationDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list2;
            Map.Entry it;
            Map map;
            Object k;
            Object k2;
            Map map2;
            Map<ClassName, TypeSpec> $this$mapValuesTo$iv$iv;
            Map<ClassName, TypeSpec> $this$mapValues$iv;
            ClassName typeSpec;
            Iterator iterator;
            boolean bl3;
            FileSpec.Builder polymorphicTypeSpec;
            Map<ClassName, TypeSpec> superClassName;
            OperationDefinition operationDefinition = (OperationDefinition)element$iv;
            boolean bl4 = false;
            String string3 = operationDefinition.getName();
            if (string3 == null || (string3 = StringsKt.capitalize((String)string3)) == null) {
                string3 = StringsKt.capitalize((String)FilesKt.getNameWithoutExtension((File)queryFile));
            }
            String operationTypeName = string3;
            GraphQLClientGeneratorContext context = new GraphQLClientGeneratorContext(this.config.getPackageName(), this.graphQLSchema, operationTypeName, queryDocument, this.config.getAllowDeprecated(), this.config.getCustomScalarMap(), this.config.getSerializer());
            String queryConstName = GraphQLClientGeneratorKt.toUpperUnderscore(operationTypeName);
            PropertySpec queryConstProp = PropertySpec.Companion.builder(queryConstName, (TypeName)TypeNames.STRING, new KModifier[0]).addModifiers(new KModifier[]{KModifier.CONST}).initializer("%S", new Object[]{queryConst}).build();
            operationFileSpec.addProperty(queryConstProp);
            ObjectTypeDefinition rootType = this.findRootType(operationDefinition);
            TypeSpec graphQLResponseTypeSpec = GenerateGraphQLObjectTypeSpecKt.generateGraphQLObjectTypeSpec(context, rootType, operationDefinition.getSelectionSet(), "Result");
            ClassName kotlinResultTypeName = new ClassName(context.getPackageName(), new String[]{context.getRootType() + '.' + graphQLResponseTypeSpec.getName()});
            PropertySpec queryProperty = PropertySpec.Companion.builder("query", (TypeName)TypeNames.STRING, new KModifier[]{KModifier.OVERRIDE}).initializer("%N", new Object[]{queryConstProp}).build();
            TypeSpec.Builder operationTypeSpec = TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Companion.classBuilder(operationTypeName), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(new ClassName("com.expediagroup.graphql.client.types", new String[]{"GraphQLClientRequest"}), new TypeName[]{(TypeName)kotlinResultTypeName})), null, (int)2, null).addProperty(queryProperty);
            if (this.config.getSerializer() == GraphQLSerializer.KOTLINX) {
                operationTypeSpec.addAnnotation(Reflection.getOrCreateKotlinClass(Serializable.class));
            }
            if (operationDefinition.getName() != null) {
                PropertySpec operationNameProperty = PropertySpec.Companion.builder("operationName", (TypeName)TypeNames.STRING, new KModifier[]{KModifier.OVERRIDE}).initializer("%S", new Object[]{operationDefinition.getName()}).build();
                operationTypeSpec.addProperty(operationNameProperty);
            }
            List list3 = operationDefinition.getVariableDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"operationDefinition.variableDefinitions");
            TypeSpec variableType = GenerateVariableTypeSpecKt.generateVariableTypeSpec(context, list3);
            if (variableType != null) {
                operationTypeSpec.addType(variableType);
                ClassName variablesClassName = new ClassName(this.config.getPackageName(), new String[]{operationTypeName + ".Variables"});
                PropertySpec variablesProperty = PropertySpec.Companion.builder("variables", (TypeName)variablesClassName, new KModifier[]{KModifier.OVERRIDE}).initializer("variables", new Object[0]).build();
                operationTypeSpec.addProperty(variablesProperty);
                FunSpec constructor = FunSpec.Companion.constructorBuilder().addParameter("variables", (TypeName)variablesClassName, new KModifier[]{KModifier.OVERRIDE}).build();
                operationTypeSpec.primaryConstructor(constructor);
            }
            ParameterizedTypeName parameterizedReturnType = ParameterizedTypeName.Companion.get(new ClassName("kotlin.reflect", new String[]{"KClass"}), new TypeName[]{(TypeName)kotlinResultTypeName});
            operationTypeSpec.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("responseType").addModifiers(new KModifier[]{KModifier.OVERRIDE}), (TypeName)((TypeName)parameterizedReturnType), null, (int)2, null).addStatement("return %T::class", new Object[]{kotlinResultTypeName}).build());
            operationTypeSpec.addType(graphQLResponseTypeSpec);
            boolean constructor = false;
            List polymorphicTypes = new ArrayList();
            ClassName className = context.getPolymorphicTypes();
            boolean bl5 = false;
            Iterator<Map.Entry<ClassName, List<ClassName>>> iterator2 = className.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<ClassName, List<ClassName>> entry = constructor = iterator2.next();
                boolean bl6 = false;
                className = entry.getKey();
                entry = constructor;
                bl6 = false;
                List<ClassName> implementations = entry.getValue();
                polymorphicTypes.add(superClassName);
                polymorphicTypeSpec = FileSpec.Companion.builder(superClassName.getPackageName(), superClassName.getSimpleName());
                for (ClassName implementation : implementations) {
                    FileSpec.Builder builder;
                    polymorphicTypes.add(implementation);
                    if (context.getTypeSpecs().get(implementation) != null) {
                        boolean bl7 = false;
                        bl3 = false;
                        typeSpec = iterator;
                        boolean bl8 = false;
                        builder = polymorphicTypeSpec.addType((TypeSpec)typeSpec);
                        continue;
                    }
                    builder = null;
                }
                fileSpecs.add(polymorphicTypeSpec.build());
            }
            Map<ClassName, TypeSpec> $this$forEach$iv2 = MapsKt.minus(context.getTypeSpecs(), (Iterable)polymorphicTypes);
            boolean $i$f$forEach2 = false;
            superClassName = $this$forEach$iv2;
            boolean implementations = false;
            polymorphicTypeSpec = superClassName.entrySet().iterator();
            while (polymorphicTypeSpec.hasNext()) {
                void className2;
                Map.Entry element$iv2;
                Map.Entry $dstr$className$typeSpec = element$iv2 = polymorphicTypeSpec.next();
                boolean bl9 = false;
                Map.Entry entry = $dstr$className$typeSpec;
                bl3 = false;
                typeSpec = (ClassName)entry.getKey();
                entry = $dstr$className$typeSpec;
                bl3 = false;
                TypeSpec typeSpec2 = (TypeSpec)entry.getValue();
                FileSpec outputTypeFileSpec = FileSpec.Companion.builder(className2.getPackageName(), className2.getSimpleName()).addType(typeSpec2).build();
                fileSpecs.add(outputTypeFileSpec);
            }
            operationFileSpec.addType(operationTypeSpec.build());
            fileSpecs.add(operationFileSpec.build());
            $this$forEach$iv2 = context.getEnumClassToTypeSpecs();
            Map<ClassName, List<TypeSpec>> map3 = this.sharedTypes;
            boolean $i$f$mapValues = false;
            superClassName = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                boolean bl10 = false;
                k2 = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map = map2;
                boolean bl11 = false;
                list2 = CollectionsKt.listOf(it.getValue());
                map.put(k, list2);
            }
            map = destination$iv$iv;
            map3.putAll(map);
            $this$mapValues$iv = context.getInputClassToTypeSpecs();
            map3 = this.sharedTypes;
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            iterator = $this$associateByTo$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv$iv = iterator.next();
                Map.Entry it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                boolean bl12 = false;
                k2 = it$iv$iv.getKey();
                it = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map = map2;
                boolean bl13 = false;
                list2 = CollectionsKt.listOf(it.getValue());
                map.put(k, list2);
            }
            map = destination$iv$iv;
            map3.putAll(map);
            this.sharedTypes.putAll(context.getScalarsClassToTypeSpec());
            this.typeAliases.putAll(context.getTypeAliases());
        }
        return fileSpecs;
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectTypeDefinition findRootType(OperationDefinition operationDefinition) {
        Map map;
        Optional optional = this.graphQLSchema.schemaDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"graphQLSchema.schemaDefinition()");
        if (optional.isPresent()) {
            void $this$associateByTo$iv$iv;
            Object t = this.graphQLSchema.schemaDefinition().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"graphQLSchema.schemaDefinition().get()");
            List list = ((SchemaDefinition)t).getOperationTypeDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"graphQLSchema.schemaDefi\u2026.operationTypeDefinitions");
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                String string;
                OperationTypeDefinition it;
                OperationTypeDefinition operationTypeDefinition = (OperationTypeDefinition)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                void v3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)v3.getName(), (String)"it.name");
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                String string4 = string3;
                it = (OperationTypeDefinition)element$iv$iv;
                boolean bl3 = false;
                OperationTypeDefinition operationTypeDefinition2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)operationTypeDefinition2, (String)"it");
                graphql.language.TypeName typeName = operationTypeDefinition2.getTypeName();
                Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"it.typeName");
                String string5 = typeName.getName();
                map2.put(string4, string5);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)OperationDefinition.Operation.QUERY.name(), (Object)"Query"), TuplesKt.to((Object)OperationDefinition.Operation.MUTATION.name(), (Object)"Mutation"), TuplesKt.to((Object)OperationDefinition.Operation.SUBSCRIPTION.name(), (Object)"Subscription")});
        }
        Map operationNames = map;
        String rootType = (String)operationNames.get(operationDefinition.getOperation().name());
        Object t = this.graphQLSchema.getType(rootType).get();
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.language.ObjectTypeDefinition");
        }
        return (ObjectTypeDefinition)t;
    }

    private final TypeDefinitionRegistry parseSchema(String path) {
        TypeDefinitionRegistry typeDefinitionRegistry;
        File schemaFile = new File(path);
        if (schemaFile.isFile()) {
            TypeDefinitionRegistry typeDefinitionRegistry2 = new SchemaParser().parse(schemaFile);
            typeDefinitionRegistry = typeDefinitionRegistry2;
            Intrinsics.checkNotNullExpressionValue((Object)typeDefinitionRegistry2, (String)"SchemaParser().parse(schemaFile)");
        } else {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
            if (inputStream == null) {
                throw (Throwable)new SchemaUnavailableException(path);
            }
            InputStream schemaInputStream = inputStream;
            TypeDefinitionRegistry typeDefinitionRegistry3 = new SchemaParser().parse(schemaInputStream);
            typeDefinitionRegistry = typeDefinitionRegistry3;
            Intrinsics.checkNotNullExpressionValue((Object)typeDefinitionRegistry3, (String)"SchemaParser().parse(schemaInputStream)");
        }
        return typeDefinitionRegistry;
    }

    public GraphQLClientGenerator(@NotNull String schemaPath, @NotNull GraphQLClientGeneratorConfig config) {
        Intrinsics.checkNotNullParameter((Object)schemaPath, (String)"schemaPath");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.documentParser = new Parser();
        boolean bl = false;
        this.typeAliases = new LinkedHashMap();
        bl = false;
        this.sharedTypes = new LinkedHashMap();
        this.graphQLSchema = this.parseSchema(schemaPath);
    }
}

