/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler.plugins;

import com.expedia.tesla.compiler.plugins.JavaTypeDescriptor;
import com.expedia.tesla.schema.Array;
import com.expedia.tesla.schema.EnumEntry;
import com.expedia.tesla.schema.Field;
import com.expedia.tesla.schema.Primitive;
import com.expedia.tesla.schema.Reference;
import com.expedia.tesla.schema.Schema;
import com.expedia.tesla.schema.TeslaSchemaException;
import com.expedia.tesla.schema.UserType;
import com.expedia.tesla.schema.annotation.DisplayName;
import com.expedia.tesla.schema.annotation.FieldName;
import com.expedia.tesla.schema.annotation.NotNullable;
import com.expedia.tesla.schema.annotation.Nullable;
import com.expedia.tesla.schema.annotation.SkipField;
import com.expedia.tesla.schema.annotation.TypeId;
import java.beans.PropertyDescriptor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;

public class JavaTypeMapper {
    private static final Map<Primitive, JavaTypeDescriptor> PRIM_DESCRIPTORS = new HashMap<Primitive, JavaTypeDescriptor>();
    private static final Map<String, Class<?>> BOXES = new TreeMap();
    private static final Map<String, Primitive> PRIM_INDEX = new TreeMap<String, Primitive>();
    private boolean mapToJavaArray = false;
    private static final Pmap[] PRIM_MAPS;

    public boolean isMapToJavaArray() {
        return this.mapToJavaArray;
    }

    public void setMapToJavaArray(boolean mapToJavaArray) {
        this.mapToJavaArray = mapToJavaArray;
    }

    public JavaTypeDescriptor getTypeDescriptor(com.expedia.tesla.schema.Type t) throws TeslaSchemaException {
        if (t.isPrimitive()) {
            JavaTypeDescriptor td = PRIM_DESCRIPTORS.get(t);
            assert (td != null) : "BUG! missing a primitive type mapping '" + t.getTypeId() + "'";
            return td;
        }
        if (t.isNullable()) {
            com.expedia.tesla.schema.Nullable nt = (com.expedia.tesla.schema.Nullable)t;
            com.expedia.tesla.schema.Type e = nt.getElementType();
            JavaTypeDescriptor etd = this.getTypeDescriptor(e);
            return new JavaTypeDescriptor(t, this.symbol(t), this.box(etd.getInterfaceName()), this.box(etd.getActualTypeName()));
        }
        if (t.isArray()) {
            Array a = (Array)t;
            com.expedia.tesla.schema.Type e = a.getElementType();
            JavaTypeDescriptor etd = this.getTypeDescriptor(e);
            String containerInfo = a.getExtraTypeId();
            if (containerInfo == null || containerInfo.isEmpty()) {
                if (!this.mapToJavaArray) {
                    containerInfo = "java.util.List,java.util.ArrayList";
                } else {
                    return new JavaTypeDescriptor(t, this.symbol(t), etd.getInterfaceName() + "[]", etd.getInterfaceName() + "[]");
                }
            }
            String[] tokens = containerInfo.split(",");
            String interfaceName = null;
            String actualTypeName = null;
            if (tokens.length == 1) {
                interfaceName = actualTypeName = tokens[0];
            } else if (tokens.length == 2) {
                interfaceName = tokens[0];
                actualTypeName = tokens[1];
            } else {
                throw new TeslaSchemaException(String.format("Can't find type mapping for type '%s'.", t.getTypeId()));
            }
            interfaceName = String.format(interfaceName + "<%s>", this.box(etd.getInterfaceName()));
            actualTypeName = String.format(actualTypeName + "<%s>", this.box(etd.getInterfaceName()));
            return new JavaTypeDescriptor(t, this.symbol(t), interfaceName, actualTypeName);
        }
        if (t.isMap()) {
            com.expedia.tesla.schema.Map m = (com.expedia.tesla.schema.Map)t;
            com.expedia.tesla.schema.Type keyType = m.getKeyType();
            com.expedia.tesla.schema.Type valueType = m.getValueType();
            JavaTypeDescriptor ktd = this.getTypeDescriptor(keyType);
            JavaTypeDescriptor vtd = this.getTypeDescriptor(valueType);
            String extraTypeId = m.getExtraTypeId();
            String mi = "java.util.Map<%s, %s>";
            String mt = "java.util.HashMap<%s, %s>";
            if (extraTypeId != null && !extraTypeId.isEmpty()) {
                String[] tokens = extraTypeId.split(",");
                if (tokens.length == 1) {
                    mt = mi = tokens[0] + "<%s,%s>";
                } else if (tokens.length == 2) {
                    mi = tokens[0] + "<%s,%s>";
                    mt = tokens[1] + "<%s,%s>";
                } else {
                    throw new TeslaSchemaException(String.format("Unable to find type mapping for '%s'", t.getTypeId()));
                }
            }
            mi = String.format(mi, this.box(ktd.getInterfaceName()), this.box(vtd.getInterfaceName()));
            mt = String.format(mt, this.box(ktd.getInterfaceName()), this.box(vtd.getInterfaceName()));
            return new JavaTypeDescriptor(t, this.symbol(t), mi, mt);
        }
        if (t.isUserType()) {
            String name = ((UserType)t).getName();
            return new JavaTypeDescriptor(t, this.symbol(t), name, name);
        }
        if (t.isPoly()) {
            return new JavaTypeDescriptor(t, this.symbol(t), "java.lang.Object", "java.lang.Object");
        }
        if (t.isReference()) {
            JavaTypeDescriptor etd = this.getTypeDescriptor(((Reference)t).getElementType());
            return new JavaTypeDescriptor(t, this.symbol(t), this.box(etd.getInterfaceName()), this.box(etd.getActualTypeName()));
        }
        throw new TeslaSchemaException(String.format("unknown type '%s'", t));
    }

    public String symbol(com.expedia.tesla.schema.Type t) {
        return "_" + t.getTypeId().replaceAll("\\.|<|>|,|\\[|\\]", "_");
    }

    public String box(String t) {
        if (BOXES.containsKey(t)) {
            return BOXES.get(t).getCanonicalName();
        }
        return t;
    }

    public com.expedia.tesla.schema.Type fromJavaClass(Schema.SchemaBuilder schemaBuilder, Class<?> javaType) throws TeslaSchemaException {
        String className = javaType.getCanonicalName();
        if (className == null) {
            throw new TeslaSchemaException(String.format("Tesla cannot generate schema for local class '%s'.", javaType.getName()));
        }
        String classTypeId = com.expedia.tesla.schema.Class.nameToId((String)className);
        com.expedia.tesla.schema.Class clss = (com.expedia.tesla.schema.Class)schemaBuilder.findType(classTypeId);
        if (clss != null) {
            return clss;
        }
        clss = (com.expedia.tesla.schema.Class)schemaBuilder.addType(classTypeId);
        com.expedia.tesla.schema.Class superClass = null;
        Class<?> base = javaType.getSuperclass();
        if (base != null && base != Object.class) {
            superClass = (com.expedia.tesla.schema.Class)this.fromJavaClass(schemaBuilder, javaType.getSuperclass());
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (PropertyDescriptor propDesc : PropertyUtils.getPropertyDescriptors(javaType)) {
            com.expedia.tesla.schema.Type fieldType = null;
            String fieldName = propDesc.getName();
            Method readMethod = propDesc.getReadMethod();
            Method writeMethod = propDesc.getWriteMethod();
            if (writeMethod == null || readMethod == null || superClass != null && superClass.hasField(fieldName) || clss.hasField(fieldName) || readMethod.getAnnotation(SkipField.class) != null) continue;
            TypeId tidAnnotation = readMethod.getAnnotation(TypeId.class);
            String typeId = null;
            if (tidAnnotation != null) {
                typeId = tidAnnotation.value();
            }
            if (typeId != null) {
                fieldType = schemaBuilder.addType(typeId);
            } else {
                Type propType = readMethod.getGenericReturnType();
                fieldType = this.fromJava(schemaBuilder, propType);
                if (!(propType instanceof Class) || !((Class)propType).isPrimitive()) {
                    fieldType = schemaBuilder.addType(String.format("nullable<%s>", fieldType.getTypeId()));
                }
                NotNullable anntNotNullable = readMethod.getAnnotation(NotNullable.class);
                Nullable anntNullable = readMethod.getAnnotation(Nullable.class);
                if (anntNotNullable != null && anntNullable != null) {
                    throw new TeslaSchemaException(String.format("Property '%' of class '%s' has conflict annotations.'NotNullable' and 'Nullable'", fieldName));
                }
                if (fieldType.isNullable() && anntNotNullable != null) {
                    fieldType = ((com.expedia.tesla.schema.Nullable)fieldType).getElementType();
                }
                if (!fieldType.isReference() && readMethod.getAnnotation(com.expedia.tesla.schema.annotation.Reference.class) != null) {
                    fieldType = schemaBuilder.addType(String.format("reference<%s>", fieldType.getTypeId()));
                }
            }
            FieldName fnAnnotation = readMethod.getAnnotation(FieldName.class);
            if (fnAnnotation != null) {
                fieldName = fnAnnotation.value();
            }
            String fieldDisplayName = propDesc.getDisplayName();
            String getter = readMethod.getName();
            String setter = propDesc.getWriteMethod().getName();
            DisplayName dnAnnotation = readMethod.getAnnotation(DisplayName.class);
            if (dnAnnotation != null) {
                fieldDisplayName = dnAnnotation.value();
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("getter", getter);
            attributes.put("setter", setter);
            fields.add(new Field(fieldName, fieldDisplayName, fieldType, attributes, null));
        }
        clss.define(superClass == null ? null : Arrays.asList(superClass), fields, null);
        return clss;
    }

    private com.expedia.tesla.schema.Type fromJavaEnum(Schema.SchemaBuilder schemaBuilder, Class<?> t) throws TeslaSchemaException {
        if (!t.isEnum()) {
            throw new TeslaSchemaException("Not an enum type.");
        }
        com.expedia.tesla.schema.Enum enm = (com.expedia.tesla.schema.Enum)schemaBuilder.addType(com.expedia.tesla.schema.Enum.nameToId((String)t.getCanonicalName()));
        ArrayList<EnumEntry> entries = new ArrayList<EnumEntry>();
        for (Object v : t.getEnumConstants()) {
            Enum e = (Enum)v;
            if (enm.hasEntry(e.name())) continue;
            entries.add(new EnumEntry(e.name(), e.ordinal(), null));
        }
        enm.define(entries, null);
        return enm;
    }

    private com.expedia.tesla.schema.Type fromJavaForward(Schema.SchemaBuilder schemaBuilder, Class<?> jt) throws TeslaSchemaException {
        if (PRIM_INDEX.containsKey(jt.getCanonicalName())) {
            Primitive p = PRIM_INDEX.get(jt.getCanonicalName());
            return schemaBuilder.addType(p.getTypeId());
        }
        if (jt.isEnum()) {
            return this.fromJavaEnum(schemaBuilder, jt);
        }
        if (jt.isArray()) {
            com.expedia.tesla.schema.Type elementType = this.fromJava(schemaBuilder, jt.getComponentType());
            String tid = String.format("array<%s>", elementType.getTypeId());
            return schemaBuilder.addType(tid);
        }
        return this.fromJavaClass(schemaBuilder, jt);
    }

    private com.expedia.tesla.schema.Type fromJava(Schema.SchemaBuilder schemaBuilder, Type jt) throws TeslaSchemaException {
        if (jt instanceof Class) {
            return this.fromJavaForward(schemaBuilder, (Class)jt);
        }
        if (jt instanceof WildcardType) {
            WildcardType wt = (WildcardType)jt;
            return this.fromJava(schemaBuilder, wt.getUpperBounds()[0]);
        }
        if (jt instanceof GenericArrayType) {
            GenericArrayType ga = (GenericArrayType)jt;
            com.expedia.tesla.schema.Type elementType = this.fromJava(schemaBuilder, ga.getGenericComponentType());
            return schemaBuilder.addType(String.format("array<%s>", elementType.getTypeId()));
        }
        if (jt instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)jt;
            return this.fromJava(schemaBuilder, tv.getBounds()[0]);
        }
        if (jt instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)jt;
            Class rt = (Class)pt.getRawType();
            if (Map.class.isAssignableFrom(rt)) {
                Type kt = pt.getActualTypeArguments()[0];
                Type vt = pt.getActualTypeArguments()[1];
                com.expedia.tesla.schema.Type keyType = this.fromJava(schemaBuilder, kt);
                com.expedia.tesla.schema.Type valueType = this.fromJava(schemaBuilder, vt);
                String fs = null;
                Class rawType = (Class)pt.getRawType();
                fs = rawType.isInterface() ? "map<%s,%s>" : "map[" + rawType.getCanonicalName() + "]<%s,%s>";
                String tid = String.format(fs, keyType.getTypeId(), valueType.getTypeId());
                return schemaBuilder.addType(tid);
            }
            if (Collection.class.isAssignableFrom(rt)) {
                Type et = pt.getActualTypeArguments()[0];
                com.expedia.tesla.schema.Type elementType = this.fromJava(schemaBuilder, et);
                String fs = null;
                Class rawType = (Class)pt.getRawType();
                if (rawType.isInterface()) {
                    fs = "array[java.util.Collection,java.util.ArrayList]<%s>";
                    if (List.class.isAssignableFrom(rt)) {
                        fs = "array[java.util.List,java.util.ArrayList]<%s>";
                    } else if (Set.class.isAssignableFrom(rt)) {
                        fs = "array[java.util.Set,java.util.HashSet]<%s>";
                    }
                } else {
                    fs = "array[" + rawType.getCanonicalName() + "]<%s>";
                }
                String tid = String.format(fs, elementType.getTypeId());
                return schemaBuilder.addType(tid);
            }
            return this.fromJavaForward(schemaBuilder, rt);
        }
        throw new TeslaSchemaException("BUG");
    }

    static {
        for (Pmap pm : PRIM_MAPS = new Pmap[]{new Pmap(Primitive.BYTE, Byte.TYPE, Byte.class), new Pmap(Primitive.UINT16, Short.TYPE, Short.class), new Pmap(Primitive.UINT32, Integer.TYPE, Integer.class), new Pmap(Primitive.UINT64, Long.TYPE, Long.class), new Pmap(Primitive.INT16, Short.TYPE, Short.class), new Pmap(Primitive.INT32, Integer.TYPE, Integer.class), new Pmap(Primitive.INT64, Long.TYPE, Long.class), new Pmap(Primitive.BOOLEAN, Boolean.TYPE, Boolean.class), new Pmap(Primitive.FLOAT, Float.TYPE, Float.class), new Pmap(Primitive.DOUBLE, Double.TYPE, Double.class), new Pmap(Primitive.STRING, String.class, String.class), new Pmap(Primitive.BINARY, byte[].class, byte[].class)}) {
            PRIM_DESCRIPTORS.put(pm.primtive, new JavaTypeDescriptor((com.expedia.tesla.schema.Type)pm.primtive, "_" + pm.primtive.getName(), pm.unboxed.getCanonicalName(), pm.unboxed.getCanonicalName()));
            PRIM_INDEX.put(pm.unboxed.getCanonicalName(), pm.primtive);
            PRIM_INDEX.put(pm.boxed.getCanonicalName(), pm.primtive);
            BOXES.put(pm.unboxed.getCanonicalName(), pm.boxed);
        }
    }

    private static class Pmap {
        Primitive primtive;
        Class<?> unboxed;
        Class<?> boxed;

        Pmap(Primitive primtive, Class<?> unboxed, Class<?> boxed) {
            this.primtive = primtive;
            this.unboxed = unboxed;
            this.boxed = boxed;
        }
    }
}

