/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler.plugins;

import com.expedia.tesla.compiler.Util;
import com.expedia.tesla.schema.Array;
import com.expedia.tesla.schema.Enum;
import com.expedia.tesla.schema.Field;
import com.expedia.tesla.schema.Nullable;
import com.expedia.tesla.schema.Primitive;
import com.expedia.tesla.schema.Reference;
import com.expedia.tesla.schema.Type;
import com.expedia.tesla.schema.UserType;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;

public class CSharpUtils
extends Util {
    private static Map<String, String> typeMap = new TreeMap<String, String>();

    private String getCSharpFieldTypeName(Field field) {
        Type type = field.getType();
        return this.getTypeName(type);
    }

    private String getTypeName(Type type) {
        if (type.isPrimitive()) {
            return typeMap.get(((Primitive)type).getName());
        }
        if (type.isUserType()) {
            return ((UserType)type).getName();
        }
        if (type.isArray()) {
            return this.getTypeName(((Array)type).getElementType());
        }
        if (type.isNullable()) {
            return this.getTypeName(((Nullable)type).getElementType());
        }
        if (type.isReference()) {
            return this.getTypeName(((Reference)type).getElementType());
        }
        throw new RuntimeException("Unable to map type " + type.getTypeId());
    }

    public String getCSharpTypeName(Field field) {
        String elementType = this.getCSharpFieldTypeName(field);
        return this.getCSharpListType(elementType, field.getRank());
    }

    public String getCSharpListType(String typeName, int rank) {
        if (rank < 1) {
            return typeName;
        }
        if (rank == 1) {
            return String.format("List<%s>", typeName);
        }
        return String.format("List<%s>", this.getCSharpListType(typeName, rank - 1));
    }

    public String getWriteMethod(Field field) {
        return this.getReadWriteMethod(field, "Write");
    }

    public String getReadMethod(Field field) {
        return this.getReadWriteMethod(field, "Read");
    }

    private String getReadWriteMethod(Field field, String rw) {
        if (field.getRank() == 0) {
            if (field.getType() instanceof Enum) {
                return String.format("%s<%s>", rw, this.getCSharpFieldTypeName(field));
            }
            return rw;
        }
        if (field.getType() instanceof Primitive) {
            return String.format("%s%sArray", rw, ((Primitive)field.getType()).getName());
        }
        if (field.getType() instanceof Enum) {
            return String.format("%sEnum<%s>", rw, this.getCSharpFieldTypeName(field));
        }
        return String.format("%sObjectArray<%s>", rw, this.getCSharpFieldTypeName(field));
    }

    public String escapeStringLiteral(String str) {
        return '\"' + StringEscapeUtils.escapeJava((String)str) + '\"';
    }

    static {
        typeMap.put(Primitive.BYTE.getName(), "byte");
        typeMap.put(Primitive.INT16.getName(), "short");
        typeMap.put(Primitive.INT32.getName(), "int");
        typeMap.put(Primitive.INT64.getName(), "long");
        typeMap.put(Primitive.UINT16.getName(), "ushort");
        typeMap.put(Primitive.UINT32.getName(), "uint");
        typeMap.put(Primitive.UINT64.getName(), "ulong");
        typeMap.put(Primitive.BOOLEAN.getName(), "bool");
        typeMap.put(Primitive.FLOAT.getName(), "float");
        typeMap.put(Primitive.DOUBLE.getName(), "double");
        typeMap.put(Primitive.STRING.getName(), "string");
        typeMap.put(Primitive.BINARY.getName(), "byte[]");
    }
}

