/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler;

import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class TemplateEngine {
    private String language;
    private String templatePath;
    private String defaultTemplate;

    public TemplateEngine(String language, String templatePath, String defaultTemplate) {
        this.language = language;
        this.templatePath = templatePath;
        this.defaultTemplate = defaultTemplate;
    }

    public void merge(Map<String, Object> variables, Writer writer) {
        this.createTemplate(this.language, this.templatePath, this.defaultTemplate).merge((Context)this.createContext(variables), writer);
    }

    protected Template createTemplate(String language, String templatePath, String defaultTemplate) {
        String defaultResourcePath = "resources/" + this.language + "/" + defaultTemplate;
        if (templatePath == null || templatePath.isEmpty()) {
            templatePath = defaultResourcePath;
        }
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"file, classpath");
        ve.setProperty("file.resource.loader.path", (Object)"");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        try {
            return ve.getTemplate(templatePath);
        }
        catch (ResourceNotFoundException ex) {
            if (templatePath != defaultResourcePath) {
                return ve.getTemplate(defaultResourcePath);
            }
            throw ex;
        }
    }

    protected VelocityContext createContext(Map<String, Object> variables) {
        VelocityContext context = new VelocityContext();
        if (variables != null) {
            for (Map.Entry<String, Object> var : variables.entrySet()) {
                context.put(var.getKey(), var.getValue());
            }
        }
        return context;
    }
}

