/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.expedia.tesla.SchemaVersion;
import com.expedia.tesla.compiler.Util;
import com.expedia.tesla.compiler.plugins.JavaTypeMapper;
import com.expedia.tesla.schema.Schema;
import com.expedia.tesla.schema.TeslaSchemaException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;

public class SchemaGenerator {
    public static void genTml(Collection<String> classes, SchemaVersion schemaVersion, OutputStream output, String classpath) throws IOException, TeslaSchemaException, ClassNotFoundException, JAXBException {
        JavaTypeMapper mapper = new JavaTypeMapper();
        Schema.SchemaBuilder schemaBuilder = new Schema.SchemaBuilder();
        schemaBuilder.setVersion(schemaVersion);
        for (String name : classes) {
            Class<?> clzz = Util.loadClass(name, classpath);
            mapper.fromJavaClass(schemaBuilder, clzz);
        }
        schemaBuilder.build().save(output);
    }

    public static void main(String[] args) throws Exception {
        JCommander jc = null;
        try {
            CommandLineParameters p = new CommandLineParameters();
            jc = new JCommander((Object)p);
            jc.parse(args);
            if (p.help) {
                jc.usage();
                return;
            }
            File file = new File((String)p.outputFiles.get(0));
            Util.forceMkdirParent(file);
            try (FileOutputStream os = new FileOutputStream(file);){
                SchemaGenerator.genTml(p.rootClasses, p.schemaVersion, os, p.classpath);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Could not find class '%s'.", e.getMessage()), e);
            }
        }
        catch (Exception e) {
            System.err.printf("Error: %s\nUse -h or --help option to show usage help.\n", e.getMessage());
            System.exit(1);
        }
    }

    public static class SchemaVersionConverter
    implements IStringConverter<SchemaVersion> {
        public SchemaVersion convert(String value) {
            String[] values;
            String name = null;
            int number = -1;
            block8: for (String v : values = value.split(",")) {
                String[] p = v.split("=");
                if (p.length != 2) {
                    throw new ParameterException("Invalid schema version: '" + value + "'");
                }
                p[0] = p[0].trim();
                p[1] = p[1].trim();
                switch (p[0].toLowerCase()) {
                    case "name": {
                        name = p[1];
                        continue block8;
                    }
                    case "number": {
                        number = number;
                        continue block8;
                    }
                    default: {
                        throw new ParameterException("Invalid schema version: '" + value + "'");
                    }
                }
            }
            if (name == null) {
                throw new ParameterException("Invalid schema version: '" + value + "', must provide a version name.");
            }
            return new SchemaVersion(0L, number, name, null);
        }
    }

    private static class CommandLineParameters {
        @Parameter(description="Output TML file path", required=true)
        private List<String> outputFiles = new ArrayList<String>();
        @Parameter(names={"-rc", "--root-class"}, description="Generate schema (TML file) from the user class definition by java reflection. The compiler will load the class by name and generate Tesla fields for all public properties by default. Please use -classpath option to specify the search path for your class, or put them in JVM classpath.", required=true)
        private List<String> rootClasses;
        @Parameter(names={"-cp", "-classpath"}, description="Java classpath that compiler will search for user classes.")
        private String classpath;
        @Parameter(names={"-ver", "--schema-version"}, description="Specify a schema version name and (or) version number for the generated schema. Version name is required while version number is option. For more information about Tesla schema version, please refer Tesla documentation or specification. Sample: -ver name=Abc Service v2.5.1,number=6", required=true, converter=SchemaVersionConverter.class)
        private SchemaVersion schemaVersion;
        @Parameter(names={"-h", "--help"}, description="Show this help message.", help=true)
        private boolean help;

        private CommandLineParameters() {
        }
    }
}

