/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler;

import com.expedia.tesla.compiler.MergedClass;
import com.expedia.tesla.compiler.MergedEnum;
import com.expedia.tesla.schema.Schema;
import com.expedia.tesla.schema.TeslaSchemaException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class MergedSchema {
    private List<Schema> schemas = new ArrayList<Schema>();
    private List<MergedClass> classes;
    private List<MergedEnum> enums;

    public MergedSchema(Collection<Schema> schemas) throws TeslaSchemaException {
        this.checkVersions(schemas);
        this.schemas.addAll(schemas);
        this.merge();
    }

    private void merge() throws TeslaSchemaException {
        this.classes = MergedClass.merge(this.schemas);
        this.enums = MergedEnum.merge(this.schemas);
    }

    private void checkVersions(Collection<Schema> schemas) throws TeslaSchemaException {
        TreeSet<String> versionNames = new TreeSet<String>();
        for (Schema schema : schemas) {
            String name = schema.getVersion().getName().toUpperCase();
            if (versionNames.contains(name)) {
                throw new TeslaSchemaException(String.format("Duplicated schema name \"%s\". Schema name is case insensitive.", name));
            }
            versionNames.add(name);
        }
    }

    public Collection<Schema> getSchemas() {
        return this.schemas;
    }

    public List<MergedClass> getClasses() {
        return this.classes;
    }

    public List<MergedEnum> getEnumes() {
        return this.enums;
    }
}

