/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler;

import com.expedia.tesla.SchemaVersion;
import com.expedia.tesla.schema.Enum;
import com.expedia.tesla.schema.EnumEntry;
import com.expedia.tesla.schema.Schema;
import com.expedia.tesla.schema.TeslaSchemaException;
import com.expedia.tesla.schema.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class MergedEnum
extends Enum {
    private Map<SchemaVersion, Schema> schemas = new TreeMap<SchemaVersion, Schema>();
    private Map<SchemaVersion, Enum> enumDefinitions = new TreeMap<SchemaVersion, Enum>();

    public static List<MergedEnum> merge(List<Schema> schemas) throws TeslaSchemaException {
        TreeSet<String> enums = new TreeSet<String>();
        for (Schema schema : schemas) {
            for (Type type : schema.getTypes()) {
                if (!(type instanceof Enum)) continue;
                enums.add(((Enum)type).getName());
            }
        }
        ArrayList<MergedEnum> mcs = new ArrayList<MergedEnum>();
        for (String name : enums) {
            mcs.add(new MergedEnum(name, schemas));
        }
        return mcs;
    }

    private MergedEnum(String name, List<Schema> schemas) throws TeslaSchemaException {
        super(name, null, null);
        ArrayList<Collection<EnumEntry>> versions = new ArrayList<Collection<EnumEntry>>();
        String description = null;
        for (Schema schema : schemas) {
            Type type = schema.findType(Enum.nameToId((String)name));
            if (!(type instanceof Enum)) continue;
            Enum enumDef = (Enum)type;
            versions.add(enumDef.getEntries());
            description = enumDef.getDescription();
            this.schemas.put(schema.getVersion(), schema);
            this.enumDefinitions.put(schema.getVersion(), enumDef);
        }
        this.define(this.mergeEntries(versions), description);
    }

    public Collection<Schema> getVersions() {
        return this.schemas.values();
    }

    public Map<SchemaVersion, Enum> getEnumVersions() {
        return this.enumDefinitions;
    }

    private Collection<EnumEntry> mergeEntries(Collection<Collection<EnumEntry>> versions) throws TeslaSchemaException {
        LinkedHashMap<String, EnumEntry> allEntries = new LinkedHashMap<String, EnumEntry>();
        for (Collection<EnumEntry> schemaVersion : versions) {
            for (EnumEntry entry : schemaVersion) {
                EnumEntry e = (EnumEntry)allEntries.get(entry.getName());
                if (e != null) {
                    if (e.getValue() == entry.getValue()) continue;
                    throw new TeslaSchemaException(String.format("Conflict enum values for '%s.%s' ( %d vs %d).", this.getName(), e.getName(), e.getValue(), entry.getValue()));
                }
                allEntries.put(entry.getName(), entry);
            }
        }
        return new ArrayList<EnumEntry>(allEntries.values());
    }
}

