/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.tesla.compiler;

import com.expedia.tesla.SchemaVersion;
import com.expedia.tesla.schema.Array;
import com.expedia.tesla.schema.Class;
import com.expedia.tesla.schema.Field;
import com.expedia.tesla.schema.Nullable;
import com.expedia.tesla.schema.Poly;
import com.expedia.tesla.schema.Reference;
import com.expedia.tesla.schema.Schema;
import com.expedia.tesla.schema.TeslaSchemaException;
import com.expedia.tesla.schema.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MergedClass
extends Class {
    private String name;
    private List<String> baseTypeNames = new ArrayList<String>();
    private List<Field> fields;
    private List<Field> inheritedFields;
    private List<Field> allFields;
    private Map<SchemaVersion, Schema> schemas = new HashMap<SchemaVersion, Schema>();
    private Map<SchemaVersion, Class> classDefinitions = new HashMap<SchemaVersion, Class>();
    private String description;

    public static List<MergedClass> merge(List<Schema> schemas) throws TeslaSchemaException {
        HashSet<String> classes = new HashSet<String>();
        for (Schema schema : schemas) {
            for (Type type : schema.getTypes()) {
                if (!(type instanceof Class)) continue;
                classes.add(((Class)type).getName());
            }
        }
        ArrayList<MergedClass> mcs = new ArrayList<MergedClass>();
        for (String clssName : classes) {
            mcs.add(new MergedClass(clssName, schemas));
        }
        return mcs;
    }

    private MergedClass(String name, List<Schema> schemas) throws TeslaSchemaException {
        super(name);
        ArrayList<List<Field>> fieldVersions = new ArrayList<List<Field>>();
        ArrayList<List<Field>> inheritedFieldVersions = new ArrayList<List<Field>>();
        HashSet baseTypeNames = new HashSet();
        String description = null;
        for (Schema schema : schemas) {
            Type def = schema.findType(Class.nameToId((String)name));
            if (!(def instanceof Class)) continue;
            Class clss = (Class)def;
            fieldVersions.add(clss.getFields());
            inheritedFieldVersions.add(clss.getInheritedFields());
            if (clss.getBaseTypeNames() != null) {
                baseTypeNames.addAll(clss.getBaseTypeNames());
            }
            description = clss.getDescription();
            this.schemas.put(schema.getVersion(), schema);
            this.classDefinitions.put(schema.getVersion(), clss);
        }
        this.name = name;
        this.baseTypeNames.addAll(baseTypeNames);
        this.description = description;
        this.fields = this.mergeFields(fieldVersions);
        this.inheritedFields = this.mergeFields(inheritedFieldVersions);
        this.allFields = new ArrayList<Field>();
        this.allFields.addAll(this.inheritedFields);
        this.allFields.addAll(this.fields);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Merged class requires a name");
        }
        this.name = name;
    }

    public String getShortName() {
        return Class.toShortName((String)this.name);
    }

    public String getNameSpace() {
        return Class.toNameSpace((String)this.name);
    }

    public void setNameSpace(String namespace) {
        if (namespace == null || namespace.isEmpty()) {
            this.setName(this.getShortName());
        } else {
            this.setName(namespace + '.' + this.getShortName());
        }
    }

    public List<String> getBaseTypeNames() {
        return this.baseTypeNames;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<Schema> getVersions() {
        return this.schemas.values();
    }

    public Map<SchemaVersion, Class> getClassVersions() {
        return this.classDefinitions;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<Field> getInheritedFields() {
        return this.inheritedFields;
    }

    public List<Field> getAllFields() {
        return this.allFields;
    }

    private List<Field> mergeFields(List<List<Field>> fieldVersions) throws TeslaSchemaException {
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (List<Field> fields : fieldVersions) {
            for (Field field : fields) {
                boolean exist = false;
                for (Field f : allFields) {
                    if (f.getName().compareTo(field.getName()) != 0) continue;
                    exist = true;
                    if (MergedClass.areFieldTypesCompatible(f.getType(), field.getType())) continue;
                    throw new TeslaSchemaException(String.format("Field '%s' of class '%s' has incompatible type in different schema versions: '%s' vs '%s'", field.getName(), this.name, f.getType().getTypeId(), field.getType().getTypeId()));
                }
                if (exist) continue;
                allFields.add(field);
            }
        }
        return allFields;
    }

    public static boolean areFieldTypesCompatible(Type t1, Type t2) {
        if (t1.isNullable()) {
            return MergedClass.areFieldTypesCompatible(((Nullable)t1).getElementType(), t2);
        }
        if (t2.isNullable()) {
            return MergedClass.areFieldTypesCompatible(t1, ((Nullable)t2).getElementType());
        }
        if (t1.isReference()) {
            return MergedClass.areFieldTypesCompatible(((Reference)t1).getElementType(), t2);
        }
        if (t2.isReference()) {
            return MergedClass.areFieldTypesCompatible(t1, ((Reference)t2).getElementType());
        }
        if (t1.isPrimitive()) {
            return t1 == t2;
        }
        if (t1.isUserType()) {
            return t1.getTypeId().equals(t2.getTypeId());
        }
        if (t1.isArray() && t2.isArray()) {
            return MergedClass.areFieldTypesCompatible(((Array)t1).getElementType(), ((Array)t2).getElementType());
        }
        if (t1.isMap() && t2.isMap()) {
            return MergedClass.areFieldTypesCompatible(((com.expedia.tesla.schema.Map)t1).getKeyType(), ((com.expedia.tesla.schema.Map)t2).getKeyType()) && MergedClass.areFieldTypesCompatible(((com.expedia.tesla.schema.Map)t1).getValueType(), ((com.expedia.tesla.schema.Map)t2).getValueType());
        }
        return t1.isPoly() || t2.isPoly();
    }

    public Set<Type> referedUserTypes() {
        HashSet<Type> result = new HashSet<Type>();
        for (Field f : this.getAllFields()) {
            result.addAll(this.referedUserTypes(f.getType()));
        }
        return result;
    }

    public Set<Type> referedUserTypes(Type t) {
        Set<Object> result = new HashSet();
        if (t.isArray()) {
            result = this.referedUserTypes(((Array)t).getElementType());
        } else if (t.isMap()) {
            com.expedia.tesla.schema.Map map = (com.expedia.tesla.schema.Map)t;
            result.addAll(this.referedUserTypes(map.getKeyType()));
            result.addAll(this.referedUserTypes(map.getValueType()));
        } else if (t.isNullable()) {
            result = this.referedUserTypes(((Nullable)t).getElementType());
        } else if (t.isPoly()) {
            Poly pt = (Poly)t;
            for (Type et : pt.getElementTypes()) {
                result.addAll(this.referedUserTypes(et));
            }
        } else if (t.isUserType()) {
            result.add(t);
        }
        return result;
    }
}

