/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.graphql.generator.types;

import com.expedia.graphql.TopLevelObject;
import com.expedia.graphql.exceptions.InvalidQueryTypeException;
import com.expedia.graphql.exceptions.InvalidSchemaException;
import com.expedia.graphql.generator.SchemaGenerator;
import com.expedia.graphql.generator.TypeBuilder;
import com.expedia.graphql.generator.extensions.KClassExtensionsKt;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lcom/expedia/graphql/generator/types/QueryBuilder;", "Lcom/expedia/graphql/generator/TypeBuilder;", "generator", "Lcom/expedia/graphql/generator/SchemaGenerator;", "(Lcom/expedia/graphql/generator/SchemaGenerator;)V", "getQueryObject", "Lgraphql/schema/GraphQLObjectType;", "queries", "", "Lcom/expedia/graphql/TopLevelObject;", "graphql-kotlin"})
public final class QueryBuilder
extends TypeBuilder {
    @NotNull
    public final GraphQLObjectType getQueryObject(@NotNull List<TopLevelObject> queries) throws InvalidSchemaException {
        Intrinsics.checkParameterIsNotNull(queries, (String)"queries");
        if (queries.isEmpty()) {
            throw (Throwable)new InvalidSchemaException();
        }
        GraphQLObjectType.Builder queryBuilder = new GraphQLObjectType.Builder();
        queryBuilder.name(this.getConfig().getTopLevelNames().getQuery());
        for (TopLevelObject query : queries) {
            GraphQLDirective it;
            if (KClassExtensionsKt.isNotPublic(query.getKClass())) {
                throw (Throwable)new InvalidQueryTypeException(query.getKClass());
            }
            Iterable $this$forEach$iv = this.getGenerator().directives$graphql_kotlin((KAnnotatedElement)query.getKClass());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (GraphQLDirective)element$iv;
                boolean bl = false;
                queryBuilder.withDirective(it);
            }
            $this$forEach$iv = KClassExtensionsKt.getValidFunctions(query.getKClass(), this.getConfig().getHooks());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KFunction)element$iv;
                boolean bl = false;
                GraphQLFieldDefinition function = SchemaGenerator.function$graphql_kotlin$default(this.getGenerator(), (KFunction)it, query.getObj(), false, 4, null);
                GraphQLFieldDefinition functionFromHook = this.getConfig().getHooks().didGenerateQueryType((KFunction<?>)it, function);
                queryBuilder.field(functionFromHook);
            }
        }
        GraphQLObjectType graphQLObjectType = queryBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphQLObjectType, (String)"queryBuilder.build()");
        return graphQLObjectType;
    }

    public QueryBuilder(@NotNull SchemaGenerator generator) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        super(generator);
    }
}

