/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.graphql.generator.extensions;

import com.expedia.graphql.exceptions.CouldNotGetNameOfKClassException;
import com.expedia.graphql.generator.SchemaFiltersKt;
import com.expedia.graphql.hooks.SchemaGeneratorHooks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\"\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\"\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\b*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u00a8\u0006\u0014"}, d2={"findConstructorParamter", "Lkotlin/reflect/KParameter;", "Lkotlin/reflect/KClass;", "name", "", "getInputClassName", "getSimpleName", "getValidFunctions", "", "Lkotlin/reflect/KFunction;", "hooks", "Lcom/expedia/graphql/hooks/SchemaGeneratorHooks;", "getValidProperties", "Lkotlin/reflect/KProperty;", "isArray", "", "isEnum", "isInterface", "isList", "isUnion", "graphql-kotlin"})
public final class KClassExtensionsKt {
    @NotNull
    public static final List<KProperty<?>> getValidProperties(@NotNull KClass<?> $receiver, @NotNull SchemaGeneratorHooks hooks) {
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)hooks, (String)"hooks");
        Iterable $receiver$iv = KClasses.getDeclaredMemberProperties($receiver);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KProperty1 it = (KProperty1)element$iv$iv;
            if (!hooks.isValidProperty((KProperty)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block5: {
                KProperty1 prop = (KProperty1)element$iv$iv;
                Iterable $receiver$iv2 = SchemaFiltersKt.getPropertyFilters();
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv2) {
                        Function2 it = (Function2)element$iv;
                        if (((Boolean)it.invoke((Object)prop, $receiver)).booleanValue()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<KFunction<?>> getValidFunctions(@NotNull KClass<?> $receiver, @NotNull SchemaGeneratorHooks hooks) {
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)hooks, (String)"hooks");
        Iterable $receiver$iv = KClasses.getDeclaredMemberFunctions($receiver);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KFunction it = (KFunction)element$iv$iv;
            if (!hooks.isValidFunction(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block5: {
                KFunction func = (KFunction)element$iv$iv;
                Iterable $receiver$iv2 = SchemaFiltersKt.getFunctionFilters();
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv2) {
                        Function1 it = (Function1)element$iv;
                        if (((Boolean)it.invoke((Object)func)).booleanValue()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final KParameter findConstructorParamter(@NotNull KClass<?> $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        KFunction kFunction = KClasses.getPrimaryConstructor($receiver);
        return kFunction != null ? KCallables.findParameterByName((KCallable)((KCallable)kFunction), (String)name) : null;
    }

    public static final boolean isInterface(@NotNull KClass<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return JvmClassMappingKt.getJavaClass($receiver).isInterface();
    }

    public static final boolean isUnion(@NotNull KClass<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return KClassExtensionsKt.isInterface($receiver) && KClasses.getDeclaredMemberProperties($receiver).isEmpty() && KClasses.getDeclaredMemberFunctions($receiver).isEmpty();
    }

    public static final boolean isEnum(@NotNull KClass<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return KClasses.isSubclassOf($receiver, (KClass)Reflection.getOrCreateKotlinClass(Enum.class));
    }

    public static final boolean isList(@NotNull KClass<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return KClasses.isSubclassOf($receiver, (KClass)Reflection.getOrCreateKotlinClass(List.class));
    }

    public static final boolean isArray(@NotNull KClass<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return JvmClassMappingKt.getJavaClass($receiver).isArray();
    }

    @NotNull
    public static final String getSimpleName(@NotNull KClass<?> $receiver) throws CouldNotGetNameOfKClassException {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        String string = $receiver.getSimpleName();
        if (string == null) {
            throw (Throwable)new CouldNotGetNameOfKClassException($receiver);
        }
        return string;
    }

    @NotNull
    public static final String getInputClassName(@NotNull KClass<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        return KClassExtensionsKt.getSimpleName($receiver) + "Input";
    }
}

