/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.sql;

import exp.libs.db.sql.bean.DataSourceBean;
import exp.libs.db.sql.bean.PdmColumn;
import exp.libs.db.sql.bean.PdmTable;
import exp.libs.utils.file.FileTemplate;
import exp.libs.utils.file.FileUtils;
import exp.libs.utils.os.JavaUtils;
import exp.libs.utils.str.StrUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class _DBUtils {
    private static final Logger log = LoggerFactory.getLogger(_DBUtils.class);
    private static final String TEMPLATE_DB_BEAN = "/exp/libs/db/sql/db-bean.tpl";
    private static final String TEMPLATE_PROXOOL = "/exp/libs/db/sql/proxool.tpl";
    private Set<String> registeredDS = new HashSet<String>(4);
    private static volatile _DBUtils instance;

    private _DBUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static _DBUtils getInstn() {
        if (instance != null) return instance;
        Class<_DBUtils> clazz = _DBUtils.class;
        synchronized (_DBUtils.class) {
            if (instance != null) return instance;
            instance = new _DBUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean registerToProxool(DataSourceBean ds) {
        boolean isOk = false;
        if (ds != null && !StrUtils.isEmpty((String)ds.getId())) {
            if (this.registeredDS.contains(ds.getId())) {
                isOk = true;
            } else {
                Set<String> set = this.registeredDS;
                synchronized (set) {
                    if (this.registeredDS.contains(ds.getId())) {
                        isOk = true;
                    } else {
                        try {
                            String proxoolXml = _DBUtils.createProxoolXml(ds);
                            StringReader reader = new StringReader(proxoolXml);
                            JAXPConfigurator.configure((Reader)reader, (boolean)false);
                            this.registeredDS.add(ds.getId());
                            isOk = true;
                        }
                        catch (Exception e) {
                            log.error("\u6ce8\u518c\u6570\u636e\u6e90\u5230proxool\u8fde\u63a5\u6c60\u5931\u8d25.", (Throwable)e);
                        }
                    }
                }
            }
        }
        return isOk;
    }

    private static String createProxoolXml(DataSourceBean ds) throws Exception {
        FileTemplate tpl = new FileTemplate(TEMPLATE_PROXOOL, "ISO-8859-1");
        tpl.set("alias", ds.getId());
        tpl.set("driver-url", ds.getUrl());
        tpl.set("driver-class", ds.getDriver());
        tpl.set("username", ds.getUsername());
        tpl.set("password", ds.getPassword());
        tpl.set("characterEncoding", ds.getCharset());
        tpl.set("maximum-active-time", String.valueOf(ds.getMaximumActiveTime()));
        tpl.set("house-keeping-test-sql", ds.getHouseKeepingTestSql());
        tpl.set("house-keeping-sleep-time", String.valueOf(ds.getHouseKeepingSleepTime()));
        tpl.set("simultaneous-build-throttle", String.valueOf(ds.getSimultaneousBuildThrottle()));
        tpl.set("maximum-connection-count", String.valueOf(ds.getMaximumConnectionCount()));
        tpl.set("minimum-connection-count", String.valueOf(ds.getMinimumConnectionCount()));
        tpl.set("maximum-new-connections", String.valueOf(ds.getMaximumNewConnections()));
        tpl.set("prototype-count", String.valueOf(ds.getPrototypeCount()));
        tpl.set("maximum-connection-lifetime", String.valueOf(ds.getMaximumConnectionLifetime()));
        tpl.set("test-before-use", String.valueOf(ds.isTestBeforeUse()));
        tpl.set("test-after-use", String.valueOf(ds.isTestAfterUse()));
        tpl.set("trace", String.valueOf(ds.isTrace()));
        return tpl.getContent();
    }

    protected static void createBeanFromDB(Connection conn, String packageName, String outDirPath, List<String> exportTableList) throws Exception {
        DatabaseMetaData dmd = conn.getMetaData();
        ResultSet tableInfos = _DBUtils.getTableInfo(dmd);
        while (tableInfos.next()) {
            String tableName = tableInfos.getObject("TABLE_NAME").toString();
            if (tableName.toLowerCase().indexOf("bin$") != -1 || exportTableList != null && exportTableList.size() > 0 && !exportTableList.contains(tableName)) continue;
            LinkedList<String> colNameList = new LinkedList<String>();
            HashMap<String, String> colTypeMap = new HashMap<String, String>();
            ResultSet colInfos = _DBUtils.getColumnInfo(dmd, tableName);
            while (colInfos.next()) {
                String colType = _DBUtils.toJavaType(colInfos.getString("TYPE_NAME"));
                String colName = colInfos.getString(4);
                colNameList.add(colName);
                colTypeMap.put(colName, colType);
            }
            String pkColumnName = "";
            ResultSet pkRS = dmd.getPrimaryKeys(null, null, tableName);
            if (pkRS.next()) {
                pkColumnName = (String)pkRS.getObject(4);
            }
            String outData = _DBUtils.createBeanData(tableName, colNameList, colTypeMap, pkColumnName, packageName);
            String outFilePath = StrUtils.concat((String[])new String[]{outDirPath, "/", _DBUtils.getHumpTableName(tableName), ".java"});
            File outFile = FileUtils.createFile((String)outFilePath);
            FileUtils.write((File)outFile, (String)outData, (String)"ISO-8859-1", (boolean)false);
        }
    }

    protected static void createBeanFromPDM(String pdmPath, String packageName, String outDirPath, List<String> exportTableList) throws Exception {
        ArrayList<PdmTable> pdmTableList = new ArrayList<PdmTable>();
        HashMap<String, String> xmlnsMap = new HashMap<String, String>();
        xmlnsMap.put("o", "object");
        SAXReader saxReader = new SAXReader();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(pdmPath), "UTF-8");
        Document document = saxReader.read((Reader)reader);
        XPath x = document.createXPath("//o:Table");
        x.setNamespaceURIs(xmlnsMap);
        List elms = x.selectNodes((Object)document);
        for (Element eTable : elms) {
            PdmTable pdmTable = new PdmTable();
            pdmTable.setTableName(eTable.elementText("Code"));
            Iterator eColumnIts = eTable.elementIterator();
            while (eColumnIts.hasNext()) {
                Element eColumn = (Element)eColumnIts.next();
                _DBUtils.setColumnInfo(pdmTable, eColumn);
                pdmTableList.add(pdmTable);
            }
        }
        for (PdmTable pdmTable : pdmTableList) {
            String tableName = pdmTable.getTableName().toString();
            if (exportTableList != null && exportTableList.size() > 0 && !exportTableList.contains(tableName)) continue;
            LinkedList<String> colNameList = new LinkedList<String>();
            HashMap<String, String> colTypeMap = new HashMap<String, String>();
            List<PdmColumn> pdmCols = pdmTable.getColumns();
            for (PdmColumn pdmCol : pdmCols) {
                String colName = pdmCol.getName();
                String colType = pdmCol.getType();
                colNameList.add(colName);
                colTypeMap.put(colName, colType);
            }
            String pkColumnName = "";
            String outData = _DBUtils.createBeanData(tableName, colNameList, colTypeMap, pkColumnName, packageName);
            String outFilePath = StrUtils.concat((String[])new String[]{outDirPath, "/", _DBUtils.getHumpTableName(tableName), ".java"});
            File outFile = FileUtils.createFile((String)outFilePath);
            FileUtils.write((File)outFile, (String)outData, (String)"ISO-8859-1", (boolean)false);
        }
    }

    private static String createBeanData(String tableName, List<String> colNameList, Map<String, String> colTypeMap, String pkColumnName, String packageName) {
        String uppHumpColName;
        String lowHumpColName;
        String colType;
        StringBuilder sb = new StringBuilder();
        int colNum = colNameList.size();
        FileTemplate beanClazz = new FileTemplate(TEMPLATE_DB_BEAN, "ISO-8859-1");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = sdf.format(new Date());
        beanClazz.set("date", date);
        beanClazz.set("package_path", packageName);
        String clazzName = _DBUtils.getHumpTableName(tableName);
        beanClazz.set("class_name", clazzName);
        sb.setLength(0);
        for (String colName : colNameList) {
            colType = colTypeMap.get(colName);
            String humpColName = _DBUtils.getHumpColumnName(colName, false);
            sb.append("    /** ").append(colName).append(" */\r\n");
            sb.append("    private ").append(colType).append(" ");
            sb.append(humpColName).append(";\r\n\r\n");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("class_member", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            colType = colTypeMap.get(colName);
            String uppHumpColName2 = _DBUtils.getHumpColumnName(colName, true);
            String lowHumpColName2 = _DBUtils.getHumpColumnName(colName, false);
            sb.append("    /**\r\n");
            sb.append("     * get").append(uppHumpColName2).append("\r\n");
            sb.append("     * @return ").append(colType).append("\r\n");
            sb.append("     */\r\n");
            sb.append("    public ").append(colType);
            sb.append(" get").append(uppHumpColName2).append("() {\r\n");
            sb.append("        return this.").append(lowHumpColName2);
            sb.append(";\r\n    }\r\n\r\n");
            sb.append("    /**\r\n");
            sb.append("     * set").append(uppHumpColName2).append("\r\n");
            sb.append("     * @param ").append(lowHumpColName2);
            sb.append(" ").append(lowHumpColName2).append(" to set\r\n");
            sb.append("     */\r\n");
            sb.append("    public void");
            sb.append(" set").append(uppHumpColName2);
            sb.append("(").append(colType).append(" ");
            sb.append(lowHumpColName2).append(") {\r\n");
            sb.append("        this.").append(lowHumpColName2).append(" = ");
            sb.append(lowHumpColName2).append(";\r\n    }\r\n\r\n");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("getter_and_setter", sb.toString());
        beanClazz.set("table_name", tableName);
        sb.setLength(0);
        for (String colName : colNameList) {
            sb.append(colName).append(", ");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("insert_column", sb.toString());
        sb.setLength(0);
        for (int i = 0; i < colNum; ++i) {
            sb.append("?, ");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("insert_column_placeholder", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            if (colNum > 1 && pkColumnName != null && !"".equals(pkColumnName) && pkColumnName.equals(colName)) continue;
            sb.append(colName).append(" = ?, ");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("update_column", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            lowHumpColName = _DBUtils.getHumpColumnName(colName, false);
            sb.append(colName).append(" AS '");
            sb.append(lowHumpColName).append("', ");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("select_column", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            uppHumpColName = _DBUtils.getHumpColumnName(colName, true);
            sb.append("                bean.get").append(uppHumpColName);
            sb.append("(),\r\n");
        }
        sb.setLength(sb.length() - 3);
        beanClazz.set("insert_params", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            if (colNum > 1 && pkColumnName != null && !"".equals(pkColumnName) && pkColumnName.equals(colName)) continue;
            uppHumpColName = _DBUtils.getHumpColumnName(colName, true);
            sb.append("                bean.get").append(uppHumpColName);
            sb.append("(),\r\n");
        }
        sb.setLength(sb.length() - 3);
        beanClazz.set("update_params", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            sb.append("    /**\r\n");
            sb.append("     * get column name\r\n");
            sb.append("     * @return ").append(colName).append("\r\n");
            sb.append("     */\r\n");
            sb.append("    public final static String CN$");
            sb.append(colName.toUpperCase()).append("() {\r\n");
            sb.append("        return \"").append(colName);
            sb.append("\";\r\n    }\r\n\r\n");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("get_column_name", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            lowHumpColName = _DBUtils.getHumpColumnName(colName, false);
            sb.append("    /**\r\n");
            sb.append("     * get java name\r\n");
            sb.append("     * @return ").append(lowHumpColName);
            sb.append("\r\n     */\r\n");
            sb.append("    public final static String JN$");
            sb.append(colName.toUpperCase()).append("() {\r\n");
            sb.append("        return \"").append(lowHumpColName);
            sb.append("\";\r\n    }\r\n\r\n");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("get_java_name", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            sb.append(colName).append(", ");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("all_column_names", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            lowHumpColName = _DBUtils.getHumpColumnName(colName, false);
            sb.append(lowHumpColName).append(", ");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("all_java_names", sb.toString());
        sb.setLength(0);
        for (String colName : colNameList) {
            uppHumpColName = _DBUtils.getHumpColumnName(colName, true);
            String lowHumpColName3 = _DBUtils.getHumpColumnName(colName, false);
            sb.append("        sb.append(\"\\t").append(colName);
            sb.append('/').append(lowHumpColName3).append("\").append(");
            sb.append("\" = \").append(get");
            sb.append(uppHumpColName).append("()).append(\"\\r\\n\");");
            sb.append("\r\n");
        }
        sb.setLength(sb.length() - 2);
        beanClazz.set("to_string", sb.toString());
        return beanClazz.getContent();
    }

    private static void setColumnInfo(PdmTable pdmTable, Element eColumns) {
        if (eColumns.getName().equals("Columns")) {
            ArrayList<PdmColumn> columnList = new ArrayList<PdmColumn>();
            Iterator childColumns = eColumns.elementIterator();
            while (childColumns.hasNext()) {
                Element column = (Element)childColumns.next();
                PdmColumn pdmCol = new PdmColumn();
                pdmCol.setCode(column.elementText("Code"));
                pdmCol.setName(column.elementText("Name"));
                pdmCol.setType(_DBUtils.toJavaType(column.elementText("DataType")));
                pdmCol.setComment(column.elementText("Comment"));
                columnList.add(pdmCol);
            }
            pdmTable.setColumns(columnList);
        }
    }

    private static String getHumpTableName(String tableName) {
        String tmpName = tableName;
        if (tmpName != null && tmpName.contains("_")) {
            StringBuffer sb = new StringBuffer();
            while (tmpName.startsWith("_")) {
                tmpName = tmpName.substring(1);
            }
            while (tmpName.endsWith("_")) {
                tmpName = tmpName.substring(0, tmpName.length() - 1);
            }
            while (tmpName.startsWith("_")) {
                tmpName = tmpName.substring(1);
            }
            tmpName = tmpName.toLowerCase();
            char[] charArray = tmpName.toCharArray();
            sb.append((char)(charArray[0] - 32));
            for (int i = 1; i < charArray.length; ++i) {
                if (charArray[i] == '_') {
                    sb.append((char)(charArray[++i] - 32));
                    continue;
                }
                sb.append(charArray[i]);
            }
            tmpName = sb.toString();
        } else {
            tmpName = StrUtils.upperAtFirst((String)tmpName);
        }
        if (JavaUtils.isJavaKeyWord((String)tmpName)) {
            tmpName = "$" + tmpName;
        }
        return tmpName;
    }

    private static String getHumpColumnName(String columnName, boolean firstUpper) {
        String tmpName = columnName;
        if (tmpName != null && tmpName.contains("_")) {
            StringBuilder sb = new StringBuilder();
            while (tmpName.startsWith("_")) {
                tmpName = tmpName.substring(1);
            }
            if (tmpName.charAt(1) == '_') {
                tmpName = tmpName.substring(2);
            }
            while (tmpName.endsWith("_")) {
                tmpName = tmpName.substring(0, tmpName.length() - 1);
            }
            tmpName = tmpName.toLowerCase();
            char[] charArray = tmpName.toCharArray();
            if (firstUpper) {
                sb.append((char)(charArray[0] - 32));
            } else {
                sb.append(charArray[0]);
            }
            for (int i = 1; i < charArray.length; ++i) {
                if (charArray[i] == '_') {
                    sb.append((char)(charArray[++i] - 32));
                    continue;
                }
                sb.append(charArray[i]);
            }
            tmpName = sb.toString();
        } else {
            tmpName = firstUpper ? StrUtils.upperAtFirst((String)tmpName) : StrUtils.lowerAtFirst((String)tmpName);
        }
        if (JavaUtils.isJavaKeyWord((String)tmpName)) {
            tmpName = "_" + tmpName;
        }
        return tmpName;
    }

    private static ResultSet getTableInfo(DatabaseMetaData dmd) throws SQLException {
        String[] types = new String[]{"TABLE"};
        String dbName = dmd.getDatabaseProductName();
        ResultSet tableInfos = null;
        if (dbName.toLowerCase().equals("oracle")) {
            tableInfos = dmd.getTables(null, dmd.getUserName().toUpperCase(), null, types);
        } else if (dbName.toLowerCase().equals("mysql")) {
            tableInfos = dmd.getTables(null, null, null, types);
        } else if (dbName.toLowerCase().equals("sqlite")) {
            tableInfos = dmd.getTables(null, null, null, types);
        } else if (dbName.equals("Adaptive Server Enterprise")) {
            tableInfos = dmd.getTables(null, null, null, types);
        } else if (dbName.toLowerCase().equals("sqlserver")) {
            tableInfos = dmd.getTables(null, null, null, types);
        }
        return tableInfos;
    }

    private static ResultSet getColumnInfo(DatabaseMetaData dmd, String tableName) throws SQLException {
        String dbName = dmd.getDatabaseProductName();
        ResultSet colInfo = null;
        if (dbName.toLowerCase().equals("oracle")) {
            colInfo = dmd.getColumns(null, dmd.getUserName().toUpperCase(), tableName, null);
        } else if (dbName.toLowerCase().equals("mysql")) {
            colInfo = dmd.getColumns(null, "%", tableName, "%");
        } else if (dbName.toLowerCase().equals("sqlite")) {
            colInfo = dmd.getColumns(null, "%", tableName, "%");
        } else if (dbName.equals("Adaptive Server Enterprise")) {
            colInfo = dmd.getColumns(null, null, tableName, null);
        } else if (dbName.toLowerCase().equals("sqlserver")) {
            colInfo = dmd.getColumns(null, null, tableName, null);
        }
        return colInfo;
    }

    private static String toJavaType(String dbType) {
        String javaType = "";
        javaType = (dbType = dbType.toLowerCase()).equals("float") ? "float" : (dbType.equals("double") ? "Double" : (dbType.equals("int") || dbType.equals("smallint") || dbType.equals("mediumint") || dbType.equals("tinyint") || dbType.equals("integer") || dbType.matches("int\\([1-9]\\)") ? "Integer" : (dbType.equals("number") || dbType.equals("long") || dbType.equals("bigint") || dbType.matches("int\\(\\d{2,}\\)") ? "Long" : (dbType.equals("date") ? "java.util.Date" : (dbType.equals("time") ? "java.sql.Time" : (dbType.equals("datetime") || dbType.startsWith("timestamp") ? "java.sql.Timestamp" : (dbType.startsWith("varchar") || dbType.startsWith("char") || dbType.startsWith("varchar2") || dbType.startsWith("nvarchar2") || dbType.startsWith("longtext") || dbType.startsWith("text") || dbType.equals("mediumtext") || dbType.equals("enum") ? "String" : (dbType.equals("numeric") || dbType.equals("decimal") ? "java.math.BigDecimal" : (dbType.equals("blob") ? "java.sql.Blob" : ("clob".equals(dbType) ? "java.sql.Clob" : "String"))))))))));
        return javaType;
    }
}

