/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.sql;

import exp.libs.db.sql._DBUtils;
import exp.libs.db.sql.bean.DataSourceBean;
import exp.libs.envm.DBType;
import exp.libs.utils.concurrent.ThreadUtils;
import exp.libs.utils.io.IOUtils;
import exp.libs.utils.str.StrUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtils {
    private static final Logger log = LoggerFactory.getLogger(DBUtils.class);
    private static final long RECONN_INTERVAL = 10000L;
    private static final int RECONN_LIMIT = 10;

    protected DBUtils() {
    }

    public static void setAutoShutdownPool(boolean auto) {
        if (auto) {
            ProxoolFacade.enableShutdownHook();
        } else {
            ProxoolFacade.disableShutdownHook();
        }
    }

    public static void shutdownPool() {
        DBUtils.shutdownPool(0);
    }

    public static void shutdownPool(int delay) {
        ProxoolFacade.shutdown((int)(delay < 0 ? 0 : delay));
    }

    public static boolean testConn(DataSourceBean ds) {
        boolean isOk = false;
        if (ds != null) {
            Connection conn = null;
            try {
                Class.forName(ds.getDriver());
                conn = DriverManager.getConnection(ds.getUrl(), ds.getUsername(), ds.getPassword());
                isOk = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            DBUtils.close(conn);
        }
        return isOk;
    }

    public static DBType judgeDBType(Connection conn) {
        DBType db = DBType.UNKNOW;
        if (conn == null) {
            return db;
        }
        try {
            String driver = conn.getMetaData().getDatabaseProductName();
            if (driver.toUpperCase().contains("MYSQL")) {
                db = DBType.MYSQL;
            } else if (driver.toUpperCase().contains("ORACLE")) {
                db = DBType.ORACLE;
            } else if (driver.toUpperCase().contains("ADAPTIVE SERVER ENTERPRISE")) {
                db = DBType.SYBASE;
            } else if (driver.toUpperCase().contains("SQLITE")) {
                db = DBType.SQLITE;
            } else if (driver.toUpperCase().contains("SQLSERVER")) {
                db = DBType.MSSQL;
            } else if (driver.toUpperCase().contains("POSTGRESQL")) {
                db = DBType.POSTGRESQL;
            } else if (driver.toUpperCase().contains("RMIJDBC") || driver.toUpperCase().contains("OBJECTWEB")) {
                db = DBType.ACCESS;
            } else if (driver.toUpperCase().contains("DB2")) {
                db = DBType.IBM;
            }
        }
        catch (SQLException e) {
            log.error("\u5224\u65ad\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25", (Throwable)e);
        }
        return db;
    }

    public static Connection getConn(DataSourceBean ds) {
        return DBUtils.getConn(ds, 10);
    }

    public static Connection getConn(DataSourceBean ds, int retry) {
        Connection conn = null;
        if (ds == null) {
            return conn;
        }
        int cnt = 0;
        while ((conn = DBUtils._getConn(ds)) == null) {
            ThreadUtils.tSleep((long)10000L);
            if (retry < 0 || ++cnt < retry) continue;
        }
        return conn;
    }

    private static Connection _getConn(DataSourceBean ds) {
        Connection conn = DBUtils.getConnByPool(ds);
        if (conn == null) {
            conn = DBUtils.getConnByJDBC(ds);
        }
        return conn;
    }

    public static Connection getConnByPool(DataSourceBean ds) {
        Connection conn;
        block3: {
            conn = null;
            if (ds != null) {
                try {
                    _DBUtils.getInstn().registerToProxool(ds);
                    Class.forName(DBType.PROXOOL.DRIVER);
                    conn = DriverManager.getConnection(DBType.PROXOOL.JDBCURL.replace("<alias>", ds.getId()));
                }
                catch (Throwable e) {
                    String errMsg = e.getMessage();
                    if (errMsg != null && errMsg.contains("maximum connection count (0/0)")) break block3;
                    log.error("\u83b7\u53d6\u6570\u636e\u5e93 [{}] \u8fde\u63a5\u5931\u8d25.", (Object)ds.getName(), (Object)e);
                }
            }
        }
        return conn;
    }

    public static Connection getConnByJDBC(DataSourceBean ds) {
        Connection conn = null;
        if (ds != null) {
            try {
                Class.forName(ds.getDriver());
                conn = DriverManager.getConnection(ds.getUrl(), ds.getUsername(), ds.getPassword());
            }
            catch (Throwable e) {
                log.error("\u83b7\u53d6\u6570\u636e\u5e93 [{}] \u8fde\u63a5\u5931\u8d25.", (Object)ds.getName(), (Object)e);
            }
        }
        return conn;
    }

    public static void setAutoCommit(Connection conn, boolean autoCommit) {
        if (conn != null) {
            try {
                conn.setAutoCommit(autoCommit);
            }
            catch (SQLException e) {
                log.error("\u5f00/\u5173\u6570\u636e\u5e93\u81ea\u52a8\u63d0\u4ea4\u5931\u8d25.", (Throwable)e);
            }
        }
    }

    public static void commit(Connection conn) {
        if (conn != null) {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                log.error("\u63d0\u4ea4\u6570\u636e\u5e93\u53d8\u66f4\u5931\u8d25.", (Throwable)e);
            }
        }
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25.", (Throwable)e);
            }
        }
    }

    public static boolean createBeanFromDB(Connection conn, String packageName, String outDirPath, String[] exportTables) {
        boolean isOk = true;
        try {
            List<String> exportTableList = exportTables == null ? null : Arrays.asList(exportTables);
            _DBUtils.createBeanFromDB(conn, packageName, outDirPath, exportTableList);
        }
        catch (Exception e) {
            isOk = false;
            log.error("\u6784\u9020JavaBean\u5931\u8d25.", (Throwable)e);
        }
        return isOk;
    }

    public static boolean createBeanFromPDM(String pdmPath, String packageName, String outDirPath, String[] exportTables) {
        boolean isOk = true;
        try {
            List<String> exportTableList = exportTables == null ? null : Arrays.asList(exportTables);
            _DBUtils.createBeanFromPDM(pdmPath, packageName, outDirPath, exportTableList);
        }
        catch (Exception e) {
            isOk = false;
            log.error("\u6784\u9020JavaBean\u5931\u8d25.", (Throwable)e);
        }
        return isOk;
    }

    public static <BEAN> List<BEAN> query(Class<BEAN> clazz, Connection conn, String sql) {
        List beans = new LinkedList();
        try {
            QueryRunner runner = new QueryRunner();
            beans = (List)runner.query(conn, sql, (ResultSetHandler)new BeanListHandler(clazz));
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return beans;
    }

    public static Map<String, String> queryKVS(Connection conn, String sql) {
        HashMap<String, String> kvo = new HashMap<String, String>();
        try {
            int count;
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            ResultSetMetaData rsmd = null;
            while (rs.next() && (count = (rsmd = rs.getMetaData()).getColumnCount()) >= 2) {
                kvo.put(rs.getString(1), rs.getString(2));
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return kvo;
    }

    public static Map<String, Object> queryKVO(Connection conn, String sql) {
        HashMap<String, Object> kvo = new HashMap<String, Object>();
        try {
            int count;
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            ResultSetMetaData rsmd = null;
            while (rs.next() && (count = (rsmd = rs.getMetaData()).getColumnCount()) >= 2) {
                kvo.put(rs.getString(1), rs.getObject(2));
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return kvo;
    }

    public static List<Map<String, String>> queryKVSs(Connection conn, String sql) {
        LinkedList<Map<String, String>> kvsList = new LinkedList<Map<String, String>>();
        try {
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            ResultSetMetaData rsmd = null;
            while (rs.next()) {
                HashMap<String, String> kvs = new HashMap<String, String>();
                rsmd = rs.getMetaData();
                int count = rsmd.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    kvs.put(rsmd.getColumnLabel(i), rs.getString(i));
                }
                kvsList.add(kvs);
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return kvsList;
    }

    public static List<Map<String, Object>> queryKVOs(Connection conn, String sql) {
        LinkedList<Map<String, Object>> kvsList = new LinkedList<Map<String, Object>>();
        try {
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            ResultSetMetaData rsmd = null;
            while (rs.next()) {
                HashMap<String, Object> kvs = new HashMap<String, Object>();
                rsmd = rs.getMetaData();
                int count = rsmd.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    kvs.put(rsmd.getColumnLabel(i), rs.getObject(i));
                }
                kvsList.add(kvs);
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return kvsList;
    }

    public static int queryInt(Connection conn, String sql) {
        int num = -1;
        try {
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            if (rs.next()) {
                num = rs.getInt(1);
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return num;
    }

    public static long queryLong(Connection conn, String sql) {
        long num = -1L;
        try {
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            if (rs.next()) {
                num = rs.getLong(1);
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return num;
    }

    public static String queryCellStr(Connection conn, String sql) {
        String cell = "";
        try {
            ResultSetMetaData rsmd;
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            if (rs.next() && (rsmd = rs.getMetaData()).getColumnCount() > 0) {
                cell = rs.getString(1);
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return cell;
    }

    public static Object queryCellObj(Connection conn, String sql) {
        Object cell = null;
        try {
            ResultSetMetaData rsmd;
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            if (rs.next() && (rsmd = rs.getMetaData()).getColumnCount() > 0) {
                cell = rs.getObject(1);
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return cell;
    }

    public static Map<String, String> queryFirstRowStr(Connection conn, String sql) {
        HashMap<String, String> row = new HashMap<String, String>();
        try {
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            if (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                int count = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    row.put(rsmd.getColumnLabel(i), rs.getString(i));
                }
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return row;
    }

    public static Map<String, Object> queryFirstRowObj(Connection conn, String sql) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        try {
            PreparedStatement pstm = conn.prepareStatement(sql);
            ResultSet rs = pstm.executeQuery();
            if (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                int count = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    row.put(rsmd.getColumnLabel(i), rs.getObject(i));
                }
            }
            rs.close();
            pstm.close();
        }
        catch (Throwable e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return row;
    }

    public static List<String> queryColumnStr(Connection conn, String sql, int col) {
        LinkedList<String> vals = new LinkedList<String>();
        col = col <= 0 ? 1 : col;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = conn.prepareStatement(sql);
            rs = pstm.executeQuery();
            int count = rs.getMetaData().getColumnCount();
            int n = col = col >= count ? count : col;
            while (rs.next()) {
                vals.add(rs.getString(col));
            }
            rs.close();
            pstm.close();
        }
        catch (Exception e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return vals;
    }

    public static List<Object> queryColumnObj(Connection conn, String sql, int col) {
        LinkedList<Object> vals = new LinkedList<Object>();
        col = col <= 0 ? 1 : col;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = conn.prepareStatement(sql);
            rs = pstm.executeQuery();
            int count = rs.getMetaData().getColumnCount();
            int n = col = col >= count ? count : col;
            while (rs.next()) {
                vals.add(rs.getObject(col));
            }
            rs.close();
            pstm.close();
        }
        catch (Exception e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return vals;
    }

    public static boolean execute(Connection conn, String preSql, Object[] params) {
        boolean rst = false;
        try {
            PreparedStatement pstm = conn.prepareStatement(preSql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] == null) {
                        pstm.setString(i + 1, null);
                        continue;
                    }
                    pstm.setObject(i + 1, params[i]);
                }
            }
            pstm.execute();
            pstm.close();
            rst = true;
        }
        catch (Exception e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)preSql, (Object)e);
        }
        return rst;
    }

    public static boolean execute(Connection conn, String sql) {
        boolean isOk = false;
        try {
            PreparedStatement pstm = conn.prepareStatement(sql);
            pstm.execute();
            pstm.close();
            isOk = true;
        }
        catch (Exception e) {
            log.error("\u6267\u884csql\u5931\u8d25: [{}].", (Object)sql, (Object)e);
        }
        return isOk;
    }

    public static String execSP(Connection conn, String proSql, Object[] params) {
        if (conn == null) {
            log.error("DB connection is closed.");
        }
        String result = null;
        DBType dbType = DBUtils.judgeDBType(conn);
        switch (dbType) {
            case MYSQL: {
                result = DBUtils._execSpByMysql(conn, proSql, params);
                break;
            }
            case SYBASE: {
                result = DBUtils._execSpBySybase(conn, proSql, params);
                break;
            }
            case ORACLE: {
                result = DBUtils._execSpByOracle(conn, proSql, params);
                break;
            }
            default: {
                result = "";
                log.error("Unsupport database types.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String _execSpByMysql(Connection conn, String proSql, Object[] params) {
        String result = null;
        if (conn == null) {
            log.error("DB connection is closed.");
            return result;
        }
        if (proSql == null) {
            log.error("Procedure Sql is null.");
            return result;
        }
        int paramNum = params == null ? 0 : params.length;
        int placeNum = StrUtils.count((String)proSql, (char)'?');
        if (placeNum - paramNum != 0) {
            log.error("execute procedure [{}] fail: '?' count doesn't match params count.", (Object)proSql);
            return result;
        }
        CallableStatement cs = null;
        ResultSet rs = null;
        try {
            proSql = proSql.trim();
            if (proSql.matches("^(?i)(call|exec) .*$")) {
                proSql = proSql.substring(5);
            }
            cs = conn.prepareCall("{ CALL " + proSql + " }");
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] == null) {
                        cs.setNull(i + 1, 4);
                        continue;
                    }
                    cs.setObject(i + 1, params[i]);
                }
            }
            cs.executeQuery();
            try {
                do {
                    if ((rs = cs.getResultSet()) == null || !rs.next()) continue;
                    result = rs.getString(1);
                } while (cs.getMoreResults());
            }
            catch (NullPointerException e) {
                result = "";
            }
            IOUtils.close((ResultSet)rs);
        }
        catch (SQLException e) {
            log.error("execute procedure [{}] fail.", (Object)proSql, (Object)e);
            return result;
        }
        finally {
            IOUtils.close(rs);
            IOUtils.close(cs);
        }
        IOUtils.close((Statement)cs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String _execSpBySybase(Connection conn, String proSql, Object[] params) {
        String result = null;
        if (conn == null) {
            log.error("DB connection is closed.");
            return result;
        }
        if (proSql == null) {
            log.error("Procedure Sql is null.");
            return result;
        }
        int paramNum = params == null ? 0 : params.length;
        int placeNum = StrUtils.count((String)proSql, (char)'?');
        if (placeNum - paramNum != 0) {
            log.error("execute procedure [{}] fail: '?' count doesn't match params count.", (Object)proSql);
            return result;
        }
        CallableStatement cs = null;
        try {
            proSql = proSql.trim();
            if (proSql.matches("^(?i)(call|exec) .*$")) {
                proSql = proSql.substring(5);
            }
            cs = conn.prepareCall("{ ? = CALL " + proSql + " }");
            cs.registerOutParameter(1, 2000);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] == null) {
                        cs.setNull(i + 2, 4);
                        continue;
                    }
                    cs.setObject(i + 2, params[i]);
                }
            }
            cs.execute();
            result = cs.getString(1);
            IOUtils.close((Statement)cs);
            return result;
        }
        catch (SQLException e) {
            log.error("execute procedure [{}] fail.", (Object)proSql, (Object)e);
            return result;
        }
        finally {
            IOUtils.close(cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String _execSpByOracle(Connection conn, String proSql, Object[] params) {
        String result = null;
        if (conn == null) {
            log.error("DB connection is closed.");
            return result;
        }
        if (proSql == null) {
            log.error("Procedure Sql is null.");
            return result;
        }
        int paramNum = params == null ? 0 : params.length;
        int placeNum = StrUtils.count((String)proSql, (char)'?');
        int diff = placeNum - paramNum;
        if (diff != 0 && diff != 1) {
            log.error("execute procedure [{}] fail: '?' count doesn't match params count.", (Object)proSql);
            return result;
        }
        CallableStatement cs = null;
        try {
            int i;
            proSql = proSql.trim();
            if (proSql.matches("^(?i)(call|exec) .*$")) {
                proSql = proSql.substring(5);
            }
            cs = conn.prepareCall("{ CALL " + proSql + " }");
            if (params != null) {
                for (i = 0; i < params.length; ++i) {
                    if (params[i] == null) {
                        cs.setNull(i + 1, 4);
                        continue;
                    }
                    cs.setObject(i + 1, params[i]);
                }
            }
            if (diff == 1) {
                i = i == 0 ? 1 : ++i;
                cs.registerOutParameter(i, 12);
            }
            cs.execute();
            result = diff == 1 ? cs.getString(i) : null;
            IOUtils.close((Statement)cs);
            return result;
        }
        catch (SQLException e) {
            log.error("execute procedure [{}] fail.", (Object)proSql, (Object)e);
            return result;
        }
        finally {
            IOUtils.close(cs);
        }
    }

    public static List<Map<String, Object>> callSP(Connection conn, String proSql, Object[] params) {
        if (conn == null) {
            log.error("DB connection is closed.");
        }
        LinkedList<Map<String, Object>> result = null;
        DBType dbType = DBUtils.judgeDBType(conn);
        switch (dbType) {
            case MYSQL: {
                result = DBUtils._callSpByMysqlOrSybase(conn, proSql, params);
                break;
            }
            case SYBASE: {
                result = DBUtils._callSpByMysqlOrSybase(conn, proSql, params);
                break;
            }
            case ORACLE: {
                result = DBUtils._callSpByOracle(conn, proSql, params);
                break;
            }
            default: {
                result = new LinkedList();
                log.error("Unsupport database types.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Map<String, Object>> _callSpByMysqlOrSybase(Connection conn, String proSql, Object[] params) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        if (conn == null) {
            log.error("DB connection is closed.");
            return result;
        }
        if (proSql == null) {
            log.error("Procedure Sql is null.");
            return result;
        }
        int paramNum = params == null ? 0 : params.length;
        int placeNum = StrUtils.count((String)proSql, (char)'?');
        if (placeNum - paramNum != 0) {
            log.error("execute procedure [{}] fail: '?' count doesn't match params count.", (Object)proSql);
            return result;
        }
        CallableStatement cs = null;
        ResultSet rs = null;
        try {
            proSql = proSql.trim();
            if (proSql.matches("^(?i)(call|exec) .*$")) {
                proSql = proSql.substring(5);
            }
            cs = conn.prepareCall("{ CALL " + proSql + " }");
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    cs.setObject(i + 1, params[i]);
                }
            }
            cs.executeQuery();
            do {
                if ((rs = cs.getResultSet()) == null) continue;
                result.clear();
                ResultSetMetaData rsmd = rs.getMetaData();
                int colCnt = rsmd.getColumnCount();
                HashMap<String, Object> rowMap = null;
                while (rs.next()) {
                    rowMap = new HashMap<String, Object>();
                    for (int i = 1; i <= colCnt; ++i) {
                        rowMap.put(rsmd.getColumnLabel(i), rs.getObject(i));
                    }
                    result.add(rowMap);
                }
            } while (cs.getMoreResults());
            IOUtils.close((ResultSet)rs);
        }
        catch (SQLException e) {
            log.error("execute procedure [{}] fail.", (Object)proSql, (Object)e);
            return result;
        }
        IOUtils.close((Statement)cs);
        return result;
        finally {
            IOUtils.close(rs);
            IOUtils.close(cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Map<String, Object>> _callSpByOracle(Connection conn, String proSql, Object[] params) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        if (conn == null) {
            log.error("DB connection is closed.");
            return result;
        }
        if (proSql == null) {
            log.error("Procedure Sql is null.");
            return result;
        }
        int paramNum = params == null ? 0 : params.length;
        int placeNum = StrUtils.count((String)proSql, (char)'?');
        int diff = placeNum - paramNum;
        if (diff != 1) {
            log.error("execute procedure [{}] fail: '?' count doesn't match params count.", (Object)proSql);
            return result;
        }
        CallableStatement cs = null;
        ResultSet rs = null;
        try {
            int i;
            proSql = proSql.trim();
            if (proSql.matches("^(?i)(call|exec) .*$")) {
                proSql = proSql.substring(5);
            }
            cs = conn.prepareCall("{ CALL " + proSql + " }");
            if (params != null) {
                for (i = 0; i < params.length; ++i) {
                    cs.setObject(i + 1, params[i]);
                }
            }
            cs.registerOutParameter(++i, -10);
            cs.execute();
            rs = cs.getResultSet();
            if (rs != null) {
                ResultSetMetaData rsmd = rs.getMetaData();
                int colCnt = rsmd.getColumnCount();
                HashMap<String, Object> rowMap = null;
                while (rs.next()) {
                    rowMap = new HashMap<String, Object>();
                    for (i = 1; i <= colCnt; ++i) {
                        rowMap.put(rsmd.getColumnLabel(i), rs.getObject(i));
                    }
                    result.add(rowMap);
                }
            }
            IOUtils.close((ResultSet)rs);
        }
        catch (SQLException e) {
            log.error("execute procedure [{}] fail.", (Object)proSql, (Object)e);
            return result;
        }
        IOUtils.close((Statement)cs);
        return result;
        finally {
            IOUtils.close(rs);
            IOUtils.close(cs);
        }
    }
}

