/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.redis.bean;

import exp.libs.db.redis.RedisClient;
import exp.libs.db.redis.bean._RedisObject;
import exp.libs.utils.other.ListUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class RedisSet<E extends Serializable>
extends _RedisObject {
    private static final String DEFAULT_SET_NAME = "REDIS_SET";
    private final String SET_NAME;

    public RedisSet(String setName, RedisClient redis) {
        super(redis);
        this.SET_NAME = setName == null ? DEFAULT_SET_NAME : setName;
    }

    public boolean contains(E e) {
        boolean isExist = false;
        if (this.isEmpty() || e == null) {
            return isExist;
        }
        this.alignType();
        try {
            isExist = this.typeIsStr() ? this.redis.existInSet(this.SET_NAME, (String)e) : this.redis.existInSet(this.SET_NAME, (Serializable)e);
        }
        catch (Exception ex) {
            log.error("\u67e5\u8be2redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
        return isExist;
    }

    public boolean isEmpty() {
        return this.size() <= 0L;
    }

    public long size() {
        long size = 0L;
        try {
            size = this.redis.getSetSize(this.SET_NAME);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return size;
    }

    public boolean add(E e) {
        boolean isOk = false;
        if (e == null) {
            return isOk;
        }
        try {
            if (this.typeIsStr() || e instanceof String) {
                this.setTypeStr();
                isOk = this.redis.addStrValsToSet(this.SET_NAME, (String)e) > 0L;
            } else {
                this.setTypeObj();
                isOk = this.redis.addSerialObjsToSet(this.SET_NAME, new Serializable[]{e}) > 0L;
            }
        }
        catch (Exception ex) {
            log.error("\u5199\u5165redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
        return isOk;
    }

    public boolean addAll(E ... es) {
        boolean isOk = false;
        if (es == null) {
            return isOk;
        }
        this.redis.closeAutoCommit();
        isOk = true;
        for (E e : es) {
            isOk &= this.add(e);
        }
        this.redis.commit();
        return isOk;
    }

    public boolean addAll(Set<E> es) {
        boolean isOk = false;
        if (es == null) {
            return isOk;
        }
        this.redis.closeAutoCommit();
        isOk = true;
        for (Serializable e : es) {
            isOk &= this.add(e);
        }
        this.redis.commit();
        return isOk;
    }

    public E getRandom() {
        Object e = null;
        if (this.isEmpty()) {
            return (E)e;
        }
        this.alignType();
        try {
            if (this.typeIsStr()) {
                String str = this.redis.getRandomStrValInSet(this.SET_NAME);
                if (str != null) {
                    e = str;
                }
            } else {
                Object obj = this.redis.getRandomSerialObjInSet(this.SET_NAME);
                if (obj != null) {
                    e = (Serializable)obj;
                }
            }
        }
        catch (Exception ex) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
        return (E)e;
    }

    public Set<E> getAll() {
        HashSet<Object> set = new HashSet<Object>();
        if (this.isEmpty()) {
            return set;
        }
        this.alignType();
        try {
            if (this.typeIsStr()) {
                Set<String> sSet = this.redis.getStrSet(this.SET_NAME);
                if (ListUtils.isNotEmpty(sSet)) {
                    for (String s : sSet) {
                        if (s == null) continue;
                        set.add(s);
                    }
                }
            } else {
                Set<Object> oSet = this.redis.getSerialSet(this.SET_NAME);
                if (ListUtils.isNotEmpty(oSet)) {
                    for (Object o : oSet) {
                        if (o == null) continue;
                        set.add((Serializable)o);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return set;
    }

    public long remove(E ... es) {
        long num = 0L;
        if (this.isEmpty() || ListUtils.isEmpty((Object[])es)) {
            return num;
        }
        this.alignType();
        try {
            if (this.typeIsStr()) {
                for (E e : es) {
                    if (e == null) continue;
                    num += this.redis.delStrValsInSet(this.SET_NAME, (String)e);
                }
            } else {
                for (E e : es) {
                    if (e == null) continue;
                    num += this.redis.delSerialObjsInSet(this.SET_NAME, new Serializable[]{e});
                }
            }
        }
        catch (Exception ex) {
            log.error("\u5220\u9664redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
        return num;
    }

    public boolean clear() {
        boolean isOk = false;
        try {
            isOk = this.redis.delKeys(this.SET_NAME) >= 0L;
        }
        catch (Exception e) {
            log.error("\u5220\u9664redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return isOk;
    }

    private void alignType() {
        if (!this.typeIsNone()) {
            return;
        }
        try {
            Object obj = this.redis.getRandomSerialObjInSet(this.SET_NAME);
            if (obj != null) {
                if (obj instanceof String) {
                    this.setTypeStr();
                } else {
                    this.setTypeObj();
                }
            } else {
                String str = this.redis.getRandomStrValInSet(this.SET_NAME);
                if (str != null) {
                    this.setTypeStr();
                }
            }
        }
        catch (Exception ex) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
    }
}

