/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.redis.bean;

import exp.libs.db.redis.RedisClient;
import exp.libs.db.redis.bean._RedisObject;
import java.io.Serializable;

public class RedisObj<OBJ extends Serializable>
extends _RedisObject {
    private static final String DEFAULT_OBJ_NAME = "REDIS_OBJ";
    private final String OBJ_NAME;

    public RedisObj(String objName, RedisClient redis) {
        super(redis);
        this.OBJ_NAME = objName == null ? DEFAULT_OBJ_NAME : objName;
    }

    public boolean exists() {
        boolean isExist = false;
        try {
            isExist = this.redis.existKey(this.OBJ_NAME);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return isExist;
    }

    public boolean set(OBJ value) {
        boolean isOk = false;
        if (value == null) {
            return isOk;
        }
        try {
            if (this.typeIsStr() || value instanceof String) {
                this.setTypeStr();
                isOk = this.redis.addStrVal(this.OBJ_NAME, (String)value);
            } else {
                this.setTypeObj();
                isOk = this.redis.addSerialObj(this.OBJ_NAME, (Serializable)value);
            }
        }
        catch (Exception e) {
            log.error("\u5199\u5165redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return isOk;
    }

    public boolean append(String value) {
        boolean isOk = false;
        if (value == null || !this.typeIsStr()) {
            return isOk;
        }
        try {
            isOk = this.redis.appendStrVal(this.OBJ_NAME, value) >= 0L;
        }
        catch (Exception e) {
            log.error("\u5199\u5165redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return isOk;
    }

    public OBJ get() {
        Object value = null;
        if (!this.exists()) {
            return (OBJ)value;
        }
        this.alignType();
        try {
            Object obj;
            if (this.typeIsStr()) {
                String str = this.redis.getStrVal(this.OBJ_NAME);
                if (str != null) {
                    value = str;
                }
            } else if (this.typeIsObj() && (obj = this.redis.getSerialObj(this.OBJ_NAME)) != null) {
                value = (Serializable)obj;
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return (OBJ)value;
    }

    public boolean clear() {
        boolean isOk = false;
        try {
            isOk = this.redis.delKeys(this.OBJ_NAME) >= 0L;
        }
        catch (Exception e) {
            log.error("\u5220\u9664redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return isOk;
    }

    private void alignType() {
        if (!this.typeIsNone()) {
            return;
        }
        try {
            Object obj = this.redis.getSerialObj(this.OBJ_NAME);
            if (obj != null) {
                if (obj instanceof String) {
                    this.setTypeStr();
                } else {
                    this.setTypeObj();
                }
            } else {
                String str = this.redis.getStrVal(this.OBJ_NAME);
                if (str != null) {
                    this.setTypeStr();
                }
            }
        }
        catch (Exception ex) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
    }
}

