/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.redis.bean;

import exp.libs.db.redis.RedisClient;
import exp.libs.db.redis.bean._RedisObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RedisMap<VAL extends Serializable>
extends _RedisObject {
    private static final String DEFAULT_MAP_NAME = "REDIS_MAP";
    private final String MAP_NAME;

    public RedisMap(String mapName, RedisClient redis) {
        super(redis);
        this.MAP_NAME = mapName == null ? DEFAULT_MAP_NAME : mapName;
    }

    public boolean containsKey(String key) {
        boolean isExist = false;
        try {
            isExist = this.redis.existKeyInMap(this.MAP_NAME, key);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return isExist;
    }

    public boolean isEmpty() {
        return this.size() <= 0L;
    }

    public long size() {
        long size = 0L;
        try {
            size = this.redis.getMapSize(this.MAP_NAME);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return size;
    }

    public boolean put(String key, VAL value) {
        boolean isOk = false;
        if (key == null || value == null) {
            return isOk;
        }
        try {
            if (this.typeIsStr() || value instanceof String) {
                this.setTypeStr();
                isOk = this.redis.addStrValToMap(this.MAP_NAME, key, (String)value);
            } else {
                this.setTypeObj();
                isOk = this.redis.addSerialObjToMap(this.MAP_NAME, key, (Serializable)value);
            }
        }
        catch (Exception e) {
            log.error("\u5199\u5165redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return isOk;
    }

    public boolean putAll(Map<String, VAL> map) {
        boolean isOk = false;
        if (map == null || map.isEmpty()) {
            return isOk;
        }
        isOk = true;
        this.redis.closeAutoCommit();
        for (String key : map.keySet()) {
            Serializable obj = (Serializable)map.get(key);
            isOk &= this.put(key, obj);
        }
        this.redis.commit();
        return isOk;
    }

    public VAL get(String key) {
        Object value = null;
        if (this.isEmpty() || key == null) {
            return (VAL)value;
        }
        this.alignType(key);
        try {
            Object obj;
            if (this.typeIsStr()) {
                String str = this.redis.getStrValInMap(this.MAP_NAME, key);
                if (str != null) {
                    value = str;
                }
            } else if (this.typeIsObj() && (obj = this.redis.getSerialObjInMap(this.MAP_NAME, key)) != null) {
                value = (Serializable)obj;
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return (VAL)value;
    }

    public Map<String, VAL> getAll() {
        HashMap<String, VAL> map = new HashMap<String, VAL>();
        this.redis.closeAutoCommit();
        Set<String> keys = this.keySet();
        for (String key : keys) {
            VAL val = this.get(key);
            if (val == null) continue;
            map.put(key, val);
        }
        this.redis.commit();
        return map;
    }

    public Set<String> keySet() {
        HashSet keys = null;
        try {
            keys = this.redis.getAllKeysInMap(this.MAP_NAME);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return keys == null ? new HashSet() : keys;
    }

    public Collection<VAL> values() {
        return this.getAll().values();
    }

    public long remove(String ... keys) {
        long num = 0L;
        try {
            num = this.redis.delKeysInMap(this.MAP_NAME, keys);
        }
        catch (Exception e) {
            log.error("\u5220\u9664redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return num;
    }

    public boolean clear() {
        boolean isOk = false;
        try {
            isOk = this.redis.delKeys(this.MAP_NAME) >= 0L;
        }
        catch (Exception e) {
            log.error("\u5220\u9664redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return isOk;
    }

    private void alignType(String key) {
        if (!this.typeIsNone()) {
            return;
        }
        try {
            Object obj = this.redis.getSerialObjInMap(this.MAP_NAME, key);
            if (obj != null) {
                if (obj instanceof String) {
                    this.setTypeStr();
                } else {
                    this.setTypeObj();
                }
            } else {
                String str = this.redis.getStrValInMap(this.MAP_NAME, key);
                if (str != null) {
                    this.setTypeStr();
                }
            }
        }
        catch (Exception ex) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
    }
}

