/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.redis.bean;

import exp.libs.db.redis.RedisClient;
import exp.libs.db.redis.bean._RedisObject;
import exp.libs.utils.other.ListUtils;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class RedisList<E extends Serializable>
extends _RedisObject {
    private static final String DEFAULT_LIST_NAME = "REDIS_LIST";
    private final String LIST_NAME;

    public RedisList(String listName, RedisClient redis) {
        super(redis);
        this.LIST_NAME = listName == null ? DEFAULT_LIST_NAME : listName;
    }

    public boolean isEmpty() {
        return this.size() <= 0L;
    }

    public long size() {
        long size = 0L;
        try {
            size = this.redis.getListSize(this.LIST_NAME);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return size;
    }

    public boolean add(E e) {
        return this.addToTail(e);
    }

    public boolean addToHead(E e) {
        boolean isOk = false;
        if (e == null) {
            return isOk;
        }
        try {
            if (this.typeIsStr() || e instanceof String) {
                this.setTypeStr();
                isOk = this.redis.addStrValsToListHead(this.LIST_NAME, (String)e) > 0L;
            } else {
                this.setTypeObj();
                isOk = this.redis.addSerialObjsToListHead(this.LIST_NAME, new Serializable[]{e}) > 0L;
            }
        }
        catch (Exception ex) {
            log.error("\u5199\u5165redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
        return isOk;
    }

    public boolean addToTail(E e) {
        boolean isOk = false;
        if (e == null) {
            return isOk;
        }
        try {
            if (this.typeIsStr() || e instanceof String) {
                this.setTypeStr();
                isOk = this.redis.addStrValsToListTail(this.LIST_NAME, (String)e) > 0L;
            } else {
                this.setTypeObj();
                isOk = this.redis.addSerialObjsToListTail(this.LIST_NAME, new Serializable[]{e}) > 0L;
            }
        }
        catch (Exception ex) {
            log.error("\u5199\u5165redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
        return isOk;
    }

    public boolean addAll(E ... es) {
        boolean isOk = false;
        if (es == null) {
            return isOk;
        }
        this.redis.closeAutoCommit();
        isOk = true;
        for (E e : es) {
            isOk &= this.add(e);
        }
        this.redis.commit();
        return isOk;
    }

    public boolean addAll(List<E> es) {
        boolean isOk = false;
        if (es == null) {
            return isOk;
        }
        this.redis.closeAutoCommit();
        isOk = true;
        for (Serializable e : es) {
            isOk &= this.add(e);
        }
        this.redis.commit();
        return isOk;
    }

    public E get(long index) {
        Object e = null;
        if (this.isEmpty()) {
            return (E)e;
        }
        this.alignType();
        try {
            if (this.typeIsStr()) {
                String str = this.redis.getStrValInList(this.LIST_NAME, index);
                if (str != null) {
                    e = str;
                }
            } else {
                Object obj = this.redis.getSerialObjInList(this.LIST_NAME, index);
                if (obj != null) {
                    e = (Serializable)obj;
                }
            }
        }
        catch (Exception ex) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
        return (E)e;
    }

    public List<E> getAll() {
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.isEmpty()) {
            return list;
        }
        this.alignType();
        try {
            if (this.typeIsStr()) {
                List<String> sList = this.redis.getStrList(this.LIST_NAME);
                if (ListUtils.isNotEmpty(sList)) {
                    for (String s : sList) {
                        if (s == null) continue;
                        list.add(s);
                    }
                }
            } else {
                List<Object> oList = this.redis.getSerialList(this.LIST_NAME);
                if (ListUtils.isNotEmpty(oList)) {
                    for (Object o : oList) {
                        if (o == null) continue;
                        list.add((Serializable)o);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return list;
    }

    public long remove(E ... es) {
        long num = 0L;
        if (this.isEmpty() || ListUtils.isEmpty((Object[])es)) {
            return num;
        }
        this.alignType();
        try {
            if (this.typeIsStr()) {
                for (E e : es) {
                    if (e == null) continue;
                    num += this.redis.delStrValsInList(this.LIST_NAME, (String)e);
                }
            } else {
                for (E e : es) {
                    if (e == null) continue;
                    num += this.redis.delSerialObjsInList(this.LIST_NAME, (Serializable)e);
                }
            }
        }
        catch (Exception ex) {
            log.error("\u5220\u9664redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
        return num;
    }

    public boolean clear() {
        boolean isOk = false;
        try {
            isOk = this.redis.delKeys(this.LIST_NAME) >= 0L;
        }
        catch (Exception e) {
            log.error("\u5220\u9664redis\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return isOk;
    }

    private void alignType() {
        if (!this.typeIsNone()) {
            return;
        }
        try {
            Object obj = this.redis.getSerialObjInList(this.LIST_NAME, 0L);
            if (obj != null) {
                if (obj instanceof String) {
                    this.setTypeStr();
                } else {
                    this.setTypeObj();
                }
            } else {
                this.setTypeStr();
            }
        }
        catch (Exception ex) {
            log.error("\u8bfb\u53d6redis\u7f13\u5b58\u5931\u8d25", (Throwable)ex);
        }
    }
}

