/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.redis.bean;

import exp.libs.db.sql.bean.DataSourceBean;
import exp.libs.utils.str.StrUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPoolConfig;

public class RedisBean {
    protected static final String DEFAULT_ID = "DEFAULT_REDIS";
    private String id;
    protected static final boolean DEFAULT_CLUSTER = false;
    private boolean cluster;
    protected static final String DEFAULT_SOCKET = "127.0.0.1:6379";
    private Set<String> sockets;
    protected static final String DEFAULT_AUTH = "";
    private String password;
    protected static final int DEFAULT_TIMEOUT = 2000;
    private int timeout;
    protected static final int DEFAULT_MAX_TOTAL = 100;
    private int maxTotal;
    protected static final int DEFAULT_MAX_IDLE = 8;
    private int maxIdle;
    protected static final long DEFAULT_MAX_WAIT = -1L;
    private long maxWaitMillis;
    protected static final boolean DEFAULT_TEST_ON_BORROW = true;
    private boolean testOnBorrow;

    public RedisBean() {
        this.setId(DEFAULT_ID);
        this.setCluster(false);
        this.setPassword(DEFAULT_AUTH);
        this.setTimeout(2000);
        this.setMaxTotal(100);
        this.setMaxIdle(8);
        this.setMaxWaitMillis(-1L);
        this.setTestOnBorrow(true);
        this.sockets = new HashSet<String>();
    }

    public RedisBean(DataSourceBean ds) {
        this();
        if (ds != null) {
            this.setId(ds.getId());
            this.setCluster(false);
            this.addSockets(StrUtils.concat((Object[])new Object[]{ds.getIp(), ":", ds.getPort()}));
            this.setPassword(ds.getPassword());
            this.setTimeout((int)ds.getMaximumActiveTime());
            this.setMaxTotal(ds.getMaximumConnectionCount());
            this.setMaxIdle(ds.getPrototypeCount());
            this.setMaxWaitMillis(ds.getMaximumConnectionLifetime());
            this.setTestOnBorrow(ds.isTestBeforeUse());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = StrUtils.isNotEmpty((String)id) ? id : (StrUtils.isNotEmpty((String)this.id) ? this.id : DEFAULT_ID);
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public void setCluster(boolean cluster) {
        this.cluster = cluster;
    }

    public Set<String> getSockets() {
        return this.sockets;
    }

    public void addSockets(String ... sockets) {
        if (sockets != null) {
            for (String socket : sockets) {
                String[] socks;
                if (StrUtils.isTrimEmpty((String)socket)) continue;
                socket = StrUtils.trimAll((String)socket);
                for (String sock : socks = socket.split(",|\uff0c")) {
                    this.sockets.add(sock);
                }
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StrUtils.isNotEmpty((String)password) ? password : (StrUtils.isNotEmpty((String)this.password) ? this.password : DEFAULT_AUTH);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout >= 0 ? timeout : (this.timeout >= 0 ? this.timeout : 2000);
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal >= 0 ? maxTotal : (this.maxTotal >= 0 ? this.maxTotal : 100);
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        this.maxIdle = maxIdle >= 0 ? maxIdle : (this.maxIdle >= 0 ? this.maxIdle : 8);
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
        if (this.maxWaitMillis < 0L) {
            this.maxWaitMillis = -1L;
        }
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n++++++++++++++++ Redis ++++++++++++++++\r\n");
        sb.append("id : ").append(this.getId()).append("\r\n");
        sb.append("cluster : ").append(this.isCluster()).append("\r\n");
        sb.append("sockets : ").append(this.getSockets()).append("\r\n");
        sb.append("password : ").append(this.getPassword()).append("\r\n");
        sb.append("timeout : ").append(this.getTimeout()).append("\r\n");
        sb.append("maxTotal : ").append(this.getMaxTotal()).append("\r\n");
        sb.append("maxIdle : ").append(this.getMaxIdle()).append("\r\n");
        sb.append("maxWaitMillis : ").append(this.getMaxWaitMillis()).append("\r\n");
        sb.append("testOnBorrow : ").append(this.isTestOnBorrow()).append("\r\n");
        sb.append("-------------------------------------------\r\n");
        return sb.toString();
    }

    public GenericObjectPoolConfig toPoolConfig() {
        GenericObjectPoolConfig poolConfig = this.isCluster() ? new GenericObjectPoolConfig() : new JedisPoolConfig();
        poolConfig.setMaxTotal(this.getMaxTotal());
        poolConfig.setMaxIdle(this.getMaxIdle());
        poolConfig.setMaxWaitMillis(this.getMaxWaitMillis());
        poolConfig.setTestOnBorrow(this.isTestOnBorrow());
        return poolConfig;
    }

    public RedisBean clone() {
        RedisBean _clone = new RedisBean();
        _clone.id = this.id;
        _clone.cluster = this.cluster;
        _clone.sockets = new HashSet<String>(this.sockets);
        _clone.password = this.password;
        _clone.timeout = this.timeout;
        _clone.maxTotal = this.maxTotal;
        _clone.maxIdle = this.maxIdle;
        _clone.maxWaitMillis = this.maxWaitMillis;
        _clone.testOnBorrow = this.testOnBorrow;
        return _clone;
    }
}

