/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.redis;

import exp.libs.db.redis._IJedis;
import exp.libs.utils.other.ListUtils;
import exp.libs.utils.other.ObjUtils;
import exp.libs.utils.str.CharsetUtils;
import exp.libs.utils.str.StrUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

class _JedisCluster
extends JedisCluster
implements _IJedis {
    private static final String CHARSET = "UTF-8";
    private static final String OK = "OK";

    protected _JedisCluster(HostAndPort ... clusterNodes) {
        this((GenericObjectPoolConfig)null, 2000, (String)null, clusterNodes);
    }

    protected _JedisCluster(int timeout, HostAndPort ... clusterNodes) {
        this((GenericObjectPoolConfig)null, timeout, (String)null, clusterNodes);
    }

    protected _JedisCluster(String password, HostAndPort ... clusterNodes) {
        this(null, 2000, password, clusterNodes);
    }

    protected _JedisCluster(int timeout, String password, HostAndPort ... clusterNodes) {
        this(null, timeout, password, clusterNodes);
    }

    protected _JedisCluster(GenericObjectPoolConfig poolConfig, HostAndPort ... clusterNodes) {
        this(poolConfig, 2000, (String)null, clusterNodes);
    }

    protected _JedisCluster(GenericObjectPoolConfig poolConfig, int timeout, HostAndPort ... clusterNodes) {
        this(poolConfig, timeout, (String)null, clusterNodes);
    }

    protected _JedisCluster(GenericObjectPoolConfig poolConfig, String password, HostAndPort ... clusterNodes) {
        this(poolConfig, 2000, password, clusterNodes);
    }

    protected _JedisCluster(GenericObjectPoolConfig poolConfig, int timeout, String password, HostAndPort ... clusterNodes) {
        super(new HashSet(ListUtils.asList((Object[])clusterNodes)), timeout, timeout, 5, StrUtils.isEmpty((String)password) ? null : password, poolConfig == null ? new GenericObjectPoolConfig() : poolConfig);
    }

    private String _transcode(String redisKey) {
        return CharsetUtils.transcode((String)redisKey, (String)CHARSET);
    }

    private byte[] _transbyte(String redisKey) {
        return CharsetUtils.toBytes((String)redisKey, (String)CHARSET);
    }

    private String _transstr(byte[] redisKey) {
        return CharsetUtils.toStr((byte[])redisKey, (String)CHARSET);
    }

    @Override
    @Deprecated
    public boolean isVaild() {
        return false;
    }

    @Override
    @Deprecated
    public void setAutoCommit(boolean autoCommit) {
    }

    @Override
    public void closeAutoCommit() {
    }

    @Override
    @Deprecated
    public void commit() {
    }

    @Override
    public void destory() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean clearAll() {
        return false;
    }

    @Override
    public boolean existKey(String redisKey) {
        boolean isExist = false;
        if (redisKey != null) {
            isExist = super.exists(this._transcode(redisKey));
        }
        return isExist;
    }

    @Override
    public long delKeys(String ... redisKeys) {
        long num = 0L;
        if (redisKeys != null) {
            for (String redisKey : redisKeys) {
                if (redisKey == null) continue;
                num += super.del(this._transcode(redisKey));
            }
        }
        return num;
    }

    @Override
    public boolean addStrVal(String redisKey, String value) {
        boolean isOk = false;
        if (redisKey != null && value != null) {
            isOk = OK.equalsIgnoreCase(super.set(this._transcode(redisKey), value));
        }
        return isOk;
    }

    @Override
    public long appendStrVal(String redisKey, String value) {
        long len = -1L;
        if (redisKey != null && value != null) {
            len = super.append(this._transcode(redisKey), value);
        }
        return len;
    }

    @Override
    public String getStrVal(String redisKey) {
        String value = "";
        if (redisKey != null) {
            value = super.get(this._transcode(redisKey));
        }
        return value;
    }

    @Override
    public boolean addSerialObj(String redisKey, Serializable object) {
        boolean isOk = false;
        if (redisKey != null && object != null) {
            isOk = OK.equalsIgnoreCase(super.set(this._transbyte(redisKey), ObjUtils.toSerializable((Serializable)object)));
        }
        return isOk;
    }

    @Override
    public Object getSerialObj(String redisKey) {
        Object object = null;
        if (redisKey != null) {
            object = ObjUtils.unSerializable((byte[])super.get(this._transbyte(redisKey)));
        }
        return object;
    }

    @Override
    public boolean addStrMap(String redisKey, Map<String, String> map) {
        boolean isOk = false;
        if (redisKey != null && map != null) {
            isOk = OK.equalsIgnoreCase(super.hmset(this._transcode(redisKey), map));
        }
        return isOk;
    }

    @Override
    public boolean addStrValToMap(String redisKey, String key, String value) {
        boolean isOk = false;
        if (redisKey != null && key != null && value != null) {
            isOk = super.hset(this._transcode(redisKey), key, value) >= 0L;
        }
        return isOk;
    }

    @Override
    public Map<String, String> getStrMap(String redisKey) {
        Map map = null;
        if (redisKey != null) {
            map = super.hgetAll(this._transcode(redisKey));
        }
        return map == null ? new HashMap() : map;
    }

    @Override
    public String getStrValInMap(String redisKey, String key) {
        List values;
        String value = null;
        if (redisKey != null && key != null && ListUtils.isNotEmpty((Collection)(values = super.hmget(this._transcode(redisKey), new String[]{key})))) {
            value = (String)values.get(0);
        }
        return value;
    }

    @Override
    public List<String> getStrValsInMap(String redisKey, String ... keys) {
        List values = null;
        if (redisKey != null && keys != null) {
            values = super.hmget(this._transcode(redisKey), keys);
        }
        return values == null ? new LinkedList() : values;
    }

    @Override
    public List<String> getAllStrValsInMap(String redisKey) {
        List values = null;
        if (redisKey != null) {
            values = super.hvals(this._transcode(redisKey));
        }
        return values == null ? new LinkedList() : values;
    }

    @Override
    public boolean addSerialMap(String redisKey, Map<String, Serializable> map) {
        boolean isOk = false;
        if (redisKey != null && map != null) {
            isOk = true;
            byte[] byteKey = this._transbyte(redisKey);
            for (String key : map.keySet()) {
                Serializable object = map.get(key);
                isOk &= super.hset(byteKey, this._transbyte(key), ObjUtils.toSerializable((Serializable)object)) >= 0L;
            }
        }
        return isOk;
    }

    @Override
    public boolean addSerialObjToMap(String redisKey, String key, Serializable object) {
        boolean isOk = false;
        if (redisKey != null && key != null && object != null) {
            isOk = super.hset(this._transbyte(redisKey), this._transbyte(key), ObjUtils.toSerializable((Serializable)object)) >= 0L;
        }
        return isOk;
    }

    @Override
    public Map<String, Object> getSerialMap(String redisKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (redisKey != null) {
            Map byteMap = super.hgetAll(this._transbyte(redisKey));
            for (byte[] key : byteMap.keySet()) {
                byte[] val = (byte[])byteMap.get(key);
                map.put(this._transstr(key), ObjUtils.unSerializable((byte[])val));
            }
        }
        return map;
    }

    @Override
    public Object getSerialObjInMap(String redisKey, String key) {
        List values;
        Object value = null;
        if (redisKey != null && key != null && ListUtils.isNotEmpty((Collection)(values = super.hmget(this._transbyte(redisKey), (byte[][])new byte[][]{this._transbyte(key)})))) {
            value = ObjUtils.unSerializable((byte[])((byte[])values.get(0)));
        }
        return value;
    }

    @Override
    public List<Object> getSerialObjsInMap(String redisKey, String ... keys) {
        LinkedList<Object> values = new LinkedList<Object>();
        if (redisKey != null && keys != null) {
            byte[] byteKey = this._transbyte(redisKey);
            for (String key : keys) {
                List byteVals = super.hmget(byteKey, (byte[][])new byte[][]{this._transbyte(key)});
                if (ListUtils.isEmpty((Collection)byteVals)) {
                    values.add(null);
                    continue;
                }
                values.add(ObjUtils.unSerializable((byte[])((byte[])byteVals.get(0))));
            }
        }
        return values == null ? new LinkedList<Object>() : values;
    }

    @Override
    public List<Object> getAllSerialObjsInMap(String redisKey) {
        LinkedList<Object> values = new LinkedList<Object>();
        if (redisKey != null) {
            byte[] byteKey = this._transbyte(redisKey);
            List byteVals = super.hvals(byteKey);
            for (byte[] byteVal : byteVals) {
                values.add(ObjUtils.unSerializable((byte[])byteVal));
            }
        }
        return values == null ? new LinkedList<Object>() : values;
    }

    @Override
    public boolean existKeyInMap(String redisKey, String key) {
        boolean isExist = false;
        if (redisKey != null && key != null) {
            isExist = super.hexists(this._transcode(redisKey), key);
        }
        return isExist;
    }

    @Override
    public Set<String> getAllKeysInMap(String redisKey) {
        Set keys = new HashSet();
        if (redisKey != null) {
            keys = super.hkeys(this._transcode(redisKey));
        }
        return keys == null ? new HashSet() : keys;
    }

    @Override
    public long delKeysInMap(String redisKey, String ... keys) {
        long num = 0L;
        if (redisKey != null && keys != null) {
            num = super.hdel(this._transcode(redisKey), keys);
        }
        return num;
    }

    @Override
    public long getMapSize(String redisKey) {
        long size = 0L;
        if (redisKey != null) {
            size = super.hlen(this._transcode(redisKey));
        }
        return size;
    }

    @Override
    public long addStrList(String redisKey, List<String> list) {
        long num = 0L;
        if (redisKey != null && list != null) {
            redisKey = this._transcode(redisKey);
            for (String value : list) {
                if (value == null) continue;
                num = super.rpush(redisKey, new String[]{value});
            }
        }
        return num;
    }

    @Override
    public long addStrValsToList(String redisKey, String ... values) {
        return this.addStrValsToListTail(redisKey, values);
    }

    @Override
    public long addStrValsToListHead(String redisKey, String ... values) {
        long num = 0L;
        if (redisKey != null && values != null) {
            redisKey = this._transcode(redisKey);
            for (String value : values) {
                if (value == null) continue;
                num = super.lpush(redisKey, new String[]{value});
            }
        }
        return num;
    }

    @Override
    public long addStrValsToListTail(String redisKey, String ... values) {
        long num = 0L;
        if (redisKey != null && values != null) {
            num = this.addStrList(redisKey, Arrays.asList(values));
        }
        return num;
    }

    @Override
    public List<String> getStrList(String redisKey) {
        return this.getAllStrValsInList(redisKey);
    }

    @Override
    public String getStrValInList(String redisKey, long index) {
        String value = null;
        if (redisKey != null) {
            value = super.lindex(this._transcode(redisKey), index);
        }
        return value;
    }

    @Override
    public List<String> getAllStrValsInList(String redisKey) {
        List values = null;
        if (redisKey != null) {
            values = super.lrange(this._transcode(redisKey), 0L, -1L);
        }
        return values == null ? new LinkedList() : values;
    }

    @Override
    public long delStrValsInList(String redisKey, String value) {
        return this.delStrValsInList(redisKey, value, 0L);
    }

    @Override
    public long delStrValsInList(String redisKey, String value, long count) {
        long num = 0L;
        if (redisKey != null && value != null) {
            num = super.lrem(this._transcode(redisKey), count, value);
        }
        return num;
    }

    @Override
    public long addSerialList(String redisKey, List<Serializable> list) {
        long num = 0L;
        if (redisKey != null && list != null) {
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : list) {
                if (object == null) continue;
                num = super.rpush(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
        }
        return num;
    }

    @Override
    public long addSerialObjsToList(String redisKey, Serializable ... objects) {
        return this.addSerialObjsToListTail(redisKey, objects);
    }

    @Override
    public long addSerialObjsToListHead(String redisKey, Serializable ... objects) {
        long num = 0L;
        if (redisKey != null && objects != null) {
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : objects) {
                if (object == null) continue;
                num = super.lpush(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
        }
        return num;
    }

    @Override
    public long addSerialObjsToListTail(String redisKey, Serializable ... objects) {
        long num = 0L;
        if (redisKey != null && objects != null) {
            num = this.addSerialList(redisKey, Arrays.asList(objects));
        }
        return num;
    }

    @Override
    public long delSerialObjsInList(String redisKey, Serializable object) {
        return this.delSerialObjsInList(redisKey, object, 0L);
    }

    @Override
    public long delSerialObjsInList(String redisKey, Serializable object, long count) {
        long num = 0L;
        if (redisKey != null && object != null) {
            num = super.lrem(this._transbyte(redisKey), count, ObjUtils.toSerializable((Serializable)object));
        }
        return num;
    }

    @Override
    public List<Object> getSerialList(String redisKey) {
        return this.getAllSerialObjsInList(redisKey);
    }

    @Override
    public Object getSerialObjInList(String redisKey, long index) {
        Object object = null;
        if (redisKey != null) {
            object = ObjUtils.unSerializable((byte[])super.lindex(this._transbyte(redisKey), index));
        }
        return object;
    }

    @Override
    public List<Object> getAllSerialObjsInList(String redisKey) {
        List byteVals;
        LinkedList<Object> values = new LinkedList<Object>();
        if (redisKey != null && ListUtils.isNotEmpty((Collection)(byteVals = super.lrange(this._transbyte(redisKey), 0L, -1L)))) {
            for (byte[] byteVal : byteVals) {
                values.add(ObjUtils.unSerializable((byte[])byteVal));
            }
        }
        return values;
    }

    @Override
    public long getListSize(String redisKey) {
        long size = 0L;
        if (redisKey != null) {
            size = super.llen(this._transcode(redisKey));
        }
        return size;
    }

    @Override
    public long addStrSet(String redisKey, Set<String> set) {
        long num = 0L;
        if (redisKey != null && set != null) {
            redisKey = this._transcode(redisKey);
            for (String s : set) {
                num += super.sadd(redisKey, new String[]{s});
            }
        }
        return num;
    }

    @Override
    public long addStrValsToSet(String redisKey, String ... values) {
        long addNum = 0L;
        if (redisKey != null && values != null) {
            addNum = super.sadd(this._transcode(redisKey), values);
        }
        return addNum;
    }

    @Override
    public Set<String> getStrSet(String redisKey) {
        return this.getAllStrValsInSet(redisKey);
    }

    @Override
    public String getRandomStrValInSet(String redisKey) {
        String value = null;
        if (redisKey != null) {
            value = super.srandmember(this._transcode(redisKey));
        }
        return value;
    }

    @Override
    public Set<String> getAllStrValsInSet(String redisKey) {
        Set<String> values = new HashSet<String>();
        if (redisKey != null) {
            values = super.smembers(this._transcode(redisKey));
        }
        return values;
    }

    @Override
    public long delStrValsInSet(String redisKey, String ... values) {
        long num = 0L;
        if (redisKey != null && values != null) {
            num = super.srem(this._transcode(redisKey), values);
        }
        return num;
    }

    @Override
    public boolean existInSet(String redisKey, String value) {
        boolean isExist = false;
        if (redisKey != null && value != null) {
            isExist = super.sismember(this._transcode(redisKey), value);
        }
        return isExist;
    }

    @Override
    public long addSerialSet(String redisKey, Set<Serializable> set) {
        long num = 0L;
        if (redisKey != null && set != null) {
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : set) {
                if (object == null) continue;
                num += super.sadd(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
        }
        return num;
    }

    @Override
    public long addSerialObjsToSet(String redisKey, Serializable ... objects) {
        long num = 0L;
        if (redisKey != null && objects != null) {
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : objects) {
                if (object == null) continue;
                num += super.sadd(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
        }
        return num;
    }

    @Override
    public Set<Object> getSerialSet(String redisKey) {
        return this.getAllSerialObjsInSet(redisKey);
    }

    @Override
    public Object getRandomSerialObjInSet(String redisKey) {
        Object value = null;
        if (redisKey != null) {
            value = ObjUtils.unSerializable((byte[])super.srandmember(this._transbyte(redisKey)));
        }
        return value;
    }

    @Override
    public Set<Object> getAllSerialObjsInSet(String redisKey) {
        Set byteVals;
        HashSet<Object> values = new HashSet<Object>();
        if (redisKey != null && ListUtils.isNotEmpty((Collection)(byteVals = super.smembers(this._transbyte(redisKey))))) {
            for (byte[] byteVal : byteVals) {
                values.add(ObjUtils.unSerializable((byte[])byteVal));
            }
        }
        return values;
    }

    @Override
    public long delSerialObjsInSet(String redisKey, Serializable ... objects) {
        long num = 0L;
        if (redisKey != null && objects != null) {
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : objects) {
                if (object == null) continue;
                num += super.srem(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
        }
        return num;
    }

    @Override
    public boolean existInSet(String redisKey, Serializable object) {
        boolean isExist = false;
        if (redisKey != null && object != null) {
            isExist = super.sismember(this._transbyte(redisKey), ObjUtils.toSerializable((Serializable)object));
        }
        return isExist;
    }

    @Override
    public long getSetSize(String redisKey) {
        long size = 0L;
        if (redisKey != null) {
            size = super.scard(this._transcode(redisKey));
        }
        return size;
    }
}

