/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.redis;

import exp.libs.db.redis._IJedis;
import exp.libs.utils.other.ListUtils;
import exp.libs.utils.other.ObjUtils;
import exp.libs.utils.str.CharsetUtils;
import exp.libs.utils.str.StrUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

class _Jedis
implements _IJedis {
    private static final String CHARSET = "UTF-8";
    private static final String OK = "OK";
    private static final String PONG = "PONG";
    private JedisPool pool;
    private boolean autoCommit;
    private Jedis longJedis;

    protected _Jedis(String ip, int port) {
        this(null, 2000, null, ip, port);
    }

    protected _Jedis(int timeout, String ip, int port) {
        this(null, timeout, null, ip, port);
    }

    protected _Jedis(String password, String ip, int port) {
        this(null, 2000, password, ip, port);
    }

    protected _Jedis(int timeout, String password, String ip, int port) {
        this(null, timeout, password, ip, port);
    }

    protected _Jedis(GenericObjectPoolConfig poolConfig, String ip, int port) {
        this(poolConfig, 2000, null, ip, port);
    }

    protected _Jedis(GenericObjectPoolConfig poolConfig, int timeout, String ip, int port) {
        this(poolConfig, timeout, null, ip, port);
    }

    protected _Jedis(GenericObjectPoolConfig poolConfig, String password, String ip, int port) {
        this(poolConfig, 2000, password, ip, port);
    }

    protected _Jedis(GenericObjectPoolConfig poolConfig, int timeout, String password, String ip, int port) {
        if (poolConfig == null) {
            poolConfig = new JedisPoolConfig();
        }
        this.pool = StrUtils.isTrimEmpty((String)password) ? new JedisPool(poolConfig, ip, port, timeout) : new JedisPool(poolConfig, ip, port, timeout, password);
        this.autoCommit = true;
        this.longJedis = null;
    }

    private String _transcode(String redisKey) {
        return CharsetUtils.transcode((String)redisKey, (String)CHARSET);
    }

    private byte[] _transbyte(String redisKey) {
        return CharsetUtils.toBytes((String)redisKey, (String)CHARSET);
    }

    private String _transstr(byte[] redisKey) {
        return CharsetUtils.toStr((byte[])redisKey, (String)CHARSET);
    }

    private Jedis _getJedis() {
        Jedis conn = null;
        if (this.autoCommit) {
            conn = this.pool.getResource();
        } else if (this.longJedis == null || !this.longJedis.isConnected()) {
            this.longJedis = conn = this.pool.getResource();
        } else {
            conn = this.longJedis;
        }
        return conn;
    }

    private void _close(Jedis jedis) {
        if (!this.autoCommit && jedis == this.longJedis) {
            return;
        }
        if (jedis != null) {
            try {
                jedis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isVaild() {
        Jedis jedis = this._getJedis();
        boolean isOk = this._isVaild(jedis);
        this._close(jedis);
        return isOk;
    }

    private boolean _isVaild(Jedis jedis) {
        boolean isOk = false;
        if (jedis != null) {
            isOk = PONG.equalsIgnoreCase(jedis.ping());
        }
        return isOk;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        if (autoCommit) {
            this._close(this.longJedis);
            this.longJedis = null;
        }
    }

    @Override
    public void closeAutoCommit() {
        this.setAutoCommit(false);
    }

    @Override
    public void commit() {
        this.setAutoCommit(true);
    }

    @Override
    public void destory() {
        this.commit();
        this.pool.close();
    }

    @Override
    public boolean clearAll() {
        Jedis jedis = this._getJedis();
        boolean isOk = OK.equalsIgnoreCase(jedis.flushAll());
        this._close(jedis);
        return isOk;
    }

    @Override
    public boolean existKey(String redisKey) {
        boolean isExist = false;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            isExist = jedis.exists(this._transcode(redisKey));
            this._close(jedis);
        }
        return isExist;
    }

    @Override
    public long delKeys(String ... redisKeys) {
        long num = 0L;
        if (redisKeys != null) {
            Jedis jedis = this._getJedis();
            for (String redisKey : redisKeys) {
                if (redisKey == null) continue;
                num += jedis.del(this._transcode(redisKey));
            }
            this._close(jedis);
        }
        return num;
    }

    @Override
    public boolean addStrVal(String redisKey, String value) {
        boolean isOk = false;
        if (redisKey != null && value != null) {
            Jedis jedis = this._getJedis();
            isOk = OK.equalsIgnoreCase(jedis.set(this._transcode(redisKey), value));
            this._close(jedis);
        }
        return isOk;
    }

    @Override
    public long appendStrVal(String redisKey, String value) {
        long len = -1L;
        if (redisKey != null && value != null) {
            Jedis jedis = this._getJedis();
            len = jedis.append(this._transcode(redisKey), value);
            this._close(jedis);
        }
        return len;
    }

    @Override
    public String getStrVal(String redisKey) {
        String value = "";
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            value = jedis.get(this._transcode(redisKey));
            this._close(jedis);
        }
        return value;
    }

    @Override
    public boolean addSerialObj(String redisKey, Serializable object) {
        boolean isOk = false;
        if (redisKey != null && object != null) {
            Jedis jedis = this._getJedis();
            isOk = OK.equalsIgnoreCase(jedis.set(this._transbyte(redisKey), ObjUtils.toSerializable((Serializable)object)));
            this._close(jedis);
        }
        return isOk;
    }

    @Override
    public Object getSerialObj(String redisKey) {
        Object object = null;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            object = ObjUtils.unSerializable((byte[])jedis.get(this._transbyte(redisKey)));
            this._close(jedis);
        }
        return object;
    }

    @Override
    public boolean addStrMap(String redisKey, Map<String, String> map) {
        boolean isOk = false;
        if (redisKey != null && map != null) {
            Jedis jedis = this._getJedis();
            isOk = OK.equalsIgnoreCase(jedis.hmset(this._transcode(redisKey), map));
            this._close(jedis);
        }
        return isOk;
    }

    @Override
    public boolean addStrValToMap(String redisKey, String key, String value) {
        boolean isOk = false;
        if (redisKey != null && key != null && value != null) {
            Jedis jedis = this._getJedis();
            isOk = jedis.hset(this._transcode(redisKey), key, value) >= 0L;
            this._close(jedis);
        }
        return isOk;
    }

    @Override
    public Map<String, String> getStrMap(String redisKey) {
        Map map = null;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            map = jedis.hgetAll(this._transcode(redisKey));
            this._close(jedis);
        }
        return map == null ? new HashMap() : map;
    }

    @Override
    public String getStrValInMap(String redisKey, String key) {
        String value = null;
        if (redisKey != null && key != null) {
            Jedis jedis = this._getJedis();
            List values = jedis.hmget(this._transcode(redisKey), new String[]{key});
            if (ListUtils.isNotEmpty((Collection)values)) {
                value = (String)values.get(0);
            }
            this._close(jedis);
        }
        return value;
    }

    @Override
    public List<String> getStrValsInMap(String redisKey, String ... keys) {
        List values = null;
        if (redisKey != null && keys != null) {
            Jedis jedis = this._getJedis();
            values = jedis.hmget(this._transcode(redisKey), keys);
            this._close(jedis);
        }
        return values == null ? new LinkedList() : values;
    }

    @Override
    public List<String> getAllStrValsInMap(String redisKey) {
        List values = null;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            values = jedis.hvals(this._transcode(redisKey));
            this._close(jedis);
        }
        return values == null ? new LinkedList() : values;
    }

    @Override
    public boolean addSerialMap(String redisKey, Map<String, Serializable> map) {
        boolean isOk = false;
        if (redisKey != null && map != null) {
            isOk = true;
            Jedis jedis = this._getJedis();
            byte[] byteKey = this._transbyte(redisKey);
            for (String key : map.keySet()) {
                Serializable object = map.get(key);
                isOk &= jedis.hset(byteKey, this._transbyte(key), ObjUtils.toSerializable((Serializable)object)) >= 0L;
            }
            this._close(jedis);
        }
        return isOk;
    }

    @Override
    public boolean addSerialObjToMap(String redisKey, String key, Serializable object) {
        boolean isOk = false;
        if (redisKey != null && key != null && object != null) {
            Jedis jedis = this._getJedis();
            isOk = jedis.hset(this._transbyte(redisKey), this._transbyte(key), ObjUtils.toSerializable((Serializable)object)) >= 0L;
            this._close(jedis);
        }
        return isOk;
    }

    @Override
    public Map<String, Object> getSerialMap(String redisKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            Map byteMap = jedis.hgetAll(this._transbyte(redisKey));
            for (byte[] key : byteMap.keySet()) {
                byte[] val = (byte[])byteMap.get(key);
                map.put(this._transstr(key), ObjUtils.unSerializable((byte[])val));
            }
            this._close(jedis);
        }
        return map;
    }

    @Override
    public Object getSerialObjInMap(String redisKey, String key) {
        Object value = null;
        if (redisKey != null && key != null) {
            Jedis jedis = this._getJedis();
            List values = jedis.hmget(this._transbyte(redisKey), (byte[][])new byte[][]{this._transbyte(key)});
            if (ListUtils.isNotEmpty((Collection)values)) {
                value = ObjUtils.unSerializable((byte[])((byte[])values.get(0)));
            }
            this._close(jedis);
        }
        return value;
    }

    @Override
    public List<Object> getSerialObjsInMap(String redisKey, String ... keys) {
        LinkedList<Object> values = new LinkedList<Object>();
        if (redisKey != null && keys != null) {
            Jedis jedis = this._getJedis();
            byte[] byteKey = this._transbyte(redisKey);
            for (String key : keys) {
                List byteVals = jedis.hmget(byteKey, (byte[][])new byte[][]{this._transbyte(key)});
                if (ListUtils.isEmpty((Collection)byteVals)) {
                    values.add(null);
                    continue;
                }
                values.add(ObjUtils.unSerializable((byte[])((byte[])byteVals.get(0))));
            }
            this._close(jedis);
        }
        return values == null ? new LinkedList<Object>() : values;
    }

    @Override
    public List<Object> getAllSerialObjsInMap(String redisKey) {
        LinkedList<Object> values = new LinkedList<Object>();
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            byte[] byteKey = this._transbyte(redisKey);
            List byteVals = jedis.hvals(byteKey);
            for (byte[] byteVal : byteVals) {
                values.add(ObjUtils.unSerializable((byte[])byteVal));
            }
            this._close(jedis);
        }
        return values == null ? new LinkedList<Object>() : values;
    }

    @Override
    public boolean existKeyInMap(String redisKey, String key) {
        boolean isExist = false;
        if (redisKey != null && key != null) {
            Jedis jedis = this._getJedis();
            isExist = jedis.hexists(this._transcode(redisKey), key);
            this._close(jedis);
        }
        return isExist;
    }

    @Override
    public Set<String> getAllKeysInMap(String redisKey) {
        Set keys = null;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            keys = jedis.hkeys(this._transcode(redisKey));
            this._close(jedis);
        }
        return keys == null ? new HashSet() : keys;
    }

    @Override
    public long delKeysInMap(String redisKey, String ... keys) {
        long num = 0L;
        if (redisKey != null && keys != null) {
            Jedis jedis = this._getJedis();
            num = jedis.hdel(this._transcode(redisKey), keys);
            this._close(jedis);
        }
        return num;
    }

    @Override
    public long getMapSize(String redisKey) {
        long size = 0L;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            size = jedis.hlen(this._transcode(redisKey));
            this._close(jedis);
        }
        return size;
    }

    @Override
    public long addStrList(String redisKey, List<String> list) {
        long num = 0L;
        if (redisKey != null && list != null) {
            Jedis jedis = this._getJedis();
            redisKey = this._transcode(redisKey);
            for (String value : list) {
                if (value == null) continue;
                num = jedis.rpush(redisKey, new String[]{value});
            }
            this._close(jedis);
        }
        return num;
    }

    @Override
    public long addStrValsToList(String redisKey, String ... values) {
        return this.addStrValsToListTail(redisKey, values);
    }

    @Override
    public long addStrValsToListHead(String redisKey, String ... values) {
        long num = 0L;
        if (redisKey != null && values != null) {
            Jedis jedis = this._getJedis();
            redisKey = this._transcode(redisKey);
            for (String value : values) {
                if (value == null) continue;
                num = jedis.lpush(redisKey, new String[]{value});
            }
            this._close(jedis);
        }
        return num;
    }

    @Override
    public long addStrValsToListTail(String redisKey, String ... values) {
        long num = 0L;
        if (redisKey != null && values != null) {
            num = this.addStrList(redisKey, Arrays.asList(values));
        }
        return num;
    }

    @Override
    public List<String> getStrList(String redisKey) {
        return this.getAllStrValsInList(redisKey);
    }

    @Override
    public String getStrValInList(String redisKey, long index) {
        String value = null;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            value = jedis.lindex(this._transcode(redisKey), index);
            this._close(jedis);
        }
        return value;
    }

    @Override
    public List<String> getAllStrValsInList(String redisKey) {
        List values = null;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            values = jedis.lrange(this._transcode(redisKey), 0L, -1L);
            this._close(jedis);
        }
        return values == null ? new LinkedList() : values;
    }

    @Override
    public long delStrValsInList(String redisKey, String value) {
        return this.delStrValsInList(redisKey, value, 0L);
    }

    @Override
    public long delStrValsInList(String redisKey, String value, long count) {
        long num = 0L;
        if (redisKey != null && value != null) {
            Jedis jedis = this._getJedis();
            num = jedis.lrem(this._transcode(redisKey), count, value);
            this._close(jedis);
        }
        return num;
    }

    @Override
    public long addSerialList(String redisKey, List<Serializable> list) {
        long num = 0L;
        if (redisKey != null && list != null) {
            Jedis jedis = this._getJedis();
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : list) {
                if (object == null) continue;
                num = jedis.rpush(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
            this._close(jedis);
        }
        return num;
    }

    @Override
    public long addSerialObjsToList(String redisKey, Serializable ... objects) {
        return this.addSerialObjsToListTail(redisKey, objects);
    }

    @Override
    public long addSerialObjsToListHead(String redisKey, Serializable ... objects) {
        long num = 0L;
        if (redisKey != null && objects != null) {
            Jedis jedis = this._getJedis();
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : objects) {
                if (object == null) continue;
                num = jedis.lpush(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
            this._close(jedis);
        }
        return num;
    }

    @Override
    public long addSerialObjsToListTail(String redisKey, Serializable ... objects) {
        long num = 0L;
        if (redisKey != null && objects != null) {
            num = this.addSerialList(redisKey, Arrays.asList(objects));
        }
        return num;
    }

    @Override
    public long delSerialObjsInList(String redisKey, Serializable object) {
        return this.delSerialObjsInList(redisKey, object, 0L);
    }

    @Override
    public long delSerialObjsInList(String redisKey, Serializable object, long count) {
        long num = 0L;
        if (redisKey != null && object != null) {
            Jedis jedis = this._getJedis();
            num = jedis.lrem(this._transbyte(redisKey), count, ObjUtils.toSerializable((Serializable)object));
            this._close(jedis);
        }
        return num;
    }

    @Override
    public List<Object> getSerialList(String redisKey) {
        return this.getAllSerialObjsInList(redisKey);
    }

    @Override
    public Object getSerialObjInList(String redisKey, long index) {
        Object object = null;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            object = ObjUtils.unSerializable((byte[])jedis.lindex(this._transbyte(redisKey), index));
            this._close(jedis);
        }
        return object;
    }

    @Override
    public List<Object> getAllSerialObjsInList(String redisKey) {
        LinkedList<Object> values = new LinkedList<Object>();
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            List byteVals = jedis.lrange(this._transbyte(redisKey), 0L, -1L);
            if (ListUtils.isNotEmpty((Collection)byteVals)) {
                for (byte[] byteVal : byteVals) {
                    values.add(ObjUtils.unSerializable((byte[])byteVal));
                }
            }
            this._close(jedis);
        }
        return values;
    }

    @Override
    public long getListSize(String redisKey) {
        long size = 0L;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            size = jedis.llen(this._transcode(redisKey));
            this._close(jedis);
        }
        return size;
    }

    @Override
    public long addStrSet(String redisKey, Set<String> set) {
        long num = 0L;
        if (redisKey != null && set != null) {
            Jedis jedis = this._getJedis();
            redisKey = this._transcode(redisKey);
            for (String s : set) {
                num += jedis.sadd(redisKey, new String[]{s});
            }
            this._close(jedis);
        }
        return num;
    }

    @Override
    public long addStrValsToSet(String redisKey, String ... values) {
        long num = 0L;
        if (redisKey != null && values != null) {
            Jedis jedis = this._getJedis();
            num = jedis.sadd(this._transcode(redisKey), values);
            this._close(jedis);
        }
        return num;
    }

    @Override
    public Set<String> getStrSet(String redisKey) {
        return this.getAllStrValsInSet(redisKey);
    }

    @Override
    public String getRandomStrValInSet(String redisKey) {
        String value = null;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            value = jedis.srandmember(this._transcode(redisKey));
            this._close(jedis);
        }
        return value;
    }

    @Override
    public Set<String> getAllStrValsInSet(String redisKey) {
        Set<String> values = new HashSet<String>();
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            values = jedis.smembers(this._transcode(redisKey));
            this._close(jedis);
        }
        return values;
    }

    @Override
    public long delStrValsInSet(String redisKey, String ... values) {
        long num = 0L;
        if (redisKey != null && values != null) {
            Jedis jedis = this._getJedis();
            num = jedis.srem(this._transcode(redisKey), values);
            this._close(jedis);
        }
        return num;
    }

    @Override
    public boolean existInSet(String redisKey, String value) {
        boolean isExist = false;
        if (redisKey != null && value != null) {
            Jedis jedis = this._getJedis();
            isExist = jedis.sismember(this._transcode(redisKey), value);
            this._close(jedis);
        }
        return isExist;
    }

    @Override
    public long addSerialSet(String redisKey, Set<Serializable> set) {
        long num = 0L;
        if (redisKey != null && set != null) {
            Jedis jedis = this._getJedis();
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : set) {
                if (object == null) continue;
                num += jedis.sadd(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
            this._close(jedis);
        }
        return num;
    }

    @Override
    public long addSerialObjsToSet(String redisKey, Serializable ... objects) {
        long num = 0L;
        if (redisKey != null && objects != null) {
            Jedis jedis = this._getJedis();
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : objects) {
                if (object == null) continue;
                num += jedis.sadd(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
            this._close(jedis);
        }
        return num;
    }

    @Override
    public Set<Object> getSerialSet(String redisKey) {
        return this.getAllSerialObjsInSet(redisKey);
    }

    @Override
    public Object getRandomSerialObjInSet(String redisKey) {
        Object value = null;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            value = ObjUtils.unSerializable((byte[])jedis.srandmember(this._transbyte(redisKey)));
            this._close(jedis);
        }
        return value;
    }

    @Override
    public Set<Object> getAllSerialObjsInSet(String redisKey) {
        HashSet<Object> values = new HashSet<Object>();
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            Set byteVals = jedis.smembers(this._transbyte(redisKey));
            if (ListUtils.isNotEmpty((Collection)byteVals)) {
                for (byte[] byteVal : byteVals) {
                    values.add(ObjUtils.unSerializable((byte[])byteVal));
                }
            }
            this._close(jedis);
        }
        return values;
    }

    @Override
    public long delSerialObjsInSet(String redisKey, Serializable ... objects) {
        long num = 0L;
        if (redisKey != null && objects != null) {
            Jedis jedis = this._getJedis();
            byte[] byteKey = this._transbyte(redisKey);
            for (Serializable object : objects) {
                if (object == null) continue;
                num += jedis.srem(byteKey, (byte[][])new byte[][]{ObjUtils.toSerializable((Serializable)object)});
            }
            this._close(jedis);
        }
        return num;
    }

    @Override
    public boolean existInSet(String redisKey, Serializable object) {
        boolean isExist = false;
        if (redisKey != null && object != null) {
            Jedis jedis = this._getJedis();
            isExist = jedis.sismember(this._transbyte(redisKey), ObjUtils.toSerializable((Serializable)object));
            this._close(jedis);
        }
        return isExist;
    }

    @Override
    public long getSetSize(String redisKey) {
        long size = 0L;
        if (redisKey != null) {
            Jedis jedis = this._getJedis();
            size = jedis.scard(this._transcode(redisKey));
            this._close(jedis);
        }
        return size;
    }
}

